/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.math.BigDecimal;

public class RSQLDecimalParam
extends RSQLParam {
    BigDecimal bd;

    public RSQLDecimalParam() {
        super(5, (short)3);
    }

    public RSQLDecimalParam(BigDecimal bd) {
        super(5);
        this.bd = bd;
    }

    public RSQLDecimalParam(short t, BigDecimal bd) {
        super(5, t);
        this.bd = bd;
    }

    @Override
    public String getString() throws RDMException {
        return this.bd.toString();
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return this.bd.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public byte getByte() throws RDMException {
        return (byte)this.bd.intValue();
    }

    @Override
    public short getShort() throws RDMException {
        return (short)this.bd.intValue();
    }

    @Override
    public int getInt() throws RDMException {
        return this.bd.intValue();
    }

    @Override
    public long getLong() throws RDMException {
        return this.bd.longValue();
    }

    @Override
    public float getFloat() throws RDMException {
        return this.bd.floatValue();
    }

    @Override
    public double getDouble() throws RDMException {
        return this.bd.doubleValue();
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return this.bd;
    }

    @Override
    public void setDecimal(String str) throws RDMException {
        this.bd = new BigDecimal(str);
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(5);
        rpc.sendDecimal(this.bd);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.bd = rpc.getDecimal();
    }
}

