/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;

public class RSQLDateParam
extends RSQLParam {
    int d;
    Date date;

    public RSQLDateParam() {
        super(260, (short)3);
    }

    public RSQLDateParam(Date d) throws SQLException {
        super(260);
        this.date = (Date)d.clone();
        try {
            this.d = DateTimeConverter.RDateFromDate(d);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLDateParam(short t, Date d) throws SQLException {
        super(260, t);
        this.date = (Date)d.clone();
        try {
            this.d = DateTimeConverter.RDateFromDate(d);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLDateParam(Date d, Calendar cal) throws SQLException {
        super(260);
        this.date = (Date)d.clone();
        try {
            this.d = DateTimeConverter.RDateFromDate(cal, d);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLDateParam(short t, Date d, Calendar cal) throws SQLException {
        super(260, t);
        this.date = (Date)d.clone();
        try {
            this.d = DateTimeConverter.RDateFromDate(cal, d);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public String getString() throws RDMException {
        return this.date.toString();
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromDate(this.d);
    }

    @Override
    public int getInt() throws RDMException {
        return this.d;
    }

    @Override
    public long getLong() throws RDMException {
        return this.d;
    }

    @Override
    public int getDate() throws RDMException {
        return this.d;
    }

    @Override
    public int[] getTimestamp() throws RDMException {
        int[] ts = new int[]{this.d, 0};
        return ts;
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return new BigDecimal(this.d);
    }

    @Override
    public void setInt(int i) throws RDMException {
        this.d = i;
    }

    @Override
    public void setDate(int d) throws RDMException {
        this.d = d;
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(260);
        rpc.sendInt32(this.d);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.d = rpc.getInt32();
    }
}

