/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.util.RDMException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

class DateTimeConverter {
    private static final int offset1970 = 719163;
    private static final int millisPerDay = 86400000;
    private static final Calendar defaultCalendar = Calendar.getInstance(TimeZone.getDefault());

    DateTimeConverter() {
    }

    protected static Date DateFromRDate(Calendar cal, int date) throws RDMException {
        cal.clear();
        long millisecs = (long)(date - 719163) * 86400000L;
        cal.setTimeInMillis(millisecs - (long)cal.getTimeZone().getOffset(millisecs));
        return new Date(cal.getTime().getTime());
    }

    protected static Time TimeFromRTime(Calendar cal, int time) throws RDMException {
        cal.clear();
        cal.setTimeInMillis((long)(time + 5) / 10L);
        return new Time(cal.getTime().getTime());
    }

    protected static Timestamp TimestampFromRTimestamp(Calendar cal, int date, int time) throws RDMException {
        cal.clear();
        cal.setTimeInMillis((long)(date - 719163) * 86400000L + (long)(time / 10));
        Timestamp ts = new Timestamp(cal.getTime().getTime());
        ts.setNanos(time % 10000 * 100000);
        return ts;
    }

    protected static int RDateFromDate(Date date) throws RDMException {
        return DateTimeConverter.RDateFromDate(defaultCalendar, date);
    }

    protected static int RDateFromDate(Calendar cal, Date date) throws RDMException {
        cal.clear();
        cal.setTime(date);
        return (int)(cal.getTimeInMillis() / 86400000L) + 719163;
    }

    protected static int RTimeFromTime(Time time) throws RDMException {
        return DateTimeConverter.RTimeFromTime(defaultCalendar, time);
    }

    protected static int RTimeFromTime(Calendar cal, Time time) throws RDMException {
        cal.clear();
        cal.setTime(time);
        return (int)(cal.getTimeInMillis() % 86400000L * 10L);
    }

    protected static int[] RTimestampFromTimestamp(Timestamp ts) throws RDMException {
        return DateTimeConverter.RTimestampFromTimestamp(defaultCalendar, ts);
    }

    protected static int[] RTimestampFromTimestamp(Calendar cal, Timestamp ts) throws RDMException {
        cal.clear();
        cal.setTime(ts);
        int[] res = new int[]{(int)(cal.getTimeInMillis() / 86400000L) + 719163, (int)(cal.getTimeInMillis() % 86400000L * 10L) + ts.getNanos() / 100000};
        return res;
    }
}

