/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.util.RDMException;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class CLOBReader
extends Reader {
    RSQLRowSet rs;
    byte[] barr;
    boolean eof;
    int colno;
    int offset;
    int avail;
    int max;
    int bytesRead;

    public CLOBReader(RSQLRowSet rowset, int col, int max) throws RDMException {
        this.rs = rowset;
        this.colno = col;
        this.max = max;
        this.bytesRead = 0;
        this.eof = false;
        this.barr = new byte[1024];
        this.readNextInternal();
    }

    private void readNextInternal() throws RDMException {
        if (!this.eof) {
            this.avail = this.rs.getData(this.colno, this.barr);
            this.offset = 0;
            if (this.avail == 0) {
                this.eof = true;
            } else if (this.barr[this.avail - 1] == 0) {
                --this.avail;
            }
        }
    }

    private void readNext() throws IOException {
        try {
            this.readNextInternal();
        }
        catch (RDMException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.rs != null) {
            this.barr = null;
            this.rs = null;
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.validateOpen();
        if (this.offset == this.avail) {
            this.readNext();
        }
        if (this.eof) {
            return -1;
        }
        if (this.max > 0 && this.bytesRead == this.max) {
            return -1;
        }
        return this.barr[this.offset++];
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int off, int len) throws IOException {
        int ii;
        int bytes;
        this.validateOpen();
        if (c == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > c.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (ii = 0; ii < len; ii += bytes) {
            if (this.offset == this.avail) {
                this.readNext();
            }
            if ((bytes = Math.min(this.avail - this.offset, len)) == 0 || this.max > 0 && (bytes = Math.min(bytes, this.max - this.bytesRead)) == 0) break;
            for (int jj = 0; jj < bytes; ++jj) {
                c[ii + off + jj] = (char)this.barr[this.offset++];
            }
            this.bytesRead += bytes;
        }
        if (ii == off) {
            return -1;
        }
        return ii - off;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int tmp;
        int count = 0;
        this.validateOpen();
        if (target == null) {
            throw new NullPointerException();
        }
        while ((tmp = this.read()) != -1) {
            target.put((char)tmp);
            ++count;
        }
        return count;
    }

    @Override
    public boolean ready() throws IOException {
        this.validateOpen();
        return true;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        long ii;
        int bytes;
        this.validateOpen();
        if (n <= 0L) {
            return 0L;
        }
        for (ii = 0L; ii < n; ii += (long)bytes) {
            if (this.offset == this.avail) {
                this.readNext();
            }
            if ((bytes = (int)Math.min((long)(this.avail - this.offset), n)) == 0 || this.max > 0 && (bytes = Math.min(bytes, this.max - this.bytesRead)) == 0) break;
            this.offset += bytes;
            this.bytesRead += bytes;
        }
        return ii;
    }

    private void validateOpen() throws IOException {
        if (this.rs == null) {
            throw new IOException("InputStream is closed");
        }
    }
}

