/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.TFS;
import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMVersion;
import java.sql.SQLException;
import java.util.ArrayList;

public class TFSJNI
implements TFS {
    long tfs_handle;
    static boolean loadedDLL = false;

    private native int rdmAllocTFS(String var1);

    private native int rdmTFSFree(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSJNI(String optString) throws SQLException {
        try {
            int ret;
            TFSJNI tFSJNI = this;
            synchronized (tFSJNI) {
                ret = this.rdmAllocTFS(optString);
            }
            if (ret != 0) {
                throw new RDMSQLException(ret);
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeHandle() throws SQLException {
        try {
            int ret;
            TFSJNI tFSJNI = this;
            synchronized (tFSJNI) {
                ret = this.rdmTFSFree(this.tfs_handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(ret);
            }
            this.tfs_handle = -1L;
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public long getHandle() {
        return this.tfs_handle;
    }

    public void setHandle(long tfs_handle) {
        this.tfs_handle = tfs_handle;
    }

    static {
        if (!loadedDLL) {
            ArrayList<String> libList = new ArrayList<String>();
            String verstr = "" + RDMVersion.getMajorVersion();
            if (System.getProperty("java.runtime.name").equals("Android Runtime")) {
                libList.add("rdmpsp-" + verstr);
                libList.add("rdmenc-" + verstr);
                libList.add("rdmtransport-" + verstr);
                libList.add("rdmbase-" + verstr);
                libList.add("rdmha-" + verstr);
                libList.add("rdmhttp-" + verstr);
                libList.add("rdmtfs-" + verstr);
                libList.add("rdmddl-" + verstr);
                libList.add("rdmrdm-" + verstr);
                libList.add("rdmsbase-" + verstr);
                libList.add("rdmxml-" + verstr);
                libList.add("rdmrsql-" + verstr);
            }
            libList.add("rdmjdbcjni-" + verstr);
            try {
                for (String name : libList) {
                    System.loadLibrary(name);
                }
                loadedDLL = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println(e.getMessage());
                System.err.println("The following shared libraries must be available to load:");
                for (String name : libList) {
                    System.err.println("  " + name);
                }
                throw e;
            }
        }
    }
}

