/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMConnection;
import com.raima.rdm.jdbc.RDMDriver;
import com.raima.rdm.jdbc.RDMResultSet;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.RDMException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.logging.Logger;

public class RDMStatement
implements Statement {
    protected RDMConnection conn;
    protected RSQLStatement stmt;
    protected long numModified;
    protected boolean escapeProcessing;
    protected int fetchSize;
    protected int maxRows;
    protected int numcols;
    protected SQLWarning warning;
    protected RDMResultSet rs;
    protected Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    protected String statementString;
    private int cursorScrollable;
    private int cursorUpdateable;
    private int queryTimeout;
    private LinkedList<String> batchStrings;
    private boolean bCloseOnComp;
    protected static final int DEFAULT_MAX_ROWS = 0;
    private static final String className = "RDMStatement";
    private static final String invalidEscapeSyntax = "invalid escape syntax";
    private static final String invalidConstant = "invalid constant";

    protected RDMStatement(RDMConnection conn) throws SQLException {
        if (conn == null) {
            throw new SQLException("Invalid Connection");
        }
        this.conn = conn;
        try {
            this.stmt = conn.getSQL().createStatement(false, false);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.fetchSize = conn.getDefaultFetchSize();
        this.maxRows = 0;
        this.escapeProcessing = true;
        this.batchStrings = null;
        this.warning = null;
        this.bCloseOnComp = false;
        this.statementString = null;
    }

    protected RDMStatement(RDMConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (conn == null) {
            throw new SQLException("Invalid Connection");
        }
        this.conn = conn;
        boolean cursorScrollable = resultSetType != 1003;
        boolean cursorUpdateable = resultSetConcurrency != 1007;
        try {
            this.stmt = conn.getSQL().createStatement(cursorScrollable, cursorUpdateable);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.fetchSize = conn.getDefaultFetchSize();
        this.maxRows = 0;
        this.escapeProcessing = true;
        this.batchStrings = null;
        this.warning = null;
        this.bCloseOnComp = false;
        this.statementString = null;
    }

    public String getStatementString() throws SQLException {
        if (this.stmt == null) {
            throw new SQLException("Invalid Statement");
        }
        return this.statementString;
    }

    private void setStatementString(String statementString) throws SQLException {
        if (this.stmt == null) {
            throw new SQLException("Invalid Statement");
        }
        this.statementString = statementString;
    }

    protected RSQLStatement getSQLStatement() throws SQLException {
        if (this.stmt == null) {
            throw new SQLException("Invalid Statement");
        }
        return this.stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String methodName = "addBatch";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        if (this.batchStrings == null) {
            this.batchStrings = new LinkedList();
        }
        this.batchStrings.add(sql);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void cancel() throws SQLException {
        String methodName = "cancel";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void clearBatch() throws SQLException {
        String methodName = "clearBatch";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        if (this.batchStrings != null) {
            this.batchStrings.clear();
        }
        this.logger.exiting(className, methodName);
    }

    protected void _clearWarnings() {
        this.warning = null;
        this.stmt.clearWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodName = "clearWarnings";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this._clearWarnings();
        this.logger.exiting(className, methodName);
    }

    protected void closeResultSet() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
            if (this.bCloseOnComp) {
                try {
                    this.stmt.close();
                    this.stmt = null;
                }
                catch (RDMException rDMException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() throws SQLException {
        String methodName = "close";
        this.logger.entering(className, methodName);
        if (this.conn != null && this.stmt != null) {
            this.closeResultSet();
            try {
                this.stmt.free();
            }
            catch (RDMException rDMException) {
                // empty catch block
            }
            this.conn.removeFromList(this);
            this.stmt = null;
            this.conn = null;
            this.rs = null;
            this.warning = null;
        }
        this.logger.exiting(className, methodName);
    }

    private boolean do_execute(String methodName, String sql) throws SQLException {
        return this.do_execute(methodName, sql, 2);
    }

    private boolean do_execute(String methodName, String sql, int autoGeneratedKeys) throws SQLException {
        this.closeResultSet();
        this._clearWarnings();
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw this.createSQLException(methodName, invalidEscapeSyntax);
        }
        try {
            this.stmt.execDirect(sql, autoGeneratedKeys);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() == 0) {
            this.numModified = this.rowCount();
            if (this.conn._getAutoCommit()) {
                this.conn.closeResultSets();
            }
        } else {
            this.rs = new RDMResultSet(this, this.maxRows);
            this.rs.setFetchSize(this.fetchSize);
        }
        return this.rs != null;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String methodName = "execute";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        boolean flag = this.do_execute(methodName, sql, 2);
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String methodName = "execute";
        this.logger.entering(className, methodName, new Object[]{sql, autoGeneratedKeys});
        this._validate(methodName);
        boolean flag = this.do_execute(methodName, sql, autoGeneratedKeys);
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String methodName = "execute";
        this.logger.entering(className, methodName, new Object[]{sql, columnIndexes});
        this._validate(methodName);
        if (columnIndexes != null) {
            throw this.createSQLFeatureNotSupportedException(methodName, "returning generated keys not supported");
        }
        boolean flag = this.do_execute(methodName, sql, 2);
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String methodName = "execute";
        this.logger.entering(className, methodName, new Object[]{sql, columnNames});
        this._validate(methodName);
        if (columnNames != null) {
            throw this.createSQLFeatureNotSupportedException(methodName, "returning generated keys not supported");
        }
        boolean flag = this.do_execute(methodName, sql, 2);
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] results;
        String methodName = "executeBatch";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.warning = null;
        boolean failed = false;
        if (this.batchStrings != null) {
            results = new int[this.batchStrings.size()];
            for (int ii = 0; ii < this.batchStrings.size(); ++ii) {
                try {
                    results[ii] = this.executeUpdate(this.batchStrings.get(ii));
                    continue;
                }
                catch (SQLException e) {
                    failed = true;
                    results[ii] = -3;
                }
            }
        } else {
            results = new int[]{};
        }
        if (failed) {
            BatchUpdateException buex = new BatchUpdateException(results);
            this.logger.throwing(className, methodName, buex);
            throw buex;
        }
        this.logger.exiting(className, methodName, results);
        return results;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String methodName = "executeQuery";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw this.createSQLException(methodName, invalidEscapeSyntax);
        }
        this.closeResultSet();
        this._clearWarnings();
        try {
            this.setStatementString(sql);
            this.stmt.execDirect(sql, 2);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() == 0) {
            throw this.createSQLException(methodName, "Statement does not return a ResultSet");
        }
        this.rs = new RDMResultSet(this, this.maxRows);
        this.rs.setFetchSize(this.fetchSize);
        this.logger.exiting(className, methodName, this.rs);
        return this.rs;
    }

    private long do_update(String methodName, String sql, int autoGeneratedKeys) throws SQLException {
        this.closeResultSet();
        this._clearWarnings();
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw this.createSQLException(methodName, invalidConstant);
        }
        if (this.conn._getAutoCommit()) {
            this.conn.closeResultSets();
        }
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw this.createSQLException(methodName, invalidEscapeSyntax);
        }
        try {
            this.stmt.execDirect(sql, autoGeneratedKeys);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() != 0) {
            throw this.createSQLException(methodName, "Statement returns a ResultSet");
        }
        return this.rowCount();
    }

    private long do_update(String methodName, String sql, int[] columnIndexes) throws SQLException {
        this.closeResultSet();
        this._clearWarnings();
        if (this.conn._getAutoCommit()) {
            this.conn.closeResultSets();
        }
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw this.createSQLException(methodName, invalidEscapeSyntax);
        }
        try {
            this.stmt.execDirect(sql, columnIndexes);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() != 0) {
            throw this.createSQLException(methodName, "Statement returns a ResultSet");
        }
        return this.rowCount();
    }

    private long do_update(String methodName, String sql, String[] columnNames) throws SQLException {
        this.closeResultSet();
        this._clearWarnings();
        if (this.conn._getAutoCommit()) {
            this.conn.closeResultSets();
        }
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw this.createSQLException(methodName, invalidEscapeSyntax);
        }
        try {
            this.stmt.execDirect(sql, columnNames);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() != 0) {
            throw this.createSQLException(methodName, "Statement returns a ResultSet");
        }
        return this.rowCount();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String methodName = "executeUpdate";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        long ret = this.do_update(methodName, sql, 2);
        this.logger.exiting(className, methodName, ret);
        return (int)ret;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String methodName = "executeUpdate";
        this.logger.entering(className, methodName, new Object[]{sql, autoGeneratedKeys});
        this._validate(methodName);
        long ret = this.do_update(methodName, sql, autoGeneratedKeys);
        this.logger.exiting(className, methodName, ret);
        return (int)ret;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String methodName = "executeUpdate";
        this.logger.entering(className, methodName, new Object[]{sql, columnIndexes});
        this._validate(methodName);
        long ret = this.do_update(methodName, sql, columnIndexes);
        this.logger.exiting(className, methodName, ret);
        return (int)ret;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String methodName = "executeUdpate";
        this.logger.entering(className, methodName, new Object[]{sql, columnNames});
        this._validate(methodName);
        long ret = this.do_update(methodName, sql, columnNames);
        this.logger.exiting(className, methodName, ret);
        return (int)ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodName = "getConnection";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.conn);
        return this.conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        String methodName = "getFetchDirection";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, 1000);
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        String methodName = "getFetchSize";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.fetchSize);
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String methodName = "getGeneratedKeys";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.rs = new RDMResultSet(this, this.maxRows);
        return this.rs;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        String methodName = "getMaxFieldSize";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        int ret = this.stmt.getMaxFieldSize();
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public int getMaxRows() throws SQLException {
        String methodName = "getMaxRows";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.maxRows);
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean more;
        String methodName = "getMoreResults";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        if (current != 1) {
            throw this.createSQLFeatureNotSupportedException(methodName, "invalid argument to getNextResultSet");
        }
        try {
            more = this.stmt.getMoreResults();
            if (more) {
                this.rs = new RDMResultSet(this, this.maxRows);
                this.rs.setFetchSize(this.fetchSize);
            } else {
                this.numModified = this.rowCount();
            }
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        this.logger.exiting(className, methodName, more);
        return more;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        String methodName = "getQueryTimeout";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.queryTimeout);
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        String methodName = "getResultSet";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.rs);
        return this.rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        String methodName = "getResultSetConcurrency";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        int res = 1007;
        this.logger.exiting(className, methodName, res);
        return res;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        String methodName = "getResultSetHoldability";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, 2);
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        String methodName = "getResultSetType";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, 1003);
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        String methodName = "getUpdateCount";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        long ret = this.rs != null ? -1L : this.numModified;
        this.logger.exiting(className, methodName, ret);
        return (int)ret;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodName = "getWarnings";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.warning);
        return this.warning;
    }

    protected String getCursorName() throws SQLException {
        String name;
        String methodName = "getCursorName";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            name = this.stmt.getCursorName();
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        this.logger.exiting(className, methodName, name);
        return name;
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodName = "isClosed";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, this.stmt == null);
        return this.stmt == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        String methodName = "isPoolable";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, false);
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        String methodName = "closeOnCompletion";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.bCloseOnComp = true;
        this.logger.exiting(className, methodName, this.bCloseOnComp);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        String methodName = "isCloseOnCompletion";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, this.bCloseOnComp);
        return this.bCloseOnComp;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        String methodName = "setCursorName";
        this.logger.entering(className, methodName, name);
        this._validate(methodName);
        if (name == null) {
            throw this.createSQLException(methodName, "java.sql.Statement.setCursorName cannot accept a NULL parameter");
        }
        try {
            this.stmt.setCursorName(name);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        String methodName = "setEscapeProcessing";
        this.logger.entering(className, methodName, enable);
        this._validate(methodName);
        this.escapeProcessing = enable;
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        String methodName = "setFetchDirection";
        this.logger.entering(className, methodName, direction);
        this._validate(methodName);
        if (direction != 1000) {
            throw this.createSQLFeatureNotSupportedException(methodName, "Unsupported fetch direction");
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        String methodName = "setFetchSize";
        this.logger.entering(className, methodName, rows);
        this._validate(methodName);
        if (rows < 0 || this.maxRows > 0 && rows > this.maxRows) {
            throw this.createSQLException(methodName, "Invalid fetch size amount");
        }
        if (rows == 0) {
            this.fetchSize = this.conn.getDefaultFetchSize();
        }
        this.fetchSize = rows;
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        String methodName = "setMaxFieldSize";
        this.logger.entering(className, methodName, max);
        this._validate(methodName);
        if (max < 0) {
            throw this.createSQLException(methodName, "Invalid maximum field size");
        }
        this.stmt.setMaxFieldSize(max);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        String methodName = "setMaxRows";
        this.logger.entering(className, methodName, max);
        this._validate(methodName);
        if (max < 0) {
            throw this.createSQLException(methodName, "Invalid max rows amount");
        }
        this.maxRows = max;
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        String methodName = "setPoolable";
        this.logger.entering(className, methodName, poolable);
        this._validate(methodName);
        if (poolable) {
            throw this.createSQLException(methodName, "Poolable statements not supported");
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        String methodName = "setQueryTimeout";
        this.logger.entering(className, methodName, seconds);
        this._validate(methodName);
        if (seconds != this.queryTimeout) {
            this.queryTimeout = seconds;
            this.conn.setLockTimeout(this.queryTimeout);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    public void addWarning(SQLWarning warn) {
        if (this.warning == null) {
            this.warning = warn;
        } else {
            this.warning.setNextWarning(warn);
        }
    }

    protected int numCols() {
        int type = this.stmt.getType();
        this.numcols = type == 5 || type == 17 ? this.stmt.getNumCols() : 0;
        return this.numcols;
    }

    protected long rowCount() {
        long count = 0L;
        if (this.stmt.getType() != 5) {
            count = this.stmt.getNumRows();
        }
        return count;
    }

    protected void _validate(String methodName) throws SQLException {
        if (this.stmt == null) {
            throw this.createSQLException(methodName, "Invalid Statement");
        }
    }

    protected SQLException createSQLFeatureNotSupportedException(String methodName, String error) throws SQLException {
        SQLFeatureNotSupportedException sqlex = new SQLFeatureNotSupportedException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    protected SQLException createSQLException(String methodName, RDMException e) throws SQLException {
        SQLException sqlex = e.createSQLException();
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    protected SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

