/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.SettingsResultSet;
import com.raima.rdm.jdbc.SettingsRow;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;

public class RDMSettings {
    public static final String PROP_AUTOCOMMIT = "auto commit";
    public static final String PROP_TRANS_ISOLATION = "transaction isolation";
    public static final String PROP_OPENMODE = "open mode";
    public static final String PROP_ROTMODE = "snapshot";
    public static final String PROP_DOCROOT = "document root";
    public static final String PROP_DATEFORMAT = "date format";
    public static final String PROP_LOCKTIMEOUT = "lock timeout";
    public static final String PROP_TFSTYPE = "tfs type";
    public static final String PROP_STORAGE = "storage";
    public static final String PROP_PREFETCHSIZE = "defaultFetchSize";
    public static final String PROP_CACHESIZE = "cache size";
    public static final String PROP_OPTIMIZEPARAMS = "optimize parameters";
    public static final String PROP_APPNAME = "appname";
    private static final String AUTOCOMMIT_ON = "on";
    private static final String AUTOCOMMIT_OFF = "off";
    private static final String AUTOCOMMIT_DEFAULT = "on";
    private static final String AUTOCOMMIT_DESC = "Sets the autocommit mode for the connection";
    private static final boolean AUTOCOMMIT_REQUIRED = false;
    private static final String OPTIMIZEPARAMS_ON = "on";
    private static final String OPTIMIZEPARAMS_OFF = "off";
    private static final String OPTIMIZEPARAMS_DEFAULT = "on";
    private static final String OPTIMIZEPARAMS_DESC = "Sets the optimize parameters mode for the connection";
    private static final boolean OPTIMIZEPARAMS_REQUIRED = false;
    private static final String ROTMODE_ON = "on";
    private static final String ROTMODE_OFF = "off";
    private static final String ROTMODE_DEFAULT = "off";
    private static final String ROTMODE_DESC = "Sets Snapshot mode on or off";
    private static final boolean ROTMODE_REQUIRED = false;
    private static final String STORAGE_ONDISK = "ondisk";
    private static final String STORAGE_INMEM_VOLATILE = "inmemory_volatile";
    private static final String STORAGE_INMEM_KEEP = "inmemory_keep";
    private static final String STORAGE_INMEM_LOAD = "inmemory_load";
    private static final String STORAGE_INMEM_PERSIST = "inmemory_persist";
    private static final String STORAGE_DEFAULT = "";
    private static final String STORAGE_DESC = "Sets the database storage type";
    private static final boolean STORAGE_REQUIRED = false;
    private static final String TRANS_ISOLATION_READ_UNCOMMITTED = "read_uncommitted";
    private static final String TRANS_ISOLATION_READ_COMMITTED = "read_committed";
    private static final String TRANS_ISOLATION_REPEATABLE_READ = "repeatable_read";
    private static final String TRANS_ISOLATION_SERIALIZABLE = "serializable";
    private static final String TRANS_ISOLATION_DEFAULT = "serializable";
    private static final String TRANS_ISOLATION_DESC = "Sets the transaction isolation level for the connection";
    private static final boolean TRANS_ISOLATION_REQUIRED = false;
    private static final String OPENMODE_SHARED = "SHARED";
    private static final String OPENMODE_EXCLUSIVE = "EXCLUSIVE";
    private static final String OPENMODE_READONLY = "READONLY";
    private static final String OPENMODE_SHARED_CREAT = "SHARED_CREAT";
    private static final String OPENMODE_EXCLUSIVE_CREAT = "EXCLUSIVE_CREAT";
    private static final String OPENMODE_EX_NOTRANS = "EXCLUSIVETRANSOFF";
    private static final String OPENMODE_DEFAULT = "SHARED";
    private static final String OPENMODE_DESC = "Sets the open mode for databases - 'SHARED', 'EXCLUSIVE' or 'READONLY'";
    private static final boolean OPENMODE_REQUIRED = false;
    private static final String DATEFORMAT_YYYYMMDD_D = "yyyy-mm-dd";
    private static final String DATEFORMAT_YYYYMMDD_S = "yyyy/mm/dd";
    private static final String DATEFORMAT_MMDDYYYY_D = "mm-dd-yyyy";
    private static final String DATEFORMAT_MMDDYYYY_S = "mm/dd/yyyy";
    private static final String DATEFORMAT_DDMMYYYY_D = "dd-mm-yyyy";
    private static final String DATEFORMAT_DDMMYYYY_S = "dd/mm/yyyy";
    private static final String DATEFORMAT_DEFAULT = "yyyy-mm-dd";
    private static final String DATEFORMAT_DESC = "Sets the date format";
    private static final boolean DATEFORMAT_REQUIRED = false;
    private static final String LOCKTIMEOUT_DEFAULT = "10";
    private static final String LOCKTIMEOUT_DESC = "Sets the lock timeout (in seconds) for the database";
    private static final boolean LOCKTIMEOUT_REQUIRED = false;
    private static final String DOCROOT_DEFAULT = "";
    private static final String DOCROOT_DESC = "Sets the document root for TFSS and TFST systems when using local connections";
    private static final boolean DOCROOT_REQUIRED = false;
    private static final String TFSTYPE_UNSPECIFIED = "default";
    private static final String TFSTYPE_TFST = "embed";
    private static final String TFSTYPE_TFSH = "hybrid";
    private static final String TFSTYPE_TFSR = "remote";
    private static final String TFSTYPE_DEFAULT = "default";
    private static final String TFSTYPE_DESC = "Specifies the TFS type to use when using local connections";
    private static final boolean TFSTYPE_REQUIRED = false;
    private static final String PREFETCHSIZE_DEFAULT = "1";
    private static final String PREFETCHSIZE_DESC = "Sets the prefetch size (in number of rows) for the database";
    private static final boolean PREFETCHSIZE_REQUIRED = false;
    private static final String CACHESIZE_DEFAULT = "20000";
    private static final String CACHESIZE_DESC = "Sets the cache size (in number of objects) for the database";
    private static final boolean CACHESIZE_REQUIRED = false;
    private static final String APPNAME_DEFAULT = "";
    private static final String APPNAME_DESC = "Sets the Android application name (Android only)";
    private static final boolean APPNAME_REQUIRED = false;
    private static boolean on_android = System.getProperty("java.runtime.name").equals("Android Runtime");
    private Properties props = new Properties();

    public RDMSettings(Properties newprops) {
        this.override(newprops);
    }

    public static ResultSet getClientInfo() {
        SettingsRow[] rows = new SettingsRow[12 + (on_android ? 1 : 0)];
        rows[0] = new SettingsRow(PROP_AUTOCOMMIT, 3, "on", AUTOCOMMIT_DESC);
        rows[1] = new SettingsRow(PROP_TRANS_ISOLATION, 16, "serializable", TRANS_ISOLATION_DESC);
        rows[2] = new SettingsRow(PROP_OPENMODE, 2, "SHARED", OPENMODE_DESC);
        rows[3] = new SettingsRow(PROP_ROTMODE, 3, "off", ROTMODE_DESC);
        rows[4] = new SettingsRow(PROP_DOCROOT, 512, "", DOCROOT_DESC);
        rows[5] = new SettingsRow(PROP_DATEFORMAT, 8, "yyyy-mm-dd", DATEFORMAT_DESC);
        rows[6] = new SettingsRow(PROP_LOCKTIMEOUT, 10, LOCKTIMEOUT_DEFAULT, LOCKTIMEOUT_DESC);
        rows[7] = new SettingsRow(PROP_TFSTYPE, 4, "default", TFSTYPE_DESC);
        rows[8] = new SettingsRow(PROP_STORAGE, 17, "", STORAGE_DESC);
        rows[9] = new SettingsRow(PROP_PREFETCHSIZE, 10, PREFETCHSIZE_DEFAULT, PREFETCHSIZE_DESC);
        rows[10] = new SettingsRow(PROP_CACHESIZE, 10, CACHESIZE_DEFAULT, CACHESIZE_DESC);
        rows[11] = new SettingsRow(PROP_OPTIMIZEPARAMS, 3, "on", OPTIMIZEPARAMS_DESC);
        if (on_android) {
            rows[12] = new SettingsRow(PROP_APPNAME, 512, "", APPNAME_DESC);
        }
        return new SettingsResultSet(rows);
    }

    public void override(Properties newprops) {
        String appname;
        String tfstype;
        if (newprops == null) {
            newprops = new Properties();
        }
        this.setAutoCommit(newprops.getProperty(PROP_AUTOCOMMIT, "on").equalsIgnoreCase("on"));
        this.setTransIsolation(this.interpretTransIsolation(newprops.getProperty(PROP_TRANS_ISOLATION, "serializable")));
        this.setOpenMode(newprops.getProperty(PROP_OPENMODE, "SHARED"));
        this.setDateFormat(newprops.getProperty(PROP_DATEFORMAT, "yyyy-mm-dd"));
        this.setLockTimeout(Integer.parseInt(newprops.getProperty(PROP_LOCKTIMEOUT, LOCKTIMEOUT_DEFAULT)));
        this.setROTMode(newprops.getProperty(PROP_ROTMODE, "off").equalsIgnoreCase("on"));
        this.setStorage(newprops.getProperty(PROP_STORAGE, ""));
        this.setPrefetchSize(Integer.parseInt(newprops.getProperty(PROP_PREFETCHSIZE, PREFETCHSIZE_DEFAULT)));
        this.setCacheSize(Integer.parseInt(newprops.getProperty(PROP_CACHESIZE, CACHESIZE_DEFAULT)));
        this.setOptimizeParameters(newprops.getProperty(PROP_OPTIMIZEPARAMS, "on").equalsIgnoreCase("on"));
        String docroot = newprops.getProperty(PROP_DOCROOT);
        if (docroot != null) {
            this.setDocroot(docroot);
        }
        if ((tfstype = newprops.getProperty(PROP_TFSTYPE)) != null) {
            this.setTfsType(tfstype);
        }
        if (on_android && (appname = newprops.getProperty(PROP_APPNAME)) != null) {
            this.setAppName(appname);
        }
    }

    public boolean getAutoCommit() {
        return this.props.getProperty(PROP_AUTOCOMMIT).equalsIgnoreCase("on");
    }

    public void setAutoCommit(boolean autocommit) {
        this.props.setProperty(PROP_AUTOCOMMIT, autocommit ? "on" : "off");
    }

    public boolean getOptimizeParameters() {
        return this.props.getProperty(PROP_OPTIMIZEPARAMS).equalsIgnoreCase("on");
    }

    public void setOptimizeParameters(boolean optParams) {
        this.props.setProperty(PROP_OPTIMIZEPARAMS, optParams ? "on" : "off");
    }

    public boolean getROTMode() {
        return this.props.getProperty(PROP_ROTMODE).equalsIgnoreCase("on");
    }

    public void setROTMode(boolean rotmode) {
        this.props.setProperty(PROP_ROTMODE, rotmode ? "on" : "off");
    }

    public String getStorage() {
        return this.props.getProperty(PROP_STORAGE);
    }

    public void setStorage(String storage) {
        this.props.setProperty(PROP_STORAGE, storage);
    }

    public int interpretTransIsolation(String transIsolation) {
        if (transIsolation.equalsIgnoreCase(TRANS_ISOLATION_READ_UNCOMMITTED)) {
            return 1;
        }
        if (transIsolation.equalsIgnoreCase(TRANS_ISOLATION_READ_COMMITTED)) {
            return 2;
        }
        if (transIsolation.equalsIgnoreCase(TRANS_ISOLATION_REPEATABLE_READ)) {
            return 4;
        }
        if (transIsolation.equalsIgnoreCase("serializable")) {
            return 8;
        }
        return 0;
    }

    public int getTransIsolation() {
        return this.interpretTransIsolation(this.props.getProperty(PROP_TRANS_ISOLATION));
    }

    public void setTransIsolation(int transIsolation) {
        switch (transIsolation) {
            case 1: {
                this.props.setProperty(PROP_TRANS_ISOLATION, TRANS_ISOLATION_READ_UNCOMMITTED);
                break;
            }
            case 2: {
                this.props.setProperty(PROP_TRANS_ISOLATION, TRANS_ISOLATION_READ_COMMITTED);
                break;
            }
            case 4: {
                this.props.setProperty(PROP_TRANS_ISOLATION, TRANS_ISOLATION_REPEATABLE_READ);
                break;
            }
            case 8: {
                this.props.setProperty(PROP_TRANS_ISOLATION, "serializable");
                break;
            }
            default: {
                this.props.setProperty(PROP_TRANS_ISOLATION, "serializable");
            }
        }
    }

    public String getOpenMode() {
        return this.props.getProperty(PROP_OPENMODE);
    }

    public void setOpenMode(String openmode) {
        if (!(openmode.equalsIgnoreCase("SHARED") || openmode.equalsIgnoreCase(OPENMODE_EXCLUSIVE) || openmode.equalsIgnoreCase(OPENMODE_READONLY) || openmode.equalsIgnoreCase(OPENMODE_SHARED_CREAT) || openmode.equalsIgnoreCase(OPENMODE_EXCLUSIVE_CREAT) || openmode.equalsIgnoreCase(OPENMODE_EX_NOTRANS))) {
            openmode = "SHARED";
        }
        this.props.setProperty(PROP_OPENMODE, openmode);
    }

    public boolean getReadOnlyMode() {
        return this.props.getProperty(PROP_OPENMODE).equalsIgnoreCase(OPENMODE_READONLY);
    }

    public String getDateFormat() {
        return this.props.getProperty(PROP_DATEFORMAT);
    }

    public void setDateFormat(String dateFormat) {
        if (dateFormat.equalsIgnoreCase("yyyy-mm-dd") || dateFormat.equalsIgnoreCase(DATEFORMAT_YYYYMMDD_S) || dateFormat.equalsIgnoreCase(DATEFORMAT_MMDDYYYY_D) || dateFormat.equalsIgnoreCase(DATEFORMAT_MMDDYYYY_S) || dateFormat.equalsIgnoreCase(DATEFORMAT_DDMMYYYY_D) || dateFormat.equalsIgnoreCase(DATEFORMAT_DDMMYYYY_S)) {
            this.props.setProperty(PROP_DATEFORMAT, dateFormat);
        } else {
            this.props.setProperty(PROP_DATEFORMAT, "yyyy-mm-dd");
        }
    }

    public int getLockTimeout() {
        return Integer.parseInt(this.props.getProperty(PROP_LOCKTIMEOUT));
    }

    public void setLockTimeout(int timeout) {
        this.props.setProperty(PROP_LOCKTIMEOUT, Integer.toString(timeout));
    }

    public int getPrefetchSize() {
        return Integer.parseInt(this.props.getProperty(PROP_PREFETCHSIZE));
    }

    public int getCacheSize() {
        return Integer.parseInt(this.props.getProperty(PROP_CACHESIZE));
    }

    public void setPrefetchSize(int fetchSize) {
        this.props.setProperty(PROP_PREFETCHSIZE, Integer.toString(fetchSize));
    }

    public void setCacheSize(int cacheSize) {
        this.props.setProperty(PROP_CACHESIZE, Integer.toString(cacheSize));
    }

    public String getDocroot() {
        return this.props.getProperty(PROP_DOCROOT);
    }

    public void setDocroot(String docroot) {
        this.props.setProperty(PROP_DOCROOT, docroot);
    }

    public String getTfsType() {
        return this.props.getProperty(PROP_TFSTYPE);
    }

    public void setTfsType(String tfstype) {
        this.props.setProperty(PROP_TFSTYPE, tfstype);
    }

    public String getAppName() {
        return this.props.getProperty(PROP_APPNAME);
    }

    public void setAppName(String appname) {
        this.props.setProperty(PROP_APPNAME, appname);
    }

    public Properties getProperties() {
        return (Properties)this.props.clone();
    }

    private DriverPropertyInfo createAutoCommitPropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_AUTOCOMMIT, this.props.getProperty(PROP_AUTOCOMMIT, "on"));
        propinfo.choices = new String[2];
        propinfo.choices[0] = "on";
        propinfo.choices[1] = "off";
        propinfo.description = AUTOCOMMIT_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createOptimizeParametersPropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_OPTIMIZEPARAMS, this.props.getProperty(PROP_OPTIMIZEPARAMS, "on"));
        propinfo.choices = new String[2];
        propinfo.choices[0] = "on";
        propinfo.choices[1] = "off";
        propinfo.description = OPTIMIZEPARAMS_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createROTModePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_ROTMODE, this.props.getProperty(PROP_ROTMODE, "off"));
        propinfo.choices = new String[2];
        propinfo.choices[0] = "on";
        propinfo.choices[1] = "off";
        propinfo.description = ROTMODE_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createStoragePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_STORAGE, this.props.getProperty(PROP_STORAGE, ""));
        propinfo.choices = new String[5];
        propinfo.choices[0] = STORAGE_ONDISK;
        propinfo.choices[1] = STORAGE_INMEM_VOLATILE;
        propinfo.choices[2] = STORAGE_INMEM_KEEP;
        propinfo.choices[3] = STORAGE_INMEM_LOAD;
        propinfo.choices[4] = STORAGE_INMEM_PERSIST;
        propinfo.description = STORAGE_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createTransIsolationPropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_TRANS_ISOLATION, this.props.getProperty(PROP_TRANS_ISOLATION, "serializable"));
        propinfo.choices = new String[4];
        propinfo.choices[0] = TRANS_ISOLATION_READ_UNCOMMITTED;
        propinfo.choices[1] = TRANS_ISOLATION_READ_COMMITTED;
        propinfo.choices[2] = TRANS_ISOLATION_REPEATABLE_READ;
        propinfo.choices[3] = "serializable";
        propinfo.description = TRANS_ISOLATION_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createOpenmodePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_OPENMODE, this.props.getProperty(PROP_OPENMODE, "SHARED"));
        propinfo.choices = new String[4];
        propinfo.choices[0] = "SHARED";
        propinfo.choices[1] = OPENMODE_EXCLUSIVE;
        propinfo.choices[2] = OPENMODE_EX_NOTRANS;
        propinfo.choices[3] = OPENMODE_READONLY;
        propinfo.description = OPENMODE_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createDateFormatPropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_DATEFORMAT, this.props.getProperty(PROP_DATEFORMAT, "yyyy-mm-dd"));
        propinfo.choices = new String[6];
        propinfo.choices[0] = "yyyy-mm-dd";
        propinfo.choices[1] = DATEFORMAT_YYYYMMDD_S;
        propinfo.choices[2] = DATEFORMAT_DDMMYYYY_D;
        propinfo.choices[3] = DATEFORMAT_DDMMYYYY_S;
        propinfo.choices[4] = DATEFORMAT_MMDDYYYY_D;
        propinfo.choices[5] = DATEFORMAT_MMDDYYYY_S;
        propinfo.description = DATEFORMAT_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createLockTimeoutPropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_LOCKTIMEOUT, this.props.getProperty(PROP_LOCKTIMEOUT));
        propinfo.choices = null;
        propinfo.description = LOCKTIMEOUT_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createPrefetchSizePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_PREFETCHSIZE, this.props.getProperty(PROP_PREFETCHSIZE));
        propinfo.choices = null;
        propinfo.description = PREFETCHSIZE_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createCacheSizePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_CACHESIZE, this.props.getProperty(PROP_CACHESIZE));
        propinfo.choices = null;
        propinfo.description = CACHESIZE_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createDocrootPropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_DOCROOT, this.props.getProperty(PROP_DOCROOT));
        propinfo.choices = null;
        propinfo.description = DOCROOT_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createTfsTypePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_TFSTYPE, this.props.getProperty(PROP_TFSTYPE));
        propinfo.choices = new String[4];
        propinfo.choices[0] = "default";
        propinfo.choices[1] = TFSTYPE_TFST;
        propinfo.choices[2] = TFSTYPE_TFSH;
        propinfo.choices[3] = TFSTYPE_TFSR;
        propinfo.description = TFSTYPE_DESC;
        propinfo.required = false;
        return propinfo;
    }

    private DriverPropertyInfo createAppNamePropertyInfo() {
        DriverPropertyInfo propinfo = new DriverPropertyInfo(PROP_APPNAME, this.props.getProperty(PROP_APPNAME));
        propinfo.choices = null;
        propinfo.description = APPNAME_DESC;
        propinfo.required = false;
        return propinfo;
    }

    public DriverPropertyInfo[] getPropertyInfo(boolean local) {
        ArrayList<DriverPropertyInfo> alist = new ArrayList<DriverPropertyInfo>();
        alist.add(this.createAutoCommitPropertyInfo());
        alist.add(this.createROTModePropertyInfo());
        alist.add(this.createTransIsolationPropertyInfo());
        alist.add(this.createOpenmodePropertyInfo());
        alist.add(this.createDateFormatPropertyInfo());
        alist.add(this.createLockTimeoutPropertyInfo());
        alist.add(this.createPrefetchSizePropertyInfo());
        alist.add(this.createCacheSizePropertyInfo());
        alist.add(this.createStoragePropertyInfo());
        alist.add(this.createOptimizeParametersPropertyInfo());
        if (local) {
            alist.add(this.createDocrootPropertyInfo());
            alist.add(this.createTfsTypePropertyInfo());
        }
        if (on_android) {
            alist.add(this.createAppNamePropertyInfo());
        }
        return alist.toArray(new DriverPropertyInfo[alist.size()]);
    }

    public void addToURL(StringBuilder str, boolean local) {
        str.append("?");
        str.append("auto commit=" + this.props.getProperty(PROP_AUTOCOMMIT));
        str.append("&");
        str.append("snapshot=" + this.props.getProperty(PROP_ROTMODE));
        str.append("&");
        str.append("storage=" + this.props.getProperty(PROP_STORAGE));
        str.append("&");
        str.append("transaction isolation=" + this.props.getProperty(PROP_TRANS_ISOLATION));
        str.append("&");
        str.append("open mode=" + this.props.getProperty(PROP_OPENMODE));
        str.append("&");
        str.append("date format=" + this.props.getProperty(PROP_DATEFORMAT));
        str.append("&");
        str.append("lock timeout=" + this.props.getProperty(PROP_LOCKTIMEOUT));
        str.append("&");
        str.append("defaultFetchSize=" + this.props.getProperty(PROP_PREFETCHSIZE));
        str.append("&");
        str.append("cache size=" + this.props.getProperty(PROP_CACHESIZE));
        str.append("&");
        str.append("optimize parameters=" + this.props.getProperty(PROP_OPTIMIZEPARAMS));
        if (local) {
            str.append("&");
            str.append("document root=" + this.props.getProperty(PROP_DOCROOT));
            str.append("&");
            str.append("tfs type=" + this.props.getProperty(PROP_TFSTYPE));
        }
        if (on_android) {
            str.append("&");
            str.append("appname=" + this.props.getProperty(PROP_APPNAME));
        }
    }
}

