/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMConnection;
import com.raima.rdm.jdbc.RDMDriver;
import com.raima.rdm.jdbc.RDMParameterMetaData;
import com.raima.rdm.jdbc.RDMResultSet;
import com.raima.rdm.jdbc.RDMResultSetMetaData;
import com.raima.rdm.jdbc.RDMStatement;
import com.raima.rdm.sql.RSQLBinaryParam;
import com.raima.rdm.sql.RSQLBlobParam;
import com.raima.rdm.sql.RSQLBoolParam;
import com.raima.rdm.sql.RSQLByteParam;
import com.raima.rdm.sql.RSQLClobParam;
import com.raima.rdm.sql.RSQLDateParam;
import com.raima.rdm.sql.RSQLDecimalParam;
import com.raima.rdm.sql.RSQLDoubleParam;
import com.raima.rdm.sql.RSQLFloatParam;
import com.raima.rdm.sql.RSQLGuidParam;
import com.raima.rdm.sql.RSQLIntParam;
import com.raima.rdm.sql.RSQLLongParam;
import com.raima.rdm.sql.RSQLNClobParam;
import com.raima.rdm.sql.RSQLNStringParam;
import com.raima.rdm.sql.RSQLNullParam;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.sql.RSQLShortParam;
import com.raima.rdm.sql.RSQLStringParam;
import com.raima.rdm.sql.RSQLTimeParam;
import com.raima.rdm.sql.RSQLTimestampParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMConversionException;
import com.raima.rdm.util.RDMException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.UUID;

public class RDMPreparedStatement
extends RDMStatement
implements PreparedStatement {
    protected RSQLParam[] params;
    protected int numpars;
    private LinkedList<RSQLParam[]> batchParams = null;
    private RDMParameterMetaData parmMeta;
    private static final String className = "RDMPreparedStatement";

    protected RDMPreparedStatement(RDMConnection conn, String sql) throws SQLException {
        this(conn, sql, 2);
    }

    protected RDMPreparedStatement(RDMConnection conn, String sql, int autoGeneratedKeys) throws SQLException {
        super(conn);
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw new SQLException("invalid constant");
        }
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw new SQLException("invalid escape syntax");
        }
        try {
            this.stmt.prepare(sql, autoGeneratedKeys);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.numpars = this.stmt.getNumParms();
        if (this.numpars != 0) {
            this.params = new RSQLParam[this.numpars];
        }
    }

    protected RDMPreparedStatement(RDMConnection conn, String sql, int[] columnIndexes) throws SQLException {
        super(conn);
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw new SQLException("invalid escape syntax");
        }
        try {
            this.stmt.prepare(sql, columnIndexes);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.numpars = this.stmt.getNumParms();
        if (this.numpars != 0) {
            this.params = new RSQLParam[this.numpars];
        }
    }

    protected RDMPreparedStatement(RDMConnection conn, String sql, String[] columnNames) throws SQLException {
        super(conn);
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw new SQLException("invalid escape syntax");
        }
        try {
            this.stmt.prepare(sql, columnNames);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.numpars = this.stmt.getNumParms();
        if (this.numpars != 0) {
            this.params = new RSQLParam[this.numpars];
        }
    }

    protected RDMPreparedStatement(RDMConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency);
        if (this.escapeProcessing && (sql = RDMDriver.nativeSQL(sql)) == null) {
            throw new SQLException("invalid escape syntax");
        }
        try {
            this.stmt.prepare(sql, 2);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.numpars = this.stmt.getNumParms();
        if (this.numpars != 0) {
            this.params = new RSQLParam[this.numpars];
        }
    }

    @Override
    public void addBatch() throws SQLException {
        String methodName = "addBatch";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        if (this.batchParams == null) {
            this.batchParams = new LinkedList();
        }
        this.validateParameters();
        this.batchParams.add(this.params);
        this.params = new RSQLParam[this.numpars];
        this.logger.exiting(className, methodName);
    }

    @Override
    public void clearBatch() throws SQLException {
        String methodName = "clearBatch";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        if (this.batchParams != null) {
            this.batchParams.clear();
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void clearParameters() throws SQLException {
        String methodName = "clearParameters";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        if (this.params != null) {
            for (int ii = 0; ii < this.params.length; ++ii) {
                this.params[ii] = null;
            }
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public boolean execute() throws SQLException {
        String methodName = "execute";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.closeResultSet();
        this._clearWarnings();
        this.validateParameters();
        try {
            this.stmt.execute(this.params);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() == 0) {
            this.numModified = this.rowCount();
            if (this.conn._getAutoCommit()) {
                this.conn.closeResultSets();
            }
        } else {
            this.rs = new RDMResultSet(this, this.maxRows);
            this.rs.setFetchSize(this.fetchSize);
        }
        boolean flag = this.rs != null;
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] results;
        String methodName = "executeBatch";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.warning = null;
        String failed = null;
        String sqlState = null;
        if (this.batchParams != null) {
            results = new int[this.batchParams.size()];
            for (int ii = 0; ii < this.batchParams.size(); ++ii) {
                try {
                    results[ii] = this._executeUpdate(this.batchParams.get(ii), methodName);
                    continue;
                }
                catch (SQLException e) {
                    failed = e.getMessage();
                    sqlState = e.getSQLState();
                    results[ii] = -3;
                }
            }
        } else {
            results = new int[]{};
        }
        if (failed != null) {
            BatchUpdateException buex = new BatchUpdateException(failed, sqlState, results);
            this.logger.throwing(className, methodName, buex);
            throw buex;
        }
        this.logger.exiting(className, methodName, results);
        return results;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String methodName = "executeQuery";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.closeResultSet();
        this._clearWarnings();
        this.validateParameters();
        try {
            this.stmt.execute(this.params);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        this.params = new RSQLParam[this.numpars];
        this.rs = new RDMResultSet(this, this.maxRows);
        this.rs.setFetchSize(this.fetchSize);
        this.logger.exiting(className, methodName, this.rs);
        return this.rs;
    }

    private int _executeUpdate(RSQLParam[] params, String methodName) throws SQLException {
        this.closeResultSet();
        this._clearWarnings();
        if (this.conn._getAutoCommit()) {
            this.conn.closeResultSets();
        }
        try {
            this.stmt.execute(params);
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        SQLWarning warning = this.stmt.getWarnings();
        if (warning != null) {
            this.addWarning(warning);
        }
        if (this.numCols() != 0) {
            throw this.createSQLException(methodName, "An update statement should not return a ResultSet");
        }
        return (int)this.rowCount();
    }

    @Override
    public int executeUpdate() throws SQLException {
        String methodName = "executeUpdate";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.validateParameters();
        int ret = this._executeUpdate(this.params, methodName);
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String methodName = "getMetaData";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RDMResultSetMetaData result = new RDMResultSetMetaData(this.getSQLStatement());
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        String methodName = "getParameterMetaData";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        if (this.parmMeta == null) {
            this.parmMeta = new RDMParameterMetaData(this, this.numpars);
        }
        this.logger.exiting(className, methodName, this.parmMeta);
        return this.parmMeta;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public void setArray(int par, Array x) throws SQLException {
        String methodName = "setArray";
        this.logger.entering(className, methodName, new Object[]{par, x});
        throw this.createSQLFeatureNotSupportedException(methodName, "Array fields are not supported");
    }

    @Override
    public void setAsciiStream(int par, InputStream x) throws SQLException {
        String methodName = "setAsciiStream";
        this.logger.entering(className, methodName, new Object[]{par, x});
        try {
            this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(new InputStreamReader(x, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setAsciiStream(int par, InputStream x, int len) throws SQLException {
        String methodName = "setAsciiStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0) {
            throw this.createSQLException(methodName, "length specified is less than zero");
        }
        try {
            this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(new InputStreamReader(x, "US-ASCII"), len);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setAsciiStream(int par, InputStream x, long len) throws SQLException {
        String methodName = "setAsciiStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than zero");
        }
        try {
            this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(new InputStreamReader(x, "US-ASCII"), len);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBigDecimal(int par, BigDecimal x) throws SQLException {
        String methodName = "setBigDecimal";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLDecimalParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBinaryStream(int par, InputStream x) throws SQLException {
        String methodName = "setBinaryStream";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBlobParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBinaryStream(int par, InputStream x, int len) throws SQLException {
        String methodName = "setBinaryStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0) {
            throw this.createSQLException(methodName, "length specified is less than 0");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBlobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBinaryStream(int par, InputStream x, long len) throws SQLException {
        String methodName = "setBinaryStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than 0");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBlobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBlob(int par, Blob x) throws SQLException {
        String methodName = "setBlob";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBlobParam(x.getBinaryStream());
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBlob(int par, InputStream x) throws SQLException {
        String methodName = "setBlob";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBlobParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBlob(int par, InputStream x, long len) throws SQLException {
        String methodName = "setBlob";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than 0");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBlobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBoolean(int par, boolean x) throws SQLException {
        String methodName = "setBoolean";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBoolParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setByte(int par, byte x) throws SQLException {
        String methodName = "setByte";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLByteParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setBytes(int par, byte[] x) throws SQLException {
        String methodName = "setBytes";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLBinaryParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setCharacterStream(int par, Reader x) throws SQLException {
        String methodName = "setCharacterStream";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setCharacterStream(int par, Reader x, int len) throws SQLException {
        this.setCharacterStream(par, x, (long)len);
    }

    @Override
    public void setCharacterStream(int par, Reader x, long len) throws SQLException {
        String methodName = "setCharacterStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than zero");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setClob(int par, Clob x) throws SQLException {
        String methodName = "setClob";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(x.getCharacterStream());
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setClob(int par, Reader x) throws SQLException {
        String methodName = "setClob";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setClob(int par, Reader x, long len) throws SQLException {
        String methodName = "setClob";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than zero");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLClobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setDate(int par, Date x) throws SQLException {
        String methodName = "setDate";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLDateParam(x, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setDate(int par, Date x, Calendar cal) throws SQLException {
        String methodName = "setDate";
        this.logger.entering(className, methodName, new Object[]{par, x, cal});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLDateParam(x, cal);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setDouble(int par, double x) throws SQLException {
        String methodName = "setDouble";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLDoubleParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setFloat(int par, float x) throws SQLException {
        String methodName = "setFloat";
        this.logger.entering(className, methodName, new Object[]{par, Float.valueOf(x)});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLFloatParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setInt(int par, int x) throws SQLException {
        String methodName = "setInt";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLIntParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setLong(int par, long x) throws SQLException {
        String methodName = "setLong";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLLongParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNCharacterStream(int par, Reader x) throws SQLException {
        String methodName = "setNCharacterStream";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNClobParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNCharacterStream(int par, Reader x, long len) throws SQLException {
        String methodName = "setNCharacterStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than zero");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNClobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNClob(int par, NClob x) throws SQLException {
        String methodName = "setNClob";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNClobParam(x.getCharacterStream());
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNClob(int par, Reader x) throws SQLException {
        String methodName = "setNClob";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNClobParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNClob(int par, Reader x, long len) throws SQLException {
        String methodName = "setNClob";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        if (len < 0L) {
            throw this.createSQLException(methodName, "length specified is less than zero");
        }
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNClobParam(x, len);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNString(int par, String x) throws SQLException {
        String methodName = "setNString";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNStringParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNull(int par, int type) throws SQLException {
        String methodName = "setNull";
        this.logger.entering(className, methodName, new Object[]{par, type});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNullParam();
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNull(int par, int type, String typeName) throws SQLException {
        String methodName = "setNull";
        this.logger.entering(className, methodName, new Object[]{par, type, typeName});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLNullParam();
        this.logger.exiting(className, methodName);
    }

    protected void _setObject(String methodName, int parno, Object x) throws SQLException {
        if (x instanceof String) {
            this.params[parno] = new RSQLStringParam((String)x);
        } else if (x instanceof Boolean) {
            this.params[parno] = new RSQLBoolParam((Boolean)x);
        } else if (x instanceof Byte) {
            this.params[parno] = new RSQLByteParam((Byte)x);
        } else if (x instanceof Short) {
            this.params[parno] = new RSQLShortParam((Short)x);
        } else if (x instanceof Integer) {
            this.params[parno] = new RSQLIntParam((Integer)x);
        } else if (x instanceof Long) {
            this.params[parno] = new RSQLLongParam((Long)x);
        } else if (x instanceof Float) {
            this.params[parno] = new RSQLFloatParam(((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.params[parno] = new RSQLDoubleParam((Double)x);
        } else if (x instanceof byte[]) {
            this.params[parno] = new RSQLBinaryParam((byte[])x);
        } else if (x instanceof BigDecimal) {
            this.params[parno] = new RSQLDecimalParam((BigDecimal)x);
        } else if (x instanceof UUID) {
            this.params[parno] = new RSQLGuidParam((UUID)x);
        } else if (x instanceof Date) {
            this.params[parno] = new RSQLDateParam((Date)x);
        } else if (x instanceof Time) {
            this.params[parno] = new RSQLTimeParam((Time)x);
        } else if (x instanceof Timestamp) {
            this.params[parno] = new RSQLTimestampParam((Timestamp)x);
        } else if (x instanceof NClob) {
            this.params[parno] = new RSQLNClobParam((NClob)x);
        } else if (x instanceof Clob) {
            this.params[parno] = new RSQLClobParam((Clob)x);
        } else if (x instanceof Blob) {
            this.params[parno] = new RSQLBlobParam((Blob)x);
        } else {
            throw this.createSQLException(methodName, "Invalid Object supplied to setObject");
        }
    }

    @Override
    public void setObject(int par, Object x) throws SQLException {
        String methodName = "setObject";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this._setObject(methodName, this.parm(methodName, par), x);
        this.logger.exiting(className, methodName);
    }

    private RSQLParam setObjectString(String methodName, String x, int type) throws SQLException {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x);
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x));
            }
            case -3: 
            case -2: {
                return new RSQLBinaryParam(x.getBytes(Charset.forName("UTF-8")));
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromString(x)));
                }
                catch (RDMException e) {
                    throw this.createSQLException(methodName, e);
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(x.equals("1") || x.equalsIgnoreCase("true"));
            }
            case -6: {
                return new RSQLByteParam(Byte.valueOf(x));
            }
            case 5: {
                return new RSQLShortParam(Short.valueOf(x));
            }
            case 4: {
                return new RSQLIntParam(Integer.valueOf(x));
            }
            case -8: 
            case -5: {
                return new RSQLLongParam(Long.valueOf(x));
            }
            case 7: {
                return new RSQLFloatParam(Float.valueOf(x).floatValue());
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam(Double.valueOf(x));
            }
            case 91: {
                return new RSQLDateParam(Date.valueOf(x));
            }
            case 92: {
                return new RSQLTimeParam(Time.valueOf(x));
            }
            case 93: {
                return new RSQLTimestampParam(Timestamp.valueOf(x));
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(x));
            }
            case 1111: {
                return new RSQLGuidParam(UUID.fromString(x));
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectByteArray(String methodName, byte[] x, int type) throws SQLException {
        if (x.length == 0) {
            return new RSQLNullParam();
        }
        try {
            DataInputStream ds = new DataInputStream(new ByteArrayInputStream(x));
            switch (type) {
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    return new RSQLStringParam(new String(x, Charset.forName("UTF-8")));
                }
                case -1: 
                case 2005: {
                    return new RSQLClobParam(new StringReader(new String(x, Charset.forName("UTF-8"))));
                }
                case -16: 
                case 2011: {
                    return new RSQLNClobParam(new StringReader(new String(x, Charset.forName("UTF-8"))));
                }
                case -3: 
                case -2: {
                    return new RSQLBinaryParam(x);
                }
                case -4: 
                case 2004: {
                    return new RSQLBlobParam(new ByteArrayInputStream(x));
                }
                case -7: 
                case 16: {
                    return new RSQLBoolParam(ds.readBoolean());
                }
                case -6: {
                    return new RSQLByteParam(ds.readByte());
                }
                case 5: {
                    return new RSQLShortParam(ds.readShort());
                }
                case 4: {
                    return new RSQLIntParam(ds.readInt());
                }
                case -8: 
                case -5: {
                    return new RSQLLongParam(ds.readLong());
                }
                case 7: {
                    return new RSQLFloatParam(ds.readFloat());
                }
                case 6: 
                case 8: {
                    return new RSQLDoubleParam(ds.readDouble());
                }
                case 3: 
                case 91: 
                case 92: 
                case 93: 
                case 1111: {
                    throw this.createSQLException(methodName, "Invalid conversion in setObject");
                }
            }
            throw this.createSQLException(methodName, "unsupported type");
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, "I/O failure during conversion in setObject");
        }
    }

    private RSQLParam setObjectBoolean(String methodName, Boolean x, int type) throws SQLException {
        boolean b = x;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromBoolean(b));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromBoolean(b)));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(b);
            }
            case -6: {
                return new RSQLByteParam(b ? (byte)1 : 0);
            }
            case 5: {
                return new RSQLShortParam(b ? (short)1 : 0);
            }
            case 4: {
                return new RSQLIntParam(b ? 1 : 0);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam(b ? 1L : 0L);
            }
            case 7: {
                return new RSQLFloatParam(b ? 1.0f : 0.0f);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam(b ? 1.0 : 0.0);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(b ? 1 : 0));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectByte(String methodName, Byte x, int type) throws SQLException {
        byte b = x;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromByte(b));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromByte(b)));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(b == 1);
            }
            case -6: {
                return new RSQLByteParam(b);
            }
            case 5: {
                return new RSQLShortParam(b);
            }
            case 4: {
                return new RSQLIntParam(b);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam((long)b);
            }
            case 7: {
                return new RSQLFloatParam((float)b);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam((double)b);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(b));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectShort(String methodName, Short x, int type) throws SQLException {
        short s = x;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromShort(s));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromShort(s)));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(s == 1);
            }
            case -6: {
                return new RSQLByteParam((byte)s);
            }
            case 5: {
                return new RSQLShortParam(s);
            }
            case 4: {
                return new RSQLIntParam(s);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam((long)s);
            }
            case 7: {
                return new RSQLFloatParam((float)s);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam((double)s);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(s));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectInteger(String methodName, Integer x, int type) throws SQLException {
        int i = x;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromInt(i));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromInt(i)));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(i == 1);
            }
            case -6: {
                return new RSQLByteParam((byte)i);
            }
            case 5: {
                return new RSQLShortParam((short)i);
            }
            case 4: {
                return new RSQLIntParam(i);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam((long)i);
            }
            case 7: {
                return new RSQLFloatParam((float)i);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam((double)i);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(i));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectLong(String methodName, Long x, int type) throws SQLException {
        long l = x;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromLong(l));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromLong(l)));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(l == 1L);
            }
            case -6: {
                return new RSQLByteParam((byte)l);
            }
            case 5: {
                return new RSQLShortParam((short)l);
            }
            case 4: {
                return new RSQLIntParam((int)l);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam(l);
            }
            case 7: {
                return new RSQLFloatParam(l);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam(l);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(l));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectFloat(String methodName, Float x, int type) throws SQLException {
        float f = x.floatValue();
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromFloat(x.floatValue()));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromFloat(x.floatValue())));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(f == 1.0f);
            }
            case -6: {
                return new RSQLByteParam((byte)f);
            }
            case 5: {
                return new RSQLShortParam((short)f);
            }
            case 4: {
                return new RSQLIntParam((int)f);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam((long)f);
            }
            case 7: {
                return new RSQLFloatParam(f);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam(f);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(f));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectDouble(String methodName, Double x, int type) throws SQLException {
        double d = x;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -3: 
            case -2: {
                try {
                    return new RSQLBinaryParam(BinaryConverter.convertFromDouble(x));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -4: 
            case 2004: {
                try {
                    return new RSQLBlobParam(new ByteArrayInputStream(BinaryConverter.convertFromDouble(x)));
                }
                catch (RDMConversionException e) {
                    throw e.createSQLException();
                }
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(d == 1.0);
            }
            case -6: {
                return new RSQLByteParam((byte)d);
            }
            case 5: {
                return new RSQLShortParam((short)d);
            }
            case 4: {
                return new RSQLIntParam((int)d);
            }
            case -8: 
            case -5: {
                return new RSQLLongParam((long)d);
            }
            case 7: {
                return new RSQLFloatParam((float)d);
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam(d);
            }
            case 3: {
                return new RSQLDecimalParam(new BigDecimal(d));
            }
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectDecimal(String methodName, BigDecimal x, int type) throws SQLException {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -7: 
            case 16: {
                return new RSQLBoolParam(x == BigDecimal.ONE);
            }
            case -6: {
                return new RSQLByteParam(x.byteValueExact());
            }
            case 5: {
                return new RSQLShortParam(x.shortValueExact());
            }
            case 4: {
                return new RSQLIntParam(x.intValueExact());
            }
            case -8: 
            case -5: {
                return new RSQLLongParam(x.longValueExact());
            }
            case 7: {
                return new RSQLFloatParam(x.floatValue());
            }
            case 6: 
            case 8: {
                return new RSQLDoubleParam(x.doubleValue());
            }
            case 3: {
                return new RSQLDecimalParam(x);
            }
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2004: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectGuid(String methodName, UUID x, int type) throws SQLException {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case 1111: {
                return new RSQLGuidParam(x);
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectDate(String methodName, Date x, int type) throws SQLException {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 92: 
            case 1111: 
            case 2004: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
            case 91: {
                return new RSQLDateParam(x);
            }
            case 93: {
                return new RSQLTimestampParam(new Timestamp(x.getTime()));
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectTime(String methodName, Time x, int type) throws SQLException {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 1111: 
            case 2004: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
            case 92: {
                return new RSQLTimeParam(x);
            }
            case 93: {
                return new RSQLTimestampParam(new Timestamp(x.getTime()));
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectTimestamp(String methodName, Timestamp x, int type) throws SQLException {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return new RSQLStringParam(x.toString());
            }
            case -1: 
            case 2005: {
                return new RSQLClobParam(new StringReader(x.toString()));
            }
            case -16: 
            case 2011: {
                return new RSQLNClobParam(new StringReader(x.toString()));
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 1111: 
            case 2004: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
            case 91: {
                return new RSQLDateParam(new Date(x.getTime()));
            }
            case 92: {
                return new RSQLTimeParam(new Time(x.getTime()));
            }
            case 93: {
                return new RSQLTimestampParam(x);
            }
        }
        throw this.createSQLException(methodName, "unsupported type");
    }

    private RSQLParam setObjectInputStream(String methodName, InputStream x, int type, int scale) throws SQLException {
        try {
            switch (type) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    if (scale < 0) {
                        throw this.createSQLException(methodName, "length specified is less than 0");
                    }
                    return new RSQLClobParam(new InputStreamReader(x, "US-ASCII"), scale);
                }
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    if (scale < 0) {
                        throw this.createSQLException(methodName, "length specified is less than 0");
                    }
                    return new RSQLNClobParam(new InputStreamReader(x, "US-ASCII"), scale);
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    if (scale < 0) {
                        throw this.createSQLException(methodName, "length specified is less than 0");
                    }
                    return new RSQLBlobParam(x, scale);
                }
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 91: 
                case 92: 
                case 93: 
                case 1111: {
                    throw this.createSQLException(methodName, "Invalid conversion in setObject");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        return null;
    }

    private RSQLParam setObjectReader(String methodName, Reader x, int type, int scale) throws SQLException {
        switch (type) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (scale < 0) {
                    throw this.createSQLException(methodName, "length specified is less than 0");
                }
                return new RSQLClobParam(x, scale);
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                if (scale < 0) {
                    throw this.createSQLException(methodName, "length specified is less than 0");
                }
                return new RSQLNClobParam(x, scale);
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2004: {
                throw this.createSQLException(methodName, "Invalid conversion in setObject");
            }
        }
        return null;
    }

    public void _setObject(String methodName, int parno, Object x, int type, int scale) throws SQLException {
        if (type == 2003 || type == 70 || type == 2000 || type == 2006 || type == -8 || type == 2009 || type == 2002) {
            throw this.createSQLFeatureNotSupportedException(methodName, "type not supported");
        }
        if (x == null) {
            this.params[parno] = new RSQLNullParam();
        } else if (x instanceof String) {
            this.params[parno] = this.setObjectString(methodName, (String)x, type);
        } else if (x instanceof byte[]) {
            this.params[parno] = this.setObjectByteArray(methodName, (byte[])x, type);
        } else if (x instanceof Boolean) {
            this.params[parno] = this.setObjectBoolean(methodName, (Boolean)x, type);
        } else if (x instanceof Byte) {
            this.params[parno] = this.setObjectByte(methodName, (Byte)x, type);
        } else if (x instanceof Short) {
            this.params[parno] = this.setObjectShort(methodName, (Short)x, type);
        } else if (x instanceof Integer) {
            this.params[parno] = this.setObjectInteger(methodName, (Integer)x, type);
        } else if (x instanceof Long) {
            this.params[parno] = this.setObjectLong(methodName, (Long)x, type);
        } else if (x instanceof Float) {
            this.params[parno] = this.setObjectFloat(methodName, (Float)x, type);
        } else if (x instanceof Double) {
            this.params[parno] = this.setObjectDouble(methodName, (Double)x, type);
        } else if (x instanceof BigDecimal) {
            this.params[parno] = this.setObjectDecimal(methodName, (BigDecimal)x, type);
        } else if (x instanceof UUID) {
            this.params[parno] = this.setObjectGuid(methodName, (UUID)x, type);
        } else if (x instanceof Date) {
            this.params[parno] = this.setObjectDate(methodName, (Date)x, type);
        } else if (x instanceof Time) {
            this.params[parno] = this.setObjectTime(methodName, (Time)x, type);
        } else if (x instanceof Timestamp) {
            this.params[parno] = this.setObjectTimestamp(methodName, (Timestamp)x, type);
        } else if (x instanceof InputStream) {
            this.params[parno] = this.setObjectInputStream(methodName, (InputStream)x, type, scale);
        } else if (x instanceof Reader) {
            this.params[parno] = this.setObjectReader(methodName, (Reader)x, type, scale);
        } else {
            throw this.createSQLException(methodName, "Unexpected object in setObject");
        }
    }

    @Override
    public void setObject(int par, Object x, int type) throws SQLException {
        String methodName = "setObject";
        this.logger.entering(className, methodName, new Object[]{par, x, type});
        this._setObject(methodName, this.parm(methodName, par), x, type, 0);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setObject(int par, Object x, int type, int scale) throws SQLException {
        String methodName = "setObject";
        this.logger.entering(className, methodName, new Object[]{par, x, type, scale});
        this._setObject(methodName, this.parm(methodName, par), x, type, scale);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setRef(int par, Ref x) throws SQLException {
        String methodName = "setRef";
        this.logger.entering(className, methodName, new Object[]{par, x});
        throw this.createSQLFeatureNotSupportedException(methodName, "Ref fields are not supported");
    }

    @Override
    public void setRowId(int par, RowId x) throws SQLException {
        String methodName = "setRowId";
        this.logger.entering(className, methodName, new Object[]{par, x});
        throw this.createSQLFeatureNotSupportedException(methodName, "RowId fields are not supported");
    }

    @Override
    public void setShort(int par, short x) throws SQLException {
        String methodName = "setShort";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLShortParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setSQLXML(int par, SQLXML x) throws SQLException {
        String methodName = "setSQLXML";
        this.logger.entering(className, methodName, new Object[]{par, x});
        throw this.createSQLFeatureNotSupportedException(methodName, "XML fields are not supported");
    }

    @Override
    public void setString(int par, String x) throws SQLException {
        String methodName = "setString";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLStringParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setTime(int par, Time x) throws SQLException {
        String methodName = "setTime";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLTimeParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setTime(int par, Time x, Calendar cal) throws SQLException {
        String methodName = "setTime";
        this.logger.entering(className, methodName, new Object[]{par, x, cal});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLTimeParam(x, cal);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setTimestamp(int par, Timestamp x) throws SQLException {
        String methodName = "setTimestamp";
        this.logger.entering(className, methodName, new Object[]{par, x});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLTimestampParam(x);
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setTimestamp(int par, Timestamp x, Calendar cal) throws SQLException {
        String methodName = "setTimestamp";
        this.logger.entering(className, methodName, new Object[]{par, x, cal});
        this.params[this.parm((String)methodName, (int)par)] = new RSQLTimestampParam(x, cal);
        this.logger.exiting(className, methodName);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int par, InputStream x, int len) throws SQLException {
        String methodName = "setUnicodeStream";
        this.logger.entering(className, methodName, new Object[]{par, x, len});
        throw this.createSQLFeatureNotSupportedException(methodName, "the setUnicodeStream method is deprecated");
    }

    @Override
    public void setURL(int par, URL x) throws SQLException {
        String methodName = "setURL";
        this.logger.entering(className, methodName, new Object[]{par, x});
        throw this.createSQLFeatureNotSupportedException(methodName, "URL fields are not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    protected int getNumParms() {
        return this.numpars;
    }

    private void validateParameters() throws SQLException {
        for (int ii = 0; ii < this.numpars; ++ii) {
            if (this.params[ii] != null) continue;
            throw new SQLException("parameter " + (ii + 1) + " not set");
        }
    }

    @Override
    protected void _validate(String methodName) throws SQLException {
        if (this.stmt == null) {
            throw this.createSQLException(methodName, "Invalid Statement");
        }
    }

    protected int parm(String methodName, int par) throws SQLException {
        this._validate(methodName);
        if (par < 1 || par > this.numpars) {
            throw this.createSQLException(methodName, "invalid parameter number");
        }
        return par - 1;
    }
}

