/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMConnection;
import com.raima.rdm.jdbc.RDMJDBCURL;
import com.raima.rdm.util.RDMLogFormatter;
import java.io.IOException;
import java.security.AccessControlException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class RDMDriver
implements Driver {
    private static final int MAJOR_VERSION = 15;
    private static final int MINOR_VERSION = 2;
    private static final boolean JDBC_COMPLIANT = true;
    private static final String className = "RDMDriver";
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static boolean isRegistered = false;

    public RDMDriver() throws SQLException {
        try {
            FileHandler handler = new FileHandler("%t/rdm.jdbc.log");
            handler.setFormatter(new RDMLogFormatter());
            this.logger.addHandler(handler);
        }
        catch (IOException iOException) {
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Override
    public boolean acceptsURL(String str) {
        String methodName = "acceptsURL";
        this.logger.entering(className, methodName, str);
        boolean ret = RDMJDBCURL.acceptsURL(str);
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public Connection connect(String str, Properties props) throws SQLException {
        String methodName = "connect";
        this.logger.entering(className, methodName, new Object[]{str, props});
        RDMConnection con = null;
        try {
            con = new RDMConnection(new RDMJDBCURL(str, props));
        }
        catch (SQLException e) {
            this.logger.throwing(className, methodName, e);
            throw e;
        }
        catch (Exception e) {
            SQLException sqlex = new SQLException(e.toString());
            this.logger.throwing(className, methodName, sqlex);
            return null;
        }
        this.logger.exiting(className, methodName, con);
        return con;
    }

    @Override
    public int getMajorVersion() {
        String methodName = "getMajorVersion";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, 15);
        return 15;
    }

    @Override
    public int getMinorVersion() {
        String methodName = "getMinorVersion";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, 2);
        return 2;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        String methodName = "getParentLogger";
        this.logger.entering(className, methodName);
        throw this.createSQLFeatureNotSupportedException(methodName, "not supported");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String str, Properties props) throws SQLException {
        DriverPropertyInfo[] propinfo;
        String methodName = "getPropertyInfo";
        this.logger.entering(className, methodName, new Object[]{str, props});
        try {
            RDMJDBCURL url = new RDMJDBCURL(str, props);
            propinfo = url.getPropertyInfo();
        }
        catch (Exception e) {
            SQLException sqlex = new SQLException(e.toString());
            this.logger.throwing(className, methodName, sqlex);
            throw sqlex;
        }
        this.logger.exiting(className, methodName, propinfo);
        return propinfo;
    }

    @Override
    public boolean jdbcCompliant() {
        String methodName = "jdbcCompliant";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, true);
        return true;
    }

    protected static String nativeSQL(String sql) {
        StringBuffer output = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(sql, "{\"", true);
        while (tok.hasMoreTokens()) {
            String temp = tok.nextToken("{\"");
            if (temp.equals("\"")) {
                output.append("\"");
                if (!tok.hasMoreTokens()) continue;
                temp = tok.nextToken("\"");
                output.append(temp);
                if (temp.equals("\"") || !tok.hasMoreTokens()) continue;
                output.append(tok.nextToken());
                continue;
            }
            if (temp.equals("{")) {
                String type = tok.nextToken(" ");
                temp = tok.nextToken("}");
                String end = tok.nextToken();
                if (type == null || temp == null || end == null) {
                    return null;
                }
                if (type.equalsIgnoreCase("d") || type.equalsIgnoreCase("t") || type.equalsIgnoreCase("ts")) {
                    output.append("@").append(temp.trim());
                    continue;
                }
                if (type.equalsIgnoreCase("fn")) {
                    output.append("\"").append(temp.trim()).append("\"");
                    continue;
                }
                if (type.equalsIgnoreCase("oj")) {
                    output.append("LEFT OUTER JOIN ").append(temp.trim());
                    continue;
                }
                if (!type.equalsIgnoreCase("call")) continue;
                output.append("call ").append(temp.trim());
                continue;
            }
            output.append(temp);
        }
        return output.toString();
    }

    private SQLFeatureNotSupportedException createSQLFeatureNotSupportedException(String methodName, String error) throws SQLFeatureNotSupportedException {
        SQLFeatureNotSupportedException sqlex = new SQLFeatureNotSupportedException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    static {
        try {
            if (!isRegistered) {
                DriverManager.registerDriver(new RDMDriver());
                isRegistered = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

