/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMConnection;
import com.raima.rdm.jdbc.RDMSettings;
import com.raima.rdm.jdbc.RDMStatement;
import com.raima.rdm.util.RDMVersion;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.logging.Logger;

public class RDMDatabaseMetaData
implements DatabaseMetaData {
    RDMConnection conn;
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static final String productVersion = RDMVersion.getVersion();
    private static final String className = "RDMDatabaseMetaData";
    private static final String numericFunctions = "ABS,ACOS,ASIN,ATAN,ATAN2,AVG,CEIL,CEILING,COS,COT,COUNT,EXP,FLOOR,LN,LOG,MOD,PI,RAND,SIGN,SIN,SQRT,SUM,TAN";
    private static final String sqlKeywords = "ACOS,AGE,ASCII,ASIN,ATAN,ATAN2,AUTO,AUTOCOMMIT,BIT,CIRCULAR,CONCAT,COS,COT,CURDATE,CURRENCY,CURTIME,DATABASE,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,DB_ADDR,DEBUG,DOMAIN,ERRORS,EXCLUSIVE,EXPORT,FILE,HASH,IF,IFNULL,IGNORE,IMPORT,INDEX,INITIAL,INITIALIZE,INMEMORY,LCASE,LIMIT,LOCATE,LOCK,LOG,LONG,LTRIM,MANUAL,MAXROWS,MINS,MODE,MSECS,NAT,NOSORT,NOW,OFF,ONE,PERSISTENT,PI,PROC,QUARTER,RAND,REPEAT,REPLACE,ROUND,ROWID,RTRIM,SECS,SHARE,SHARED,SHORT,SIN,SORTED,STATS,TAN,THOUSANDS,TIMEOUT,TINYINT,TRANS,TYPEOF,UCASE,UNICODE,UNLOCK,VARBINARY,VARBYTE,VIRTUAL,VOLATILE,WEEK,WILD,XML";
    private static final String stringFunctions = "ASCII,CONCAT,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SUBSTRING,TRIM,UCASE,UNICODE";
    private static final String systemFunctions = "CONVERT,DATABASE,IFNULL,USER";
    private static final String timeDateFunctions = "AGE,CURDATE,CURTIME,CURTS,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,NOW,QUARTER,SECOND,WEEK,YEAR";
    private static final String searchStringEscape = "\\";
    private HashMap<Integer, RDMStatement> stmtMap;
    private static final int idxBestRowId = 0;
    private static final int idxGetCatalogs = 1;
    private static final int idxGetColumns = 2;
    private static final int idxGetCrossRef = 3;
    private static final int idxGetExpKeys = 4;
    private static final int idxGetImpKeys = 5;
    private static final int idxGetIndexInfo = 6;
    private static final int idxGetPrimKeys = 7;
    private static final int idxGetProcedures = 8;
    private static final int idxGetSchemas = 9;
    private static final int idxGetTables = 10;
    private static final int idxGetTableTypes = 11;
    private static final int idxGetTypeInfo = 12;
    private static final int idxGetUDTs = 13;
    private static final int idxGetVersCols = 15;
    private static final int idxGetProcCols = 16;
    private static final int idxGetAttributes = 17;
    private static final int idxGetFunctions = 18;
    private static final int idxGetSuperTables = 19;
    private static final int idxGetSuperTypes = 20;
    private static final int maxStatements = 21;
    private HashMap<String, Object> map;

    protected RDMDatabaseMetaData(String url, RDMConnection conn) throws SQLException {
        this.conn = conn;
        this.stmtMap = new HashMap(21);
        this.map = new HashMap();
        this.map.put("allProceduresAreCallable", true);
        this.map.put("allTablesAreSelectable", true);
        this.map.put("autoCommitFailureClosesAllResultSets", false);
        this.map.put("dataDefinitionCausesTransactionCommit", false);
        this.map.put("dataDefinitionIgnoredInTransactions", false);
        this.map.put("deletesAreDetected", false);
        this.map.put("doesMaxRowSizeIncludeBlobs", false);
        this.map.put("generatedKeysAlwaysReturned", true);
        this.map.put("getCatalogSeparator", ".");
        this.map.put("getCatalogTerm", "CATALOG");
        this.map.put("getDatabaseMajorVersion", RDMVersion.getMajorVersion());
        this.map.put("getDatabaseMinorVersion", RDMVersion.getMinorVersion());
        this.map.put("getDatabaseProductName", "Raima Database Manager");
        this.map.put("getDatabaseProductVersion", RDMVersion.getVersion());
        this.map.put("getDefaultTransactionIsolation", 4);
        this.map.put("getDriverMajorVersion", RDMVersion.getMajorVersion());
        this.map.put("getDriverMinorVersion", RDMVersion.getMinorVersion());
        this.map.put("getDriverName", "JDBC driver for Raima Database Manager");
        this.map.put("getDriverVersion", RDMVersion.getVersion());
        this.map.put("getExtraNameCharacters", "");
        this.map.put("getIdentifierQuoteString", " ");
        this.map.put("getJDBCMajorVersion", 4);
        this.map.put("getJDBCMinorVersion", 0);
        this.map.put("getMaxBinaryLiteralLength", 0);
        this.map.put("getMaxCatalogNameLength", 0);
        this.map.put("getMaxCharLiteralLength", 0);
        this.map.put("getMaxColumnNameLength", 32);
        this.map.put("getMaxColumnsInGroupBy", 0);
        this.map.put("getMaxColumnsInIndex", 0);
        this.map.put("getMaxColumnsInOrderBy", 0);
        this.map.put("getMaxColumnsInSelect", 0);
        this.map.put("getMaxColumnsInTable", 0);
        this.map.put("getMaxConnections", 0);
        this.map.put("getMaxCursorNameLength", 0);
        this.map.put("getMaxIndexLength", 0);
        this.map.put("getMaxProcedureNameLength", 32);
        this.map.put("getMaxRowSize", 0);
        this.map.put("getMaxSchemaNameLength", 32);
        this.map.put("getMaxStatementLength", 0);
        this.map.put("getMaxStatements", 0);
        this.map.put("getMaxTableNameLength", 32);
        this.map.put("getMaxTablesInSelect", 0);
        this.map.put("getMaxUserNameLength", 32);
        this.map.put("getNumericFunctions", numericFunctions);
        this.map.put("getProcedureTerm", "PROC");
        this.map.put("getResultSetHoldability", 2);
        this.map.put("getRowIdLifetime", (Object)RowIdLifetime.ROWID_VALID_FOREVER);
        this.map.put("getSchemaTerm", "DATABASE");
        this.map.put("getSearchStringEscape", searchStringEscape);
        this.map.put("getSQLKeywords", sqlKeywords);
        this.map.put("getSQLStateType", 1);
        this.map.put("getStringFunctions", stringFunctions);
        this.map.put("getSystemFunctions", systemFunctions);
        this.map.put("getTimeDateFunctions", timeDateFunctions);
        this.map.put("getURL", url);
        this.map.put("getUserName", "<none>");
        this.map.put("insertsAreDetected", false);
        this.map.put("isCatalogAtStart", true);
        this.map.put("locatorsUpdateCopy", false);
        this.map.put("nullPlusNonNullIsNull", true);
        this.map.put("nullsAreSortedAtEnd", false);
        this.map.put("nullsAreSortedAtStart", false);
        this.map.put("nullsAreSortedHigh", false);
        this.map.put("nullsAreSortedLow", true);
        this.map.put("othersDeletesAreVisible", true);
        this.map.put("othersInsertsAreVisible", true);
        this.map.put("othersUpdatesAreVisible", true);
        this.map.put("ownDeletesAreVisible", true);
        this.map.put("ownInsersAreVisible", true);
        this.map.put("ownUpdatesAreVisible", true);
        this.map.put("storesLowerCaseIdentifiers", false);
        this.map.put("storesLowerCaseQuotedIdentifiers", false);
        this.map.put("storesMixedCaseIdentifiers", false);
        this.map.put("storesMixedCaseQuotedIdentifiers", false);
        this.map.put("storesUpperCaseIdentifiers", true);
        this.map.put("storesUpperCaseQuotedIdentifiers", true);
        this.map.put("supportsAlterTableWithAddColumn", false);
        this.map.put("supportsAlterTableWithDropColumn", false);
        this.map.put("supportsANSI92EntryLevelSQL", true);
        this.map.put("supportsANSI92FullSQL", false);
        this.map.put("supportsANSI92IntermediateSQL", true);
        this.map.put("supportsBatchUpdates", true);
        this.map.put("supportsCatalogsInDataManipulation", false);
        this.map.put("supportsCatalogsInIndexDefintions", false);
        this.map.put("supportsCatalogsInPrivilegeDefinitions", false);
        this.map.put("supportsCatalogsInProcedureCalls", false);
        this.map.put("supportsCatalogsInTableDefinitions", false);
        this.map.put("supportsColumnAliasing", true);
        this.map.put("supportsConvert", true);
        this.map.put("supportsCoreSQLGrammar", true);
        this.map.put("supportsCorrelatedSubqueries", false);
        this.map.put("supportsDataDefinitionAndDataManipulationTransactions", true);
        this.map.put("supportsDataManipulationTransactionsOnly", false);
        this.map.put("supportsDifferentTableCorrelationNames", false);
        this.map.put("supportsExpressionsInOrderBy", true);
        this.map.put("supportsExtendedSQLGrammar", true);
        this.map.put("supportsFullOuterJoins", false);
        this.map.put("supportsGetGeneratedKeys", false);
        this.map.put("supportsGroupBy", true);
        this.map.put("supportsGroupByBeyondSelect", false);
        this.map.put("supportsGroupByUnrelated", false);
        this.map.put("supportsIntegrityEnhancementFacility", true);
        this.map.put("supportsLikeEscapeClause", true);
        this.map.put("supportsLimitedOuterJoins", true);
        this.map.put("supportsMinimumSQLGrammar", true);
        this.map.put("supportsMixedCaseIdentifiers", false);
        this.map.put("supportsMixedCaseQuotedIdentifiers", true);
        this.map.put("supportsMultipleOpenResults", false);
        this.map.put("supportsMultipleResultSets", true);
        this.map.put("supportsMultipleTransactions", true);
        this.map.put("supportsNamedParameters", true);
        this.map.put("supportsNonNullableColumns", true);
        this.map.put("supportsOpenCursorsAcrossCommit", false);
        this.map.put("supportsOpenCursorsAcrossRollback", false);
        this.map.put("supportsOpenStatementsAcrossCommit", true);
        this.map.put("supportsOpenStatementsAcrossRollback", true);
        this.map.put("supportsOrderByUnrelated", false);
        this.map.put("supportsOuterJoins", true);
        this.map.put("supportsPositionedDelete", false);
        this.map.put("supportsPositionedUpdate", false);
        this.map.put("supportsSavepoints", true);
        this.map.put("supportsSchemasInDataManipulation", true);
        this.map.put("supportsSchemasInIndexDefinitions", true);
        this.map.put("supportsSchemasInPrivilegeDefintions", true);
        this.map.put("supportsSchemasInProcedureCalls", true);
        this.map.put("supportsSchemasInTableDefinitions", true);
        this.map.put("supportsSelectForUpdate", true);
        this.map.put("supportsStatementPooling", false);
        this.map.put("supportsStoredFunctionsUsingCallSyntax", true);
        this.map.put("supportsStoredProcedures", true);
        this.map.put("supportsSubqueriesInComparisons", false);
        this.map.put("supportsSubqueriesInExists", false);
        this.map.put("supportsSubqueriesInIns", false);
        this.map.put("supportsSubqueriesInQuantifieds", false);
        this.map.put("supportsTableCorrelationNames", true);
        this.map.put("supportsTransactionIsolationLevel", true);
        this.map.put("supportsTransactions", true);
        this.map.put("supportsUnion", true);
        this.map.put("supportsUnionAll", true);
        this.map.put("updatesAreDetected", true);
        this.map.put("usesLocalFilePerTable", false);
        this.map.put("usesLocalFiles", false);
    }

    protected void close() throws SQLException {
        String methodName = "close";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        Integer i = 0;
        while (i < 21) {
            RDMStatement temp = this.stmtMap.remove(i);
            if (temp != null) {
                temp.close();
            }
            i = i + 1;
        }
        this.stmtMap = null;
        this.conn = null;
        this.logger.exiting(className, methodName);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.boolLookup("allProceduresAreCallable");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.boolLookup("allTablesAreSelectable");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.boolLookup("autoCommitFailureClosesAllResultSets");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.boolLookup("dataDefinitionCausesTransactionCommit");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.boolLookup("dataDefinitionIgnoredInTransactions");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return this.boolLookup("deletesAreDetected");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.boolLookup("doesMaxRowSizeIncludeBlobs");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return this.boolLookup("generatedKeysAlwaysReturned");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String methodName = "getAttributes";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, typeNamePattern, attributeNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(17);
        stmt.execute("SELECTnull TYPE_CAT,null TYPE_SCHEM,null TYPE_NAME,null ATTR_NAME,dbid DATA_TYPE,null ATTR_TYPE_NAME,dbid ATTR_SIZE,dbid DECIMAL_DIGITS,dbid NUM_PREC_RADIX,dbid NULLABLE,null REMARKS,null ATTR_DEF,dbid SQL_DATA_TYPE,dbid SQL_DATETIME_SUB,dbid CHAR_OCTET_LENGTH,dbid ORDINAL_POSITION,null IS_NULLABLE,null SCOPE_CATALOG,null SCOPE_SCHEMA,convert(0, smallint) SOURCE_DATA_TYPE FROM sys_dbinfo WHERE dbid = -1");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String methodName = "getBestRowIdentifier";
        this.logger.entering(className, methodName, new Object[]{catalog, schema, table, scope, nullable});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(0);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("ignored catalog parameter in DatabaseMetaData.getBestRowIdentifier"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select sys_scope SCOPE, name COLUMN_NAME, ");
        sb.append("jdbc_type DATA_TYPE, jdbc_type_name TYPE_NAME, ");
        sb.append("size COLUMN_SIZE, bufflen BUFFER_LENGTH, ");
        sb.append("dec_digits DECIMAL_DIGITS, pseudo_col PSEUDO_COLUMN ");
        sb.append("from sys_spcol where is_unique = 1 and identtype = 1 and ");
        if (schema != null) {
            sb.append("dbname like '" + schema + "' and ");
        }
        if (table != null) {
            sb.append("tabname like '" + table + "' and ");
        }
        if (!nullable) {
            sb.append("nullable = 0 and ");
        }
        sb.append("sys_scope >= " + scope + " ");
        sb.append("order by SCOPE");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String methodName = "getCatalogs";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(1);
        stmt.execute("SELECT DISTINCT catalog TABLE_CAT FROM sys_table");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.stringLookup("getCatalogSeparator");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.stringLookup("getCatalogTerm");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String methodName = "getClientInfoProperties";
        this.logger.entering(className, methodName);
        ResultSet rs = RDMSettings.getClientInfo();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String methodName = "getColumnPrivileges";
        this.logger.entering(className, methodName, new Object[]{catalog, schema, table, columnNamePattern});
        this._validate(methodName);
        throw this.createFeatureNotSupportedException("Table privileges not supprted");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String methodName = "getColumns";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern, columnNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(2);
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        stmt.execute("select catalog        TABLE_CAT, dbname         TABLE_SCHEM, tabname        TABLE_NAME, name           COLUMN_NAME, jdbc_type      DATA_TYPE, jdbc_type_name TYPE_NAME, size_jdbc      COLUMN_SIZE, bufflen        BUFFER_LENGTH, dec_digits     DECIMAL_DIGITS, num_prec_radix NUM_PREC_RADIX, nullable       NULLABLE, remarks        REMARKS, deflt          COLUMN_DEF, nonconcise_type SQL_DATA_TYPE, sub_type       SQL_DATETIME_SUB, octet_len      CHAR_OCTET_LENGTH, colno          ORDINAL_POSITION, nullable_str   IS_NULLABLE, scope_cat      SCOPE_CATALOG, scope_schem    SCOPE_SCHEMA, scope_table    SCOPE_TABLE, src_data_type  SOURCE_DATA_TYPE, is_autoinc     IS_AUTOINCREMENT FROM sys_column WHERE dbname like '" + schemaPattern + "' AND tabname LIKE '" + tableNamePattern + "' and name like '" + columnNamePattern + "' ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodName = "getConnection";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        this.logger.exiting(className, methodName, this.conn);
        return this.conn;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String methodName = "getCrossReference";
        this.logger.entering(className, methodName, new Object[]{primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(3);
        if (primaryCatalog != null) {
            stmt.addWarning(new SQLWarning("primaryCatalog parameter ignored in DatabaseMetaData.getCrossReference"));
        }
        if (foreignCatalog != null) {
            stmt.addWarning(new SQLWarning("foreignCatalog parameter ignored in DatabaseMetaData.getCrossReference"));
        }
        if (primarySchema == null) {
            primarySchema = "%";
        }
        if (primaryTable == null) {
            primaryTable = "%";
        }
        if (foreignSchema == null) {
            foreignSchema = "%";
        }
        if (foreignTable == null) {
            foreignTable = "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT pkcatalog PKTABLE_CAT, pkdbname PKTABLE_SCHEM, ");
        sb.append("pktabname PKTABLE_NAME, pkcolname PKCOLUMN_NAME, ");
        sb.append("fkcatalog FKTABLE_CAT, fkdbname FKTABLE_SCHEM, ");
        sb.append("fktabname FKTABLE_NAME, fkcolname FKCOLUMN_NAME, ");
        sb.append("key_seq KEY_SEQ, update_rule UPDATE_RULE, ");
        sb.append("delete_rule DELETE_RULE, fk_name FK_NAME, ");
        sb.append("pk_name PK_NAME, deferrability DEFERRABILITY ");
        sb.append("FROM sys_fkey WHERE pkdbname LIKE '" + primarySchema + "' AND ");
        sb.append("pktabname LIKE '" + primaryTable + "' AND ");
        sb.append("fkdbname LIKE '" + foreignSchema + "' AND ");
        sb.append("fktabname LIKE '" + foreignTable + "' ");
        sb.append("ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.intLookup("getDatabaseMajorVersion");
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.intLookup("getDatabaseMinorVersion");
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.stringLookup("getDatabaseProductName");
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.stringLookup("getDatabaseProductVersion");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.intLookup("getDefaultTransactionIsolation");
    }

    @Override
    public int getDriverMajorVersion() {
        return this.intLookupNoCheck("getDriverMajorVersion");
    }

    @Override
    public int getDriverMinorVersion() {
        return this.intLookupNoCheck("getDriverMinorVersion");
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.stringLookup("getDriverName");
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.stringLookup("getDriverVersion");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String methodName = "getExportedKeys";
        this.logger.entering(className, methodName, new Object[]{catalog, schema, table});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(4);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getExportedKeys"));
        }
        if (schema == null) {
            schema = "%";
        }
        if (table == null) {
            table = "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT pkcatalog PKTABLE_CAT, pkdbname PKTABLE_SCHEM, ");
        sb.append("pktabname PKTABLE_NAME, pkcolname PKCOLUMN_NAME, ");
        sb.append("fkcatalog FKTABLE_CAT, fkdbname FKTABLE_SCHEM, ");
        sb.append("fktabname FKTABLE_NAME, fkcolname FKCOLUMN_NAME, ");
        sb.append("key_seq KEY_SEQ, update_rule UPDATE_RULE, ");
        sb.append("delete_rule DELETE_RULE, fk_name FK_NAME, ");
        sb.append("pk_name PK_NAME, deferrability DEFERRABILITY ");
        sb.append("FROM sys_fkey WHERE pkdbname LIKE '" + schema + "' AND ");
        sb.append("pktabname LIKE '" + table + "' ");
        sb.append("ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.stringLookup("getExtraNameCharacters");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String methodName = "getFunctions";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        throw this.createFeatureNotSupportedException(methodName);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String methodName = "getFunctionColumns";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        throw this.createFeatureNotSupportedException(methodName);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.stringLookup("getIdentifierQuoteString");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String methodName = "getImportedKeys";
        this.logger.entering(className, methodName, new Object[]{catalog, schema, table});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(5);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getImportedKeys"));
        }
        if (schema == null) {
            schema = "%";
        }
        if (table == null) {
            table = "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT pkcatalog PKTABLE_CAT, pkdbname PKTABLE_SCHEM, ");
        sb.append("pktabname PKTABLE_NAME, pkcolname PKCOLUMN_NAME, ");
        sb.append("fkcatalog FKTABLE_CAT, fkdbname FKTABLE_SCHEM, ");
        sb.append("fktabname FKTABLE_NAME, fkcolname FKCOLUMN_NAME, ");
        sb.append("key_seq KEY_SEQ, update_rule UPDATE_RULE, ");
        sb.append("delete_rule DELETE_RULE, fk_name FK_NAME, ");
        sb.append("pk_name PK_NAME, deferrability DEFERRABILITY ");
        sb.append("FROM sys_fkey WHERE fkdbname LIKE '" + schema + "' AND ");
        sb.append("fktabname LIKE '" + table + "' ");
        sb.append("ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schemaPattern, String tableNamePattern, boolean unique, boolean approximate) throws SQLException {
        String methodName = "getIndexInfo";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern, unique, approximate});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(6);
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT catalog TABLE_CAT, dbname TABLE_SCHEM, ");
        sb.append("tabname TABLE_NAME, non_unique_jdbc NON_UNIQUE, ");
        sb.append("index_qual INDEX_QUALIFIER, index_name INDEX_NAME, ");
        sb.append("returned_type TYPE, colno ORDINAL_POSITION, ");
        sb.append("name COLUMN_NAME, asc_or_desc ASC_OR_DESC, ");
        sb.append("s_cardinality CARDINALITY, pages PAGES, ");
        sb.append("filter_cond FILTER_CONDITION ");
        sb.append("FROM sys_stat WHERE dbname LIKE '" + schemaPattern + "' AND ");
        sb.append("tabname LIKE '" + tableNamePattern + "' ");
        if (unique) {
            sb.append("AND non_unique_jdbc = 0 ");
        }
        sb.append("ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.intLookup("getJDBCMajorVersion");
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.intLookup("getJDBCMinorVersion");
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.intLookup("getMaxBinaryLiteralLength");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.intLookup("getMaxCatalogNameLength");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.intLookup("getMaxCharLiteralLength");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.intLookup("getMaxColumnNameLength");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.intLookup("getMaxColumnsInGroupBy");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.intLookup("getMaxColumnsInIndex");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.intLookup("getMaxColumnsInOrderBy");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.intLookup("getMaxColumnsInSelect");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.intLookup("getMaxColumnsInTable");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.intLookup("getMaxConnections");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.intLookup("getMaxCursorNameLength");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.intLookup("getMaxIndexLength");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.intLookup("getMaxProcedureNameLength");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.intLookup("getMaxRowSize");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.intLookup("getMaxSchemaNameLength");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.intLookup("getMaxStatementLength");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.intLookup("getMaxStatements");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.intLookup("getMaxTableNameLength");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.intLookup("getMaxTablesInSelect");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.intLookup("getMaxUserNameLength");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.stringLookup("getNumericFunctions");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String methodName = "getPrimaryKeys";
        this.logger.entering(className, methodName, new Object[]{catalog, schema, table});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(7);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getPrimaryKeys"));
        }
        if (schema == null) {
            schema = "%";
        }
        if (table == null) {
            table = "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select catalog TABLE_CAT, dbname TABLE_SCHEM, ");
        sb.append("tabname TABLE_NAME, colname COLUMN_NAME, ");
        sb.append("colno KEY_SEQ, name PK_NAME ");
        sb.append("from sys_key where is_primary = 1 AND dbname like '" + schema + "' and ");
        sb.append("tabname like '" + table + "' order by 5");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String methodName = "getProcedureColumns";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, procedureNamePattern, columnNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(16);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getProcedureColumns"));
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        stmt.execute("select catalog PROCEDURE_CAT, dbname PROCEDURE_SCHEM, procname PROCEDURE_NAME, name COLUMN_NAME, column_type COLUMN_TYPE, jdbc_type DATA_TYPE, jdbc_type_name TYPE_NAME, column_size COLUMN_SIZE, buffer_length LENGTH, decimal_digits SCALE, num_prec_radix RADIX, nullable NULLABLE, remarks REMARKS, column_default COLUMN_DEF, sql_data_type SQL_DATA_TYPE, sql_datetime_sub SQL_DATETIME_SUB, char_octet_length CHAR_OCTET_LENGTH, ordinal_position ORDINAL_POSITION, is_nullable IS_NULLABLE, specific_name SPECIFIC_NAME from sys_proccol where dbname like '" + schemaPattern + "' and procname like '" + procedureNamePattern + "' and name like '" + columnNamePattern + "' order by PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, SPECIFIC_NAME");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String methodName = "getProcedures";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, procedureNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(8);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getProcedures"));
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        }
        stmt.execute("select catalog            PROCEDURE_CAT, dbname             PROCEDURE_SCHEM, name               PROCEDURE_NAME, num_input_params   NUM_INPUT_PARAMS, num_output_params  NUM_OUTPUT_PARAMS, num_result_sets    NUM_RESULT_SETS, remarks            REMARKS, procedure_type     PROCEDURE_TYPE, name               SPECIFIC_NAME from sys_proc WHERE dbname like '" + schemaPattern + "' and name like '" + procedureNamePattern + "' order by 2, 3");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.stringLookup("getProcedureTerm");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String methodName = "getPseudoColumns";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern, columnNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(2);
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        stmt.execute("select catalog    TABLE_CAT, dbname     TABLE_SCHEM, tabname    TABLE_NAME, name       COLUMN_NAME, jdbc_type  DATA_TYPE, size       COLUMN_SIZE, dec_digits DECIMAL_DIGITS, num_prec_radix NUM_PREC_RADIX, column_usage   COLUMN_USAGE, remarks        REMARKS, octet_len      CHAR_OCTET_LENGTH, nullable_str   IS_NULLABLE from sys_column WHERE dbname like '" + schemaPattern + "' and tabname like '" + tableNamePattern + "' and name like '" + columnNamePattern + "' and is_pseudo = 2 order by 2, 3");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.intLookup("getResultSetHoldability");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        String methodName = "getRowIdLifetime";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RowIdLifetime result = (RowIdLifetime)((Object)this.map.get(methodName));
        this.logger.exiting(className, methodName, (Object)result);
        return result;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String methodName = "getSchemas";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(9);
        stmt.execute("SELECT DISTINCT dbname TABLE_SCHEM, catalog TABLE_CATALOG FROM sys_table");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String methodName = "getSchemas";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(9);
        StringBuilder s = new StringBuilder();
        s.append("select dbname TABLE_SCHEMA, null TABLE_CATALOG from sys_dbinfo");
        if (schemaPattern != null) {
            s.append(" where name like ");
            s.append(schemaPattern);
        }
        stmt.execute(s.toString());
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.stringLookup("getSchemaTerm");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.stringLookup("getSearchStringEscape");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.stringLookup("getSQLKeywords");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.intLookup("getSQLStateType");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.stringLookup("getStringFunctions");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String methodName = "getSuperTables";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(19);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getSuperTables"));
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        stmt.execute("select catalog TABLE_CAT, dbname TABLE_SCHEM, name TABLE_NAME, owner SUPERTABLE_NAME from sys_table where owner is not NULL and dbname like '" + schemaPattern + "' and name like '" + tableNamePattern + "'");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String methodName = "getSuperTypes";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, typeNamePattern});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(20);
        stmt.execute("select null TYPE_CAT, null TYPE_SCHEM, null TYPE_NAME, null SUPERTYPE_CAT, null SUPERTYPE_SCHEM, null SUPERTYPE_NAME from sys_dbinfo where dbid=-1");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.stringLookup("getSystemFunctions");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String methodName = "getTablePrivileges";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern});
        this._validate(methodName);
        throw this.createFeatureNotSupportedException("Table privileges not supprted");
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String methodName = "getTables";
        StringBuilder sb = new StringBuilder();
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern, types});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(10);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("catalog parameter ignored in DatabaseMetaData.getTables"));
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        sb.append("SELECT catalog TABLE_CAT, dbname TABLE_SCHEM, name TABLE_NAME, type TABLE_TYPE, remarks REMARKS, null TYPE_CAT, null TYPE_SCHEM, null TYPE_NAME, null SELF_REFERENCING_COL_NAME, null REF_GENERATION FROM sys_table WHERE dbname like '" + schemaPattern + "' and name like '" + tableNamePattern + "'");
        if (types != null) {
            sb.append(" and type in (");
            for (int ii = 0; ii < types.length; ++ii) {
                if (ii > 0) {
                    sb.append(',');
                }
                sb.append("'" + types[ii] + "'");
            }
            sb.append(')');
        }
        sb.append(" order by 4, 2, 3");
        stmt.execute(sb.toString());
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String methodName = "getTableTypes";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(11);
        stmt.execute("SELECT name TABLE_TYPE FROM sys_tabtype ORDER BY 1");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.stringLookup("getTimeDateFunctions");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String methodName = "getTypeInfo";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(12);
        ResultSet rs = stmt.executeQuery("SELECT * FROM sys_type_jdbc");
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String tableNamePattern, int[] types) throws SQLException {
        String methodName = "getUDTs";
        this.logger.entering(className, methodName, new Object[]{catalog, schemaPattern, tableNamePattern, types});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(13);
        stmt.execute("select null TYPE_CAT, null TYPE_SCHEM, null TYPE_NAME,null CLASS_NAME, dbid DATA_TYPE, null REMARKS, null BASE_TYPE from sys_dbinfo where dbid = -1");
        ResultSet rs = stmt.getResultSet();
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public String getURL() throws SQLException {
        return this.stringLookup("getURL");
    }

    @Override
    public String getUserName() throws SQLException {
        return this.stringLookup("getUserName");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String methodName = "getVersionColumns";
        this.logger.entering(className, methodName, new Object[]{catalog, schema, table});
        this._validate(methodName);
        RDMStatement stmt = this._getStatement(15);
        if (catalog != null) {
            stmt.addWarning(new SQLWarning("ignored catalog parameter in DatabaseMetaData.getVersionColumns"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select sys_scope SCOPE, name COLUMN_NAME, ");
        sb.append("jdbc_type DATA_TYPE, jdbc_type_name TYPE_NAME, ");
        sb.append("size COLUMN_SIZE, bufflen BUFFER_LENGTH, ");
        sb.append("dec_digits DECIMAL_DIGITS, pseudo_col PSEUDO_COLUMN ");
        sb.append("from sys_spcol where ");
        if (schema != null) {
            sb.append("dbname like '" + schema + "' and ");
        }
        if (table != null) {
            sb.append("tabname like '" + table + "' and ");
        }
        sb.append("identtype = 0");
        ResultSet rs = stmt.executeQuery(sb.toString());
        this.logger.exiting(className, methodName, rs);
        return rs;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return this.boolLookup("insertsAreDetected");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.boolLookup("isCatalogAtStart");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String methodName = "isReadOnly";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        boolean flag = this.conn.isReadOnly();
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.boolLookup("locatorsUpdateCopy");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.boolLookup("nullPlusNonNullIsNull");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.boolLookup("nullsAreSortedAtEnd");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.boolLookup("nullsAreSortedAtStart");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.boolLookup("nullsAreSortedHigh");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.boolLookup("nullsAreSortedLow");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.boolLookup("othersDeletesAreVisible");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.boolLookup("othersInsertsAreVisible");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.boolLookup("othersUpdatesAreVisible");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.boolLookup("ownDeletesAreVisible");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.boolLookup("ownInsersAreVisible");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.boolLookup("ownUpdatesAreVisible");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.boolLookup("storesLowerCaseIdentifiers");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.boolLookup("storesLowerCaseQuotedIdentifiers");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.boolLookup("storesMixedCaseIdentifiers");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.boolLookup("storesMixedCaseQuotedIdentifiers");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.boolLookup("storesUpperCaseIdentifiers");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.boolLookup("storesUpperCaseQuotedIdentifiers");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.boolLookup("supportsAlterTableWithAddColumn");
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.boolLookup("supportsAlterTableWithDropColumn");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.boolLookup("supportsANSI92EntryLevelSQL");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.boolLookup("supportsANSI92FullSQL");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.boolLookup("supportsANSI92IntermediateSQL");
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.boolLookup("supportsBatchUpdates");
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.boolLookup("supportsCatalogsInDataManipulation");
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.boolLookup("supportsCatalogsInIndexDefintions");
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.boolLookup("supportsCatalogsInPrivilegeDefinitions");
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.boolLookup("supportsCatalogsInProcedureCalls");
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.boolLookup("supportsCatalogsInTableDefinitions");
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.boolLookup("supportsColumnAliasing");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.boolLookup("supportsConvert");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.boolLookup("supportsConvert");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.boolLookup("supportsCoreSQLGrammar");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.boolLookup("supportsCorrelatedSubqueries");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.boolLookup("supportsDataDefinitionAndDataManipulationTransactions");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.boolLookup("supportsDataManipulationTransactionsOnly");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.boolLookup("supportsDifferentTableCorrelationNames");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.boolLookup("supportsExpressionsInOrderBy");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.boolLookup("supportsExtendedSQLGrammar");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.boolLookup("supportsFullOuterJoins");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.boolLookup("supportsGetGeneratedKeys");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.boolLookup("supportsGroupBy");
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.boolLookup("supportsGroupByBeyondSelect");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.boolLookup("supportsGroupByUnrelated");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.boolLookup("supportsIntegrityEnhancementFacility");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.boolLookup("supportsLikeEscapeClause");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.boolLookup("supportsLimitedOuterJoins");
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.boolLookup("supportsMinimumSQLGrammar");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.boolLookup("supportsMixedCaseIdentifiers");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.boolLookup("supportsMixedCaseQuotedIdentifiers");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.boolLookup("supportsMultipleOpenResults");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.boolLookup("supportsMultipleResultSets");
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.boolLookup("supportsMultipleTransactions");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.boolLookup("supportsNamedParameters");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.boolLookup("supportsNonNullableColumns");
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.boolLookup("supportsOpenCursorsAcrossCommit");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.boolLookup("supportsOpenCursorsAcrossRollback");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.boolLookup("supportsOpenStatementsAcrossCommit");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.boolLookup("supportsOpenStatementsAcrossRollback");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.boolLookup("supportsOrderByUnrelated");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.boolLookup("supportsOuterJoins");
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.boolLookup("supportsPositionedDelete");
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.boolLookup("supportsPositionedUpdate");
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        String methodName = "supportsResultSetConcurrency";
        this.logger.entering(className, methodName, new Object[]{type, concurrency});
        this._validate(methodName);
        boolean flag = type == 1003 && concurrency == 1007;
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        String methodName = "supportsResultSetHoldability";
        this.logger.entering(className, methodName, holdability);
        this._validate(methodName);
        boolean flag = holdability == 2;
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        String methodName = "supportsResultSetType";
        this.logger.entering(className, methodName, type);
        this._validate(methodName);
        boolean flag = type == 1003;
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.boolLookup("supportsSavepoints");
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.boolLookup("supportsSchemasInDataManipulation");
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.boolLookup("supportsSchemasInIndexDefinitions");
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.boolLookup("supportsSchemasInPrivilegeDefintions");
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.boolLookup("supportsSchemasInProcedureCalls");
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.boolLookup("supportsSchemasInTableDefinitions");
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.boolLookup("supportsSelectForUpdate");
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.boolLookup("supportsStatementPooling");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.boolLookup("supportsStoredFunctionsUsingCallSyntax");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.boolLookup("supportsStoredProcedures");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.boolLookup("supportsSubqueriesInComparisons");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.boolLookup("supportsSubqueriesInExists");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.boolLookup("supportsSubqueriesInIns");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.boolLookup("supportsSubqueriesInQuantifieds");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.boolLookup("supportsTableCorrelationNames");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.boolLookup("supportsTransactionIsolationLevel");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.boolLookup("supportsTransactions");
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.boolLookup("supportsUnion");
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.boolLookup("supportsUnionAll");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return this.boolLookup("updatesAreDetected");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.boolLookup("usesLocalFilePerTable");
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.boolLookup("usesLocalFiles");
    }

    private RDMStatement _getStatement(Integer idx) throws SQLException {
        RDMStatement stmt = this.stmtMap.get(idx);
        if (stmt == null) {
            stmt = (RDMStatement)this.conn.createStatement();
            this.stmtMap.put(idx, stmt);
        }
        return stmt;
    }

    private void _validate(String methodName) throws SQLException {
        if (this.conn == null) {
            throw this.createSQLException(methodName, "Invalid DatabaseMetaData");
        }
    }

    private String stringLookup(String id) throws SQLException {
        this.logger.entering(className, id);
        this._validate(id);
        String result = (String)this.map.get(id);
        this.logger.exiting(className, id, result);
        return result;
    }

    private int intLookup(String id) throws SQLException {
        this.logger.entering(className, id);
        this._validate(id);
        Integer result = (Integer)this.map.get(id);
        this.logger.exiting(className, id, result);
        return result;
    }

    private int intLookupNoCheck(String id) {
        this.logger.entering(className, id);
        Integer result = (Integer)this.map.get(id);
        this.logger.exiting(className, id, result);
        return result;
    }

    private boolean boolLookup(String id) throws SQLException {
        this.logger.entering(className, id);
        this._validate(id);
        boolean result = (Boolean)this.map.get(id);
        this.logger.exiting(className, id, result);
        return result;
    }

    private SQLException createFeatureNotSupportedException(String methodName) throws SQLException {
        SQLException sqlex = new SQLException("Feature not supported (" + methodName + ")");
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(methodName);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

