/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.net.MalformedURLException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLConstants;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSourceInfo;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDialect;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEngine;
import org.jkiss.dbeaver.ext.mysql.model.MySQLExecutionContext;
import org.jkiss.dbeaver.ext.mysql.model.MySQLHelpProvider;
import org.jkiss.dbeaver.ext.mysql.model.MySQLParameter;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPlugin;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLStructureAssistant;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.model.QueryTransformerFetchAll;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAnalyser;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSessionManager;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.gis.SpatialDataProvider;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLHelpProvider;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class MySQLDataSource
extends JDBCDataSource
implements DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(MySQLDataSource.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+).+");
    private static final Map<String, String> PROHIBITED_DRIVER_PROPERTIES = new HashMap<String, String>();
    private final JDBCBasicDataTypeCache<MySQLDataSource, JDBCDataType> dataTypeCache;
    private List<MySQLEngine> engines;
    private final CatalogCache catalogCache = new CatalogCache(this){

        protected void detectCaseSensitivity(DBSObject object) {
            this.setCaseSensitive(!this.getDataSource().getSQLDialect().useCaseInsensitiveNameLookup());
        }
    };
    private List<MySQLPrivilege> privileges;
    private List<MySQLUser> users;
    private List<MySQLCharset> charsets;
    private List<MySQLPlugin> plugins;
    private Map<String, MySQLCollation> collations;
    private String defaultCharset;
    private String defaultCollation;
    private int lowerCaseTableNames = 1;
    private SQLHelpProvider helpProvider;
    private volatile boolean hasStatistics;
    private boolean containsCheckConstraintTable;
    private transient boolean inServerTimezoneHandle;
    private Boolean readeAllCaches;
    private Version version;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile(" at line ([0-9]+)");

    static {
        PROHIBITED_DRIVER_PROPERTIES.putAll(Map.of("autoDeserialize", "false", "allowLocalInfile", "false", "allowLoadLocalInfile", "false", "allowUrlInLocalInfile", "false"));
        PROHIBITED_DRIVER_PROPERTIES.put("allowLoadLocalInfileInPath", null);
    }

    public MySQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        this(monitor, container, (SQLDialect)new MySQLDialect());
    }

    public MySQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SQLDialect dialect) throws DBException {
        super(monitor, container, dialect);
        this.dataTypeCache = new JDBCBasicDataTypeCache((DBSObject)this);
        this.hasStatistics = !container.getPreferenceStore().getBoolean("database.stats.expensive");
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.max-string-type-length": {
                if (this.isServerVersionAtLeast(5, 0)) {
                    return 65535;
                }
                return 255;
            }
            case "datasource.limit-affects-dml": {
                return true;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    int getLowerCaseTableNames() {
        return this.lowerCaseTableNames;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        String zeroDateTimeBehavior;
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(MySQLDataSourceProvider.getConnectionsProps());
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("mysql_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(monitor, props, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        } else {
            props.put("useSSL", "false");
        }
        String serverTZ = connectionInfo.getProviderProperty("@dbeaver-serverTimezone@");
        if (CommonUtils.isEmpty((String)serverTZ) && this.inServerTimezoneHandle) {
            serverTZ = "UTC";
        }
        if (!CommonUtils.isEmpty((String)serverTZ)) {
            props.put("serverTimezone", serverTZ);
        }
        if (!this.isMariaDB() && (zeroDateTimeBehavior = connectionInfo.getProperty("zeroDateTimeBehavior")) == null) {
            try {
                Driver driverInstance = (Driver)driver.getDriverInstance(monitor);
                if (driverInstance != null) {
                    if (driverInstance.getMajorVersion() >= 8) {
                        props.put("zeroDateTimeBehavior", "CONVERT_TO_NULL");
                    } else {
                        props.put("zeroDateTimeBehavior", "convertToNull");
                    }
                }
            }
            catch (Exception exception) {
                log.debug((Object)"Error setting MySQL zeroDateTimeBehavior property default");
            }
        }
        return props;
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new MySQLDataSourceInfo(metaData);
    }

    private void initSSL(DBRProgressMonitor monitor, Map<String, String> props, DBWHandlerConfiguration sslConfig) throws Exception {
        boolean retrievePublicKey;
        monitor.subTask("Install SSL certificates");
        DBACertificateStorage securityManager = DBWorkbench.getPlatform().getCertificateStorage();
        props.put("useSSL", "true");
        if (this.isMariaDB()) {
            props.put("trustServerCertificate", String.valueOf(!sslConfig.getBooleanProperty("ssl.verify.server")));
        } else {
            props.put("verifyServerCertificate", String.valueOf(sslConfig.getBooleanProperty("ssl.verify.server")));
            props.put("requireSSL", String.valueOf(sslConfig.getBooleanProperty("ssl.require")));
        }
        byte[] caCertData = SSLHandlerTrustStoreImpl.readCertificate((DBWHandlerConfiguration)sslConfig, (String)"ssl.ca.cert", (String)"ssl.ca.cert");
        byte[] clientCertData = SSLHandlerTrustStoreImpl.readCertificate((DBWHandlerConfiguration)sslConfig, (String)"ssl.client.cert", (String)"ssl.client.cert");
        byte[] keyData = SSLHandlerTrustStoreImpl.readCertificate((DBWHandlerConfiguration)sslConfig, (String)"ssl.client.key", (String)"ssl.client.key");
        if (caCertData != null || clientCertData != null) {
            securityManager.addCertificate(this.getContainer(), "ssl", caCertData, clientCertData, keyData);
        } else {
            securityManager.deleteCertificate(this.getContainer(), "ssl");
        }
        String ksPath = this.makeKeyStorePath(securityManager.getKeyStorePath(this.getContainer(), "ssl"));
        char[] ksPass = securityManager.getKeyStorePassword(this.getContainer(), "ssl");
        if (this.isMariaDB()) {
            props.put("trustStore", ksPath);
            props.put("trustStorePassword", String.valueOf(ksPass));
        } else {
            props.put("clientCertificateKeyStoreUrl", ksPath);
            props.put("trustCertificateKeyStoreUrl", ksPath);
            props.put("clientCertificateKeyStorePassword", String.valueOf(ksPass));
            props.put("trustCertificateKeyStorePassword", String.valueOf(ksPass));
        }
        String cipherSuites = sslConfig.getStringProperty("ssl.cipher.suites");
        if (!CommonUtils.isEmpty((String)cipherSuites)) {
            props.put("enabledSSLCipherSuites;", cipherSuites);
        }
        if (retrievePublicKey = sslConfig.getBooleanProperty("ssl.public.key.retrieve")) {
            props.put("allowPublicKeyRetrieval", "true");
        }
        if (sslConfig.getBooleanProperty("ssl.debug")) {
            System.setProperty("javax.net.debug", "all");
        }
    }

    private String makeKeyStorePath(Path keyStorePath) throws MalformedURLException {
        if (this.isMariaDB()) {
            return keyStorePath.toAbsolutePath().toString();
        }
        return keyStorePath.toUri().toURL().toString();
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new MySQLExecutionContext(instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        if (initFrom != null && !((JDBCDataSource)context.getDataSource()).getContainer().isConnectionReadOnly()) {
            MySQLCatalog object = ((MySQLExecutionContext)initFrom).getDefaultCatalog();
            if (object != null) {
                ((MySQLExecutionContext)context).setCurrentDatabase(monitor, object);
            }
        } else {
            ((MySQLExecutionContext)context).refreshDefaults(monitor, true);
        }
    }

    public String[] getTableTypes() {
        return MySQLConstants.TABLE_TYPES;
    }

    public CatalogCache getCatalogCache() {
        return this.catalogCache;
    }

    public Collection<MySQLCatalog> getCatalogs() {
        return this.catalogCache.getCachedObjects();
    }

    public MySQLCatalog getCatalog(String name) {
        return (MySQLCatalog)this.catalogCache.getCachedObject(name);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        if (!this.isMariaDB() && this.isServerVersionAtLeast(5, 7) && this.dataTypeCache.getCachedObject("json") == null) {
            this.dataTypeCache.cacheObject((DBSObject)new JDBCDataType((DBSObject)this, 1111, "json", "json", false, true, 0, 0, 0));
        }
        if (this.isMariaDB() && this.isServerVersionAtLeast(10, 7) && this.dataTypeCache.getCachedObject("uuid") == null) {
            this.dataTypeCache.cacheObject((DBSObject)new JDBCDataType((DBSObject)this, 1, "uuid", "uuid", false, true, 0, 0, 0));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load basic datasource metadata");){
            JDBCResultSet dbResult;
            Object var9_33;
            Throwable throwable2;
            JDBCPreparedStatement dbStat;
            Object var6_18;
            Throwable throwable3;
            this.engines = new ArrayList<MySQLEngine>();
            try {
                throwable3 = null;
                var6_18 = null;
                try {
                    dbStat = session.prepareStatement("SHOW ENGINES");
                    try {
                        throwable2 = null;
                        var9_33 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.next()) {
                                    MySQLEngine engine = new MySQLEngine(this, (ResultSet)dbResult);
                                    this.engines.add(engine);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {}
            this.charsets = new ArrayList<MySQLCharset>();
            try {
                throwable3 = null;
                var6_18 = null;
                try {
                    dbStat = session.prepareStatement("SHOW CHARSET");
                    try {
                        throwable2 = null;
                        var9_33 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.next()) {
                                    MySQLCharset charset = new MySQLCharset(this, (ResultSet)dbResult);
                                    this.charsets.add(charset);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable3 == null) {
                        throwable3 = throwable7;
                    } else if (throwable3 != throwable7) {
                        throwable3.addSuppressed(throwable7);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {}
            this.charsets.sort(DBUtils.nameComparator());
            this.collations = new LinkedHashMap<String, MySQLCollation>();
            try {
                throwable3 = null;
                var6_18 = null;
                try {
                    dbStat = session.prepareStatement("SHOW COLLATION");
                    try {
                        throwable2 = null;
                        var9_33 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.next()) {
                                    String charsetName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARSET");
                                    MySQLCharset charset = this.getCharset(charsetName);
                                    if (charset == null) {
                                        log.warn((Object)("Charset '" + charsetName + "' not found."));
                                        continue;
                                    }
                                    MySQLCollation collation = new MySQLCollation(charset, (ResultSet)dbResult);
                                    this.collations.put(collation.getName(), collation);
                                    charset.addCollation(collation);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable8) {
                            if (throwable2 == null) {
                                throwable2 = throwable8;
                            } else if (throwable2 != throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable9) {
                    if (throwable3 == null) {
                        throwable3 = throwable9;
                    } else if (throwable3 != throwable9) {
                        throwable3.addSuppressed(throwable9);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {}
            try {
                throwable3 = null;
                var6_18 = null;
                try {
                    dbStat = session.prepareStatement("SELECT @@GLOBAL.character_set_server,@@GLOBAL.collation_server");
                    try {
                        throwable2 = null;
                        var9_33 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                if (dbResult.next()) {
                                    this.defaultCharset = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                                    this.defaultCollation = JDBCUtils.safeGetString((ResultSet)dbResult, (int)2);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            if (throwable2 == null) {
                                throwable2 = throwable10;
                            } else if (throwable2 != throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable11) {
                    if (throwable3 == null) {
                        throwable3 = throwable11;
                    } else if (throwable3 != throwable11) {
                        throwable3.addSuppressed(throwable11);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable ex) {
                log.debug((Object)"Error reading default server charset/collation", ex);
            }
            this.plugins = new ArrayList<MySQLPlugin>();
            if (this.supportsPlugins()) {
                try {
                    ex = null;
                    var6_18 = null;
                    try {
                        dbStat = session.prepareStatement("SHOW PLUGINS");
                        try {
                            throwable2 = null;
                            var9_33 = null;
                            try {
                                dbResult = dbStat.executeQuery();
                                try {
                                    while (dbResult.next()) {
                                        this.plugins.add(new MySQLPlugin(this, (ResultSet)dbResult));
                                    }
                                }
                                finally {
                                    if (dbResult != null) {
                                        dbResult.close();
                                    }
                                }
                            }
                            catch (Throwable throwable12) {
                                if (throwable2 == null) {
                                    throwable2 = throwable12;
                                } else if (throwable2 != throwable12) {
                                    throwable2.addSuppressed(throwable12);
                                }
                                throw throwable2;
                            }
                        }
                        finally {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                        }
                    }
                    catch (Throwable throwable13) {
                        if (ex == null) {
                            ex = throwable13;
                        } else if (ex != throwable13) {
                            ex.addSuppressed(throwable13);
                        }
                        throw ex;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)"Error reading plugins information", (Throwable)e);
                }
            }
            try {
                Throwable e = null;
                var6_18 = null;
                try {
                    dbStat = session.prepareStatement("SHOW VARIABLES LIKE 'lower_case_table_names'");
                    try {
                        throwable2 = null;
                        var9_33 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                if (dbResult.next()) {
                                    this.lowerCaseTableNames = JDBCUtils.safeGetInt((ResultSet)dbResult, (int)2);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable14) {
                            if (throwable2 == null) {
                                throwable2 = throwable14;
                            } else if (throwable2 != throwable14) {
                                throwable2.addSuppressed(throwable14);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable15) {
                    if (e == null) {
                        e = throwable15;
                    } else if (e != throwable15) {
                        e.addSuppressed(throwable15);
                    }
                    throw e;
                }
            }
            catch (Throwable ex) {
                log.debug((Object)"Error reading default server charset/collation", ex);
            }
            this.catalogCache.getAllObjects(monitor, (DBSObject)this);
            if (this.supportsInformationSchema()) {
                try {
                    String resultSet = JDBCUtils.queryString((Connection)session, (String)"SELECT * FROM information_schema.TABLES t\nWHERE\n\tt.TABLE_SCHEMA = 'information_schema'\n\tAND t.TABLE_NAME = 'CHECK_CONSTRAINTS'", (Object[])new Object[0]);
                    this.containsCheckConstraintTable = resultSet != null;
                }
                catch (SQLException e) {
                    log.debug((Object)"Error reading information schema", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable16) {
            if (throwable == null) {
                throwable = throwable16;
            } else if (throwable != throwable16) {
                throwable.addSuppressed(throwable16);
            }
            throw throwable;
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.engines = null;
        this.catalogCache.clearCache();
        this.users = null;
        this.initialize(monitor);
        return this;
    }

    MySQLTable findTable(DBRProgressMonitor monitor, String catalogName, String tableName) throws DBException {
        if (CommonUtils.isEmpty((String)catalogName)) {
            return null;
        }
        MySQLCatalog catalog = this.getCatalog(catalogName);
        if (catalog == null) {
            log.error((Object)("Catalog " + catalogName + " not found"));
            return null;
        }
        return catalog.getTable(monitor, tableName);
    }

    public Collection<? extends MySQLCatalog> getChildren(@NotNull DBRProgressMonitor monitor) {
        return this.getCatalogs();
    }

    public MySQLCatalog getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        return this.getCatalog(childName);
    }

    @NotNull
    public Class<? extends MySQLCatalog> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return MySQLCatalog.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) {
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection mysqlConnection;
        try {
            mysqlConnection = super.openConnection(monitor, context, purpose);
        }
        catch (DBCException e) {
            if (e.getCause() instanceof SQLException && SQLState.SQL_01S00.getCode().equals(((SQLException)e.getCause()).getSQLState()) && CommonUtils.isEmpty((String)this.getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-serverTimezone@"))) {
                log.debug((Object)("Error connecting without serverTimezone. Trying to set serverTimezone=UTC. Original error: " + e.getMessage()));
                this.inServerTimezoneHandle = true;
                try {
                    mysqlConnection = super.openConnection(monitor, context, purpose);
                }
                catch (DBCException e2) {
                    this.inServerTimezoneHandle = false;
                    throw e2;
                }
            }
            throw e;
        }
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                mysqlConnection.setClientInfo("ApplicationName", DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose));
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return mysqlConnection;
    }

    public List<MySQLUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        if (this.users == null) {
            this.users = this.loadUsers(monitor);
        }
        return this.users;
    }

    public MySQLUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLUser)DBUtils.findObject(this.getUsers(monitor), (String)name);
    }

    /*
     * Exception decompiling
     */
    private List<MySQLUser> loadUsers(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<MySQLEngine> getEngines() {
        return this.engines;
    }

    public MySQLEngine getEngine(String name) {
        return (MySQLEngine)DBUtils.findObject(this.engines, (String)name);
    }

    public MySQLEngine getDefaultEngine() {
        for (MySQLEngine engine : this.engines) {
            if (engine.getSupport() != MySQLEngine.Support.DEFAULT) continue;
            return engine;
        }
        return null;
    }

    public Collection<MySQLCharset> getCharsets() {
        return this.charsets;
    }

    public MySQLCharset getCharset(String name) {
        for (MySQLCharset charset : this.charsets) {
            if (!charset.getName().equals(name)) continue;
            return charset;
        }
        return null;
    }

    public MySQLCollation getCollation(String name) {
        return this.collations.get(name);
    }

    public MySQLCharset getDefaultCharset() {
        return this.getCharset(this.defaultCharset);
    }

    public MySQLCollation getDefaultCollation() {
        return this.getCollation(this.defaultCollation);
    }

    @NotNull
    public Collection<MySQLPlugin> getPlugins() {
        return this.plugins;
    }

    @Nullable
    public MySQLPlugin getPlugin(@NotNull String name) {
        for (MySQLPlugin plugin : this.plugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public List<MySQLPrivilege> getPrivileges(DBRProgressMonitor monitor) throws DBException {
        if (this.privileges == null) {
            this.privileges = this.loadPrivileges(monitor);
        }
        return this.privileges;
    }

    public List<MySQLPrivilege> getPrivilegesByKind(DBRProgressMonitor monitor, MySQLPrivilege.Kind kind) throws DBException {
        ArrayList<MySQLPrivilege> privs = new ArrayList<MySQLPrivilege>();
        for (MySQLPrivilege priv : this.getPrivileges(monitor)) {
            if (priv.getKind() != kind) continue;
            privs.add(priv);
        }
        return privs;
    }

    public MySQLPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLPrivilege)DBUtils.findObject(this.getPrivileges(monitor), (String)name, (boolean)true);
    }

    /*
     * Exception decompiling
     */
    private List<MySQLPrivilege> loadPrivileges(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<MySQLParameter> getSessionStatus(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, true, false);
    }

    public List<MySQLParameter> getGlobalStatus(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, true, true);
    }

    public List<MySQLParameter> getSessionVariables(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, false, false);
    }

    public List<MySQLParameter> getGlobalVariables(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, false, true);
    }

    public List<MySQLDataSource> getInformation() {
        return Collections.singletonList(this);
    }

    /*
     * Exception decompiling
     */
    private List<MySQLParameter> loadParameters(DBRProgressMonitor monitor, boolean status, boolean global) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit();
        }
        if (type == DBCQueryTransformType.FETCH_ALL_TABLE) {
            return new QueryTransformerFetchAll(this);
        }
        return super.createQueryTransformer(type);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new MySQLStructureAssistant(this));
        }
        if (adapter == SQLHelpProvider.class) {
            if (this.helpProvider == null) {
                this.helpProvider = new MySQLHelpProvider(this);
            }
            return adapter.cast(this.helpProvider);
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new MySQLSessionManager(this));
        }
        if (adapter == SpatialDataProvider.class) {
            return adapter.cast(new SpatialDataProvider(){

                public boolean isFlipCoordinates() {
                    return false;
                }

                public int getDefaultSRID() {
                    return 4326;
                }
            });
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new MySQLPlanAnalyser(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.dataTypeCache.getCachedObject(typeID);
    }

    public String getDefaultDataTypeName(DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "TINYINT(1)";
            }
            case NUMERIC: {
                return "BIGINT";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case BINARY: {
                return "BINARY";
            }
            case CONTENT: {
                return "LONGBLOB";
            }
            case ROWID: {
                return "BINARY";
            }
        }
        return "VARCHAR";
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        if (!this.isMariaDB() && !this.isServerVersionAtLeast(4, 1)) {
            this.hasStatistics = true;
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load table status");){
                try {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT table_schema, SUM(data_length + index_length) \nFROM information_schema.tables \nGROUP BY table_schema");){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String dbName = dbResult.getString(1);
                                MySQLCatalog catalog = (MySQLCatalog)this.catalogCache.getObject(monitor, (DBSObject)this, dbName);
                                if (catalog == null) continue;
                                long dbSize = dbResult.getLong(2);
                                catalog.setDatabaseSize(dbSize);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    @NotNull
    public MySQLCatalog createCatalogInstance(@NotNull MySQLDataSource owner, @NotNull JDBCResultSet resultSet) {
        return new MySQLCatalog(owner, (ResultSet)resultSet);
    }

    public boolean isMariaDB() {
        return "org.mariadb.jdbc.Driver".equals(this.getContainer().getDriver().getDriverClassName());
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (this.isMariaDB() && "08".equals(SQLState.getStateFromException((Throwable)error))) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return super.discoverErrorType(error);
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.line = Integer.parseInt(matcher.group(1)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }

    public boolean supportsCheckConstraints() {
        if (this.isMariaDB()) {
            return this.isServerVersionAtLeast(10, 2) && this.containsCheckConstraintTable;
        }
        return this.isServerVersionAtLeast(8, 0) && this.containsCheckConstraintTable;
    }

    public boolean supportsInformationSchema() {
        return this.isServerVersionAtLeast(5, 0);
    }

    public boolean supportsSequences() {
        if (this.isMariaDB()) {
            return this.isServerVersionAtLeast(10, 3);
        }
        return false;
    }

    public boolean supportsColumnStatistics() {
        return !this.isMariaDB() && this.isServerVersionAtLeast(8, 0);
    }

    public boolean supportsUserManagement() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-users"), (boolean)true);
    }

    public boolean supportsEvents() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-events"), (boolean)true);
    }

    public boolean supportsAlterView() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-alter-view"), (boolean)false);
    }

    @Association
    public boolean supportsPlugins() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-plugins"), (boolean)true);
    }

    @Association
    public boolean supportsPartitions() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-partitions"), (boolean)true) && this.isServerVersionAtLeast(5, 1);
    }

    @Association
    public boolean supportsTriggers() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-triggers"), (boolean)true);
    }

    @Association
    public boolean supportsCharsets() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-charsets"), (boolean)true);
    }

    @Association
    public boolean supportsCollations() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-collations"), (boolean)true);
    }

    @Association
    public boolean supportsNativeClients() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supportsClients"), (boolean)true);
    }

    public boolean isSystemCatalog(String name) {
        return "information_schema".equalsIgnoreCase(name) || "performance_schema".equalsIgnoreCase(name) || "mysql".equalsIgnoreCase(name);
    }

    public boolean supportsFetchTransform() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-mysql-fetch-transform"), (boolean)true);
    }

    public boolean supportsSysSchema() {
        return this.isMariaDB() ? this.isServerVersionAtLeast(10, 6) : this.isServerVersionAtLeast(5, 7);
    }

    public List<DBSIndexType> supportedIndexTypes() {
        return Arrays.asList(MySQLConstants.INDEX_TYPE_BTREE, MySQLConstants.INDEX_TYPE_FULLTEXT, MySQLConstants.INDEX_TYPE_HASH, MySQLConstants.INDEX_TYPE_RTREE);
    }

    public boolean supportsAlterTableRenameSyntax() {
        return false;
    }

    public boolean supportsConditionForShowDatabasesStatement() {
        return true;
    }

    private Version getVersion() {
        String versionInfo;
        Matcher matcher;
        if (this.version == null && (matcher = VERSION_PATTERN.matcher(versionInfo = this.getInfo().getDatabaseProductVersion())).matches()) {
            this.version = new Version(matcher.group(1));
        }
        return this.version;
    }

    public boolean readKeysWithColumns() {
        if (this.readeAllCaches == null) {
            this.readeAllCaches = CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("cache-meta-data"), (boolean)true);
            if (this.readeAllCaches.booleanValue()) {
                if (this.isMariaDB()) {
                    this.readeAllCaches = this.isServerVersionAtLeast(10, 4);
                } else if (this.getVersion() != null) {
                    Version version = this.getVersion();
                    this.readeAllCaches = version.getMajor() >= 8 && version.getMinor() >= 0 && version.getMicro() >= 21;
                }
            }
        }
        return this.readeAllCaches;
    }

    protected void fillConnectionProperties(DBPConnectionConfiguration connectionInfo, Properties connectProps) {
        super.fillConnectionProperties(connectionInfo, connectProps);
        if (!DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return;
        }
        for (String prohibitedDriverProperty : PROHIBITED_DRIVER_PROPERTIES.keySet()) {
            String propertyValue;
            if (connectProps.containsKey(prohibitedDriverProperty)) {
                log.warn((Object)("The driver settings contain a prohibited property, this property will be forcibly removed: " + prohibitedDriverProperty));
            }
            if ((propertyValue = PROHIBITED_DRIVER_PROPERTIES.get(prohibitedDriverProperty)) == null) {
                connectProps.remove(prohibitedDriverProperty);
                continue;
            }
            log.debug((Object)("Set " + prohibitedDriverProperty + ":" + propertyValue));
            connectProps.put(prohibitedDriverProperty, propertyValue);
        }
    }

    public class CatalogCache
    extends JDBCObjectCache<MySQLDataSource, MySQLCatalog> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLDataSource owner) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("show databases");
            DBSObjectFilter catalogFilters = owner.getContainer().getObjectFilter(MySQLCatalog.class, null, false);
            if (catalogFilters != null) {
                boolean supportsCondition = owner.supportsConditionForShowDatabasesStatement();
                if (!supportsCondition) {
                    catalogQuery.setLength(0);
                    catalogQuery.append("SELECT SCHEMA_NAME FROM ").append("information_schema.SCHEMATA");
                }
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)(supportsCondition ? "`Database`" : "SCHEMA_NAME"), (boolean)true, (DBPDataSource)owner);
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }

        protected MySQLCatalog fetchObject(@NotNull JDBCSession session, @NotNull MySQLDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return MySQLDataSource.this.createCatalogInstance(owner, resultSet);
        }
    }
}

