/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class MySQLProcedureManager
extends SQLObjectEditor<MySQLProcedure, MySQLCatalog> {
    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLProcedure> getObjectsCache(MySQLProcedure object) {
        return ((MySQLCatalog)object.getContainer()).getProceduresCache();
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((MySQLProcedure)command.getObject()).getName())) {
            throw new DBException("Procedure name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((MySQLProcedure)command.getObject()).getDeclaration())) {
            throw new DBException("Procedure body cannot be empty");
        }
    }

    protected MySQLProcedure createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new MySQLProcedure((MySQLCatalog)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (MySQLProcedure)command.getObject());
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actionList, (MySQLProcedure)command.getObject());
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop procedure", "DROP " + String.valueOf(((MySQLProcedure)command.getObject()).getProcedureType()) + " " + ((MySQLProcedure)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actions, MySQLProcedure procedure) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop procedure", "DROP " + String.valueOf(procedure.getProcedureType()) + " IF EXISTS " + procedure.getFullyQualifiedName(DBPEvaluationContext.DDL)));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create procedure", procedure.getDeclaration(), true));
    }
}

