/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.dameng.model.DamengSchema;
import org.jkiss.dbeaver.ext.dameng.model.DamengSequence;
import org.jkiss.dbeaver.ext.generic.edit.GenericSequenceManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DamengSequenceManager
extends GenericSequenceManager {
    public boolean canCreateObject(Object container) {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor");
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected DamengSequence createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        GenericStructContainer structContainer = (GenericStructContainer)container;
        DamengSchema schema = (DamengSchema)structContainer.getSchema();
        DamengSequence sequence = new DamengSequence((GenericStructContainer)container, this.getBaseObjectName());
        this.setNewObjectName(monitor, (DBSObject)schema, (DBSObject)sequence);
        return sequence;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        DamengSequence sequence = (DamengSequence)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create sequence", sequence.buildStatement(false)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        DamengSequence sequence = (DamengSequence)command.getObject();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Sequence", sequence.buildStatement(true)));
    }
}

