/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ucp.proxy.AnnotationsRegistry;
import oracle.ucp.proxy.ClassGenerator;
import oracle.ucp.proxy.ExtractDelegatePermission;
import oracle.ucp.proxy.GeneratedProxiesRegistry;
import oracle.ucp.proxy.NullProxy;
import oracle.ucp.proxy.WeakIdentityHashMap;
import oracle.ucp.proxy._Proxy_;

public class ProxyFactory {
    public static final String DEFAULT_PROXY_PACKAGE = "oracle.ucp.proxy";
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private static final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private final Map<Class<?>, Constructor<?>> delegateClassToProxyConstructor = new ConcurrentHashMap();
    private final Map<Object, WeakReference<?>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<Class<?>, Class<?>> delegateToMostSuitableIface = new ConcurrentHashMap();
    private static final Object STALE_DELEGATE = new Object();
    private static final Class<EMPTY_CLASS> EMPTY_VALUE = EMPTY_CLASS.class;
    private ClassLoader classLoader = null;
    private final String proxyPackage;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();

    private ProxyFactory(String proxyPackage) {
        this.proxyPackage = proxyPackage;
    }

    public static ProxyFactory createProxyFactory(String proxyPackage, Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(proxyPackage);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createProxyFactory(Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(String proxyPackage, Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(proxyPackage);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class<?> ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public final boolean isProxied(Class<?> iface) {
        return this.annotationsRegistry.containsKey(iface);
    }

    public final <T> T proxyFor(T delegate) {
        return this.proxyFor(delegate, this);
    }

    public final <T> T proxyFor(T delegate, Object creator) {
        return this.proxyForCache(delegate, creator, null, null);
    }

    public final <T> T proxyForType(Class<?> delegateClass) {
        return this.proxyForType(delegateClass, this);
    }

    public final <T> T proxyForType(Class<?> delegateClass, Object creator) {
        if (Objects.isNull(delegateClass)) {
            return null;
        }
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (Objects.isNull(mostSuitableIface)) {
            return null;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (Objects.isNull(value)) {
            return null;
        }
        WeakIdentityHashMap<Object, WeakReference<?>> proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        try {
            Constructor<?> proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
            if (null == proxyConstructor) {
                return this.createProxy(mostSuitableIface, null, creator, proxyCache);
            }
            Object t = proxyConstructor.newInstance(null, creator, this, proxyCache);
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCreate(T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache, Method methodObject) {
        Constructor<?> proxyConstructor;
        if (null == delegate) {
            return null;
        }
        Class<?> delegateClass = delegate.getClass();
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            Map<Object, Object> map = proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass))) {
            return this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
        }
        try {
            Object t = proxyConstructor.newInstance(delegate, creator, this, proxyCache);
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCache(T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        if (delegate instanceof _Proxy_) {
            return delegate;
        }
        Class<?> delegateClass = delegate.getClass();
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        Method getter = value.getProxyAccessGetter();
        Method setter = value.getProxyAccessSetter();
        if (null == proxyCache) {
            proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        try {
            Constructor<?> proxyConstructor;
            Object proxy;
            if (null != getter) {
                Object proxy2 = getter.invoke(delegate, new Object[0]);
                if (null != proxy2) {
                    return (T)proxy2;
                }
            } else {
                WeakReference<?> proxyRef = proxyCache.get(delegate);
                if (null != proxyRef && null != (proxy = proxyRef.get())) {
                    if (STALE_DELEGATE == proxy) {
                        throw new RuntimeException("stale delegate");
                    }
                    return proxy;
                }
            }
            if (null == (proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass))) {
                proxy = this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
                if (null != setter) {
                    setter.invoke(delegate, proxy);
                } else {
                    proxyCache.put(delegate, new WeakReference(proxy));
                }
                return proxy;
            }
            proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache);
            if (null != setter) {
                setter.invoke(delegate, proxy);
            } else {
                proxyCache.put(delegate, new WeakReference(proxy));
            }
            return proxy;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCreateCache(T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        if (delegate instanceof _Proxy_) {
            return delegate;
        }
        Class<?> delegateClass = delegate.getClass();
        Class<?> mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        Method setter = value.getProxyAccessSetter();
        Constructor<?> proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
        try {
            if (null == proxyConstructor) {
                T proxy = this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
                if (null != setter) {
                    setter.invoke(delegate, proxy);
                } else {
                    proxyCache.put(delegate, new WeakReference<T>(proxy));
                }
                return proxy;
            }
            Object proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache);
            if (null != setter) {
                setter.invoke(delegate, proxy);
            } else {
                proxyCache.put(delegate, new WeakReference(proxy));
            }
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void updateDelegate(Object proxy, T oldDelegate, T newDelegate) {
        this.delegateToProxy.put(oldDelegate, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(newDelegate, new WeakReference<Object>(proxy));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static final <T> T extractDelegate(_Proxy_<T> proxy) {
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        return proxy._getDelegate_();
    }

    private <T> T createProxy(Class<?> mostSuitableIface, T delegate, Object creator, Map<Object, WeakReference<?>> proxyCache) {
        if (null == mostSuitableIface) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        Class<?> superclass = value.getSuperclass();
        Constructor<?> c = this.prepareProxy(this.proxyPackage, mostSuitableIface, superclass);
        try {
            Object t = c.newInstance(delegate, creator, this, proxyCache);
            return (T)t;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Constructor<?> prepareProxy(String proxyPackage, Class<?> iface, Class<?> superclass) {
        Constructor<?> constructor;
        block14: {
            GeneratedProxiesRegistry.Value v = generatedRegistry.get(proxyPackage, iface, superclass);
            if (null != v) {
                return v.getConstructor();
            }
            Class<?> clazz = null;
            clazz = Class.forName(new GeneratedProxiesRegistry.Key(proxyPackage, iface, superclass).toString(), true, null == this.classLoader ? superclass.getClassLoader() : this.classLoader);
            if (Objects.isNull(clazz)) {
                throw new IllegalStateException("cannot resolve or generate proxy");
            }
            try {
                constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            generatedRegistry.put(proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
            break block14;
            catch (ClassNotFoundException e) {
                try {
                    clazz = ClassGenerator.generate(proxyPackage, iface, superclass, this.annotationsRegistry, this.classLoader);
                }
                catch (Throwable throwable) {
                    if (Objects.isNull(clazz)) {
                        throw new IllegalStateException("cannot resolve or generate proxy");
                    }
                    try {
                        constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new RuntimeException(e2);
                    }
                    generatedRegistry.put(proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
                    throw throwable;
                }
                if (Objects.isNull(clazz)) {
                    throw new IllegalStateException("cannot resolve or generate proxy");
                }
                try {
                    constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class);
                }
                catch (NoSuchMethodException e3) {
                    throw new RuntimeException(e3);
                }
                generatedRegistry.put(proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
            }
        }
        return constructor;
    }

    private Constructor<?> getProxyConstructor(Class<?> mostSuitableIface, Class<?> delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Constructor<?> proxyConstructor = this.delegateClassToProxyConstructor.get(delegateClass);
        if (null != proxyConstructor) {
            return proxyConstructor;
        }
        if (null == mostSuitableIface) {
            return null;
        }
        GeneratedProxiesRegistry.Value value = generatedRegistry.get(this.proxyPackage, mostSuitableIface, this.annotationsRegistry.get(mostSuitableIface).getSuperclass());
        if (null == value) {
            return null;
        }
        Constructor<?> proxyConstructor2 = value.getConstructor();
        if (null != proxyConstructor2) {
            this.delegateClassToProxyConstructor.put(delegateClass, proxyConstructor2);
        }
        return proxyConstructor2;
    }

    private Class<?> findMostSuitableIface(Class<?> delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Class<?> c = this.delegateToMostSuitableIface.get(delegateClass);
        if (null != c) {
            return EMPTY_VALUE != c ? c : null;
        }
        int max = -1;
        Class<EMPTY_CLASS> iface = null;
        for (Class<?> i : this.annotationsRegistry.keySet()) {
            int c2 = this.intersectionCardinality(delegateClass, i);
            if (c2 < 1 || c2 <= max) continue;
            max = c2;
            iface = i;
        }
        this.delegateToMostSuitableIface.put(delegateClass, null != iface ? iface : EMPTY_VALUE);
        return iface;
    }

    private int intersectionCardinality(Class<?> delegateClass, Class<?> iface) {
        HashSet iSet = new HashSet();
        this.collectIfaces(iface, iSet);
        HashSet dSet = new HashSet();
        this.collectIfaces(delegateClass, dSet);
        int iCard = iSet.size();
        iSet.removeAll(dSet);
        if (iSet.size() > 0) {
            return -1;
        }
        return iCard;
    }

    private void collectIfaces(Class<?> c, Set<Class<?>> set) {
        if (c.isInterface()) {
            set.add(c);
        }
        for (Class<?> iface : c.getInterfaces()) {
            this.collectIfaces(iface, set);
        }
        Class<?> superclass = c.getSuperclass();
        if (null != superclass) {
            this.collectIfaces(superclass, set);
        }
    }

    private static final class EMPTY_CLASS {
        private EMPTY_CLASS() {
        }
    }
}

