/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.sql.XAConnection;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

abstract class ConnectionProxyBase
implements LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
XAConnection,
LogicalObject,
Poolable,
ClientDataSupport,
Diagnosable {
    static final String CLASS_NAME = ConnectionProxyBase.class.getName();
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean actuallyReturned = false;
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;

    ConnectionProxyBase() {
    }

    UniversalPooledConnection getUPC() {
        Object c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = this.getCreator())) {
            this.proxiedPooledConnection = c instanceof Creator ? ((Creator)c).getUPC() : ((ConnectionProxyBase)c).getUPC();
            upc = this.proxiedPooledConnection;
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        Object c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = this.getCreator())) {
            this.proxiedPool = c instanceof Creator ? ((Creator)c).getUCP() : ((ConnectionProxyBase)c).getUCP();
            ucp = this.proxiedPool;
        }
        return ucp;
    }

    protected abstract Connection getDelegate();

    protected abstract Object getCreator();

    @Debug(level=Debug.Level.FINEST)
    private void handleExceptionHelper() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleExceptionHelper", "entering args ()", null, null, new Object[0]);
            if (!this.actuallyReturned) {
                try {
                    try {
                        this.trace(Level.FINEST, CLASS_NAME, "handleExceptionHelper", "about to close statements", null, null, new Object[0]);
                        for (StatementProxy stmt : this.statementsToClose.toList()) {
                            stmt.close();
                        }
                    }
                    catch (Throwable t) {
                        this.trace(Level.WARNING, CLASS_NAME, "handleExceptionHelper", "", null, t, new Object[0]);
                    }
                    this.statementsToClose.clear();
                    this.trace(Level.FINEST, CLASS_NAME, "handleExceptionHelper", "about to set STATUS_BAD", null, null, new Object[0]);
                    UniversalPooledConnection upc = this.getUPC();
                    assert (null != upc) : "upc shold be defined at this point";
                    try {
                        upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    }
                    catch (Throwable t) {
                        this.trace(Level.WARNING, CLASS_NAME, "handleExceptionHelper", "", null, t, new Object[0]);
                    }
                    this.trace(Level.FINEST, CLASS_NAME, "handleExceptionHelper", "about to return bad connection back to a pool", null, null, new Object[0]);
                    UniversalConnectionPool ucp = this.getUCP();
                    assert (null != ucp) : "ucp shold be defined at this point";
                    ucp.returnConnection(upc);
                    this.actuallyReturned = true;
                    this.closed.set(true);
                }
                catch (UniversalConnectionPoolException ucpe) {
                    this.trace(Level.WARNING, CLASS_NAME, "handleExceptionHelper", "", null, ucpe, new Object[0]);
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleExceptionHelper", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleExceptionHelper", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected void handleSQLRecoverableException(SQLException sQLException) throws SQLException {
        try {
            void e;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleSQLRecoverableException", "entering args ({0})", null, null, new Object[]{sQLException});
            this.trace(Level.FINEST, CLASS_NAME, "handleSQLRecoverableException", "about to handle SQLException", null, null, new Object[0]);
            this.trace(Level.WARNING, CLASS_NAME, "handleSQLRecoverableException", "", null, (Throwable)e, new Object[0]);
            if (e instanceof SQLRecoverableException) {
                this.handleExceptionHelper();
            }
            this.trace(Level.FINEST, CLASS_NAME, "handleSQLRecoverableException", "done handling SQLException", null, null, new Object[0]);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleSQLRecoverableException", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleSQLRecoverableException", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected void handleRuntimeException(RuntimeException runtimeException) throws RuntimeException {
        try {
            void e;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleRuntimeException", "entering args ({0})", null, null, new Object[]{runtimeException});
            this.trace(Level.WARNING, CLASS_NAME, "handleRuntimeException", "driver threw RuntimeException: {0}", null, null, new Object[]{e.getMessage()});
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleRuntimeException", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase", "handleRuntimeException", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        upc.heartbeat();
        try {
            if (!this.statementsToClose.isEmpty()) {
                try {
                    for (StatementProxy stmt : this.statementsToClose.toList()) {
                        stmt.close();
                    }
                }
                catch (Throwable t) {
                    this.trace(Level.WARNING, CLASS_NAME, "close", "", null, t, new Object[0]);
                }
                this.statementsToClose.clear();
            }
            if (WLSJTAPlugin.jtaWLSEnabled && this.getDelegate() instanceof LogicalConnection) {
                this.getDelegate().close();
                return;
            }
            UniversalConnectionPool ucp = this.getUCP();
            assert (null != ucp) : "ucp shold be defined at this point";
            ucp.returnConnection(upc);
            this.actuallyReturned = true;
        }
        catch (UniversalConnectionPoolException e) {
            Throwable cause = e.getCause();
            if (null == cause) {
                throw new SQLException(e);
            }
            Throwable cause2 = cause.getCause();
            if (null == cause2 || !(cause2 instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)cause2;
        }
    }

    public void close(int code) throws SQLException {
        ConnectionRetrievalInfo cri;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(code);
        if (1 == code && (cri = upc.getConnectionRetrievalInfo()) instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
        }
        upc.heartbeat();
    }

    public void close(Properties props) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(props);
        upc.heartbeat();
    }

    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, OracleShardingKey superShardingKey, int timeout) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        if (this.closed.get()) {
            return false;
        }
        upc.heartbeat();
        boolean ret = ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
        upc.heartbeat();
        return ret;
    }

    public boolean isUsable() {
        UniversalPooledConnection upc = this.getUPC();
        if (this.closed.get()) {
            return false;
        }
        upc.heartbeat();
        boolean ret = ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isUsable();
        upc.heartbeat();
        return ret;
    }

    public boolean isValid(int timeout) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        if (this.closed.get()) {
            return false;
        }
        upc.heartbeat();
        boolean ret = this.getDelegate().isValid(timeout);
        upc.heartbeat();
        return ret;
    }

    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        if (this.closed.get()) {
            return false;
        }
        upc.heartbeat();
        boolean ret = ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isValid(effort, timeout);
        upc.heartbeat();
        return ret;
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        try {
            upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e) {
            throw new SQLException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        boolean alreadyClosedOnDriver = this.getDelegate().isClosed();
        if (alreadyClosedOnDriver) {
            this.trace(Level.FINE, CLASS_NAME, "isClosed", "this connection was closed/killed/aborted on the driver, lets invalidate it and return", null, null, new Object[0]);
            UniversalPooledConnection upc = this.getUPC();
            assert (null != upc) : "upc shold be defined at this point";
            try {
                upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.trace(Level.FINE, CLASS_NAME, "isClosed", "invalidated", null, null, new Object[0]);
            }
            catch (Throwable t) {
                this.trace(Level.WARNING, CLASS_NAME, "isClosed", "", null, t, new Object[0]);
            }
            this.trace(Level.FINEST, CLASS_NAME, "isClosed", "about to return bad connection back to a pool", null, null, new Object[0]);
            UniversalConnectionPool ucp = this.getUCP();
            assert (null != ucp) : "ucp shold be defined at this point";
            try {
                ucp.returnConnection(upc);
                this.trace(Level.FINE, CLASS_NAME, "isClosed", "returned back to a pool", null, null, new Object[0]);
            }
            catch (UniversalConnectionPoolException ucpe) {
                this.trace(Level.WARNING, CLASS_NAME, "isClosed", "", null, ucpe, new Object[0]);
            }
            this.actuallyReturned = true;
            this.closed.set(true);
        }
        return alreadyClosedOnDriver;
    }

    @Override
    public UniversalPooledConnection getPooledObject() {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc;
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        Properties props = null;
        try {
            props = upc.getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            props = upc.getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ConnectionProxyBase ? ((ConnectionProxyBase)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public Object getClientData(Object obj) {
        return ((OracleConnection)this.getDelegate()).getClientData(obj);
    }

    public Object setClientData(Object obj1, Object obj2) {
        return ((OracleConnection)this.getDelegate()).setClientData(obj1, obj2);
    }

    public Object removeClientData(Object obj) {
        return ((OracleConnection)this.getDelegate()).removeClientData(obj);
    }

    protected void saveStatementProxy(Object result) {
        if (result instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)result;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }

    @Override
    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        try {
            Connection delegate = this.getDelegate();
            if (delegate instanceof XAConnection) {
                WLSJTAPlugin.enlistXAResource((XAConnection)((Object)delegate));
                Connection connection = ((XAConnection)((Object)this.getDelegate())).getConnection();
                return connection;
            }
            throw new IllegalStateException("this is not an XAConnection");
        }
        finally {
            upc.heartbeat();
        }
    }

    protected void setDefaultQueryTimeout(Statement statement) {
        UniversalConnectionPool ucp = this.getUCP();
        assert (null != ucp) : "ucp shold be defined at this point";
        int queryTimeout = ((UniversalConnectionPoolBase)ucp).getQueryTimeout();
        if (queryTimeout > 0) {
            try {
                statement.setQueryTimeout(queryTimeout);
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "setDefaultQueryTimeout", "", null, e, new Object[0]);
            }
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        UniversalConnectionPool ucp = this.getUCP();
        assert (Objects.nonNull(ucp));
        return ucp.getDiagnosable();
    }
}

