/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class ReplayDataSourceConnectionFactoryAdapter
extends OracleDataSourceConnectionFactoryAdapter {
    static final String CLASS_NAME = ReplayDataSourceConnectionFactoryAdapter.class.getName();

    public ReplayDataSourceConnectionFactoryAdapter(DataSource dataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(dataSource, diagnosticsCollector);
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void initializeUrlFromConnectionFactory() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "entering args ()", null, null, new Object[0]);
            Class<?> dsClass = this.m_dataSource.getClass();
            Class<?> cls = null;
            try {
                cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
                Method m = cls.getMethod("getURL", new Class[0]);
                this.m_url = (String)m.invoke((Object)this.m_dataSource, new Object[0]);
                this.trace(Level.FINEST, CLASS_NAME, "initializeUrlFromConnectionFactory", "initializeUrlFromConnectionFactory() succeeded", null, null, new Object[0]);
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "initializeUrlFromConnectionFactory", "", null, exc, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setUrl(String string) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "setUrl", "entering args ({0})", null, null, string);
            Class<?> dsClass = this.m_dataSource.getClass();
            Class<?> cls = null;
            try {
                void url;
                cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
                Method m = cls.getMethod("setURL", String.class);
                m.invoke((Object)this.m_dataSource, url);
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "setUrl", "", null, exc, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "setUrl", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "setUrl", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "createConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            OracleDataSource ods = null;
            Connection connection = null;
            try {
                void connectionRequestInfo;
                if (!(this.m_dataSource instanceof OracleDataSource)) {
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection without specifying instance", null, null, new Object[0]);
                    connection = (Connection)super.createConnection((ConnectionRetrievalInfo)connectionRequestInfo);
                } else {
                    String instanceName;
                    ods = (OracleDataSource)this.m_dataSource;
                    JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
                    if (connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo) {
                        instanceName = ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName();
                        this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection to the instance  {0}", null, null, instanceName);
                    } else {
                        instanceName = null;
                    }
                    OracleConnectionBuilderImpl builder = ods.createConnectionBuilder();
                    connection = ((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)builder.user(jdbcCri.getUser())).password(jdbcCri.getPassword().toJDBCOpaqueString())).instanceName(instanceName)).serviceName(jdbcCri.getServiceName())).shardingKey(jdbcCri.getShardingKey())).superShardingKey(jdbcCri.getSuperShardingKey())).sslContext(jdbcCri.getSSLContext())).hostnameResolver(jdbcCri.getHostnameResolver() == null ? null : host -> jdbcCri.getHostnameResolver().getAllByName(host))).readOnlyInstanceAllowed(jdbcCri.isReadOnlyInstanceAllowed())).build();
                    if (connection instanceof OracleConnection) {
                        Properties proxyProps;
                        String in = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                        assert (null != in);
                        assert (instanceName == null || Util.equalsNormalized(in, instanceName)) : "internal error: got connection from the wrong instance";
                        if (instanceName != null && !"".equals(instanceName) && !Util.equalsNormalized(in, instanceName)) {
                            this.trace(Level.FINEST, CLASS_NAME, "createConnection", "wrong conn opened, desired: {0}, actual: {1}", null, null, instanceName, in);
                        }
                        if ((proxyProps = jdbcCri.getProxyProperties()) != null) {
                            int proxyType = jdbcCri.getProxyType();
                            this.trace(Level.FINEST, CLASS_NAME, "createConnection", "Opening proxy session with Properties = {0}", null, null, proxyProps);
                            ((OracleConnection)connection).openProxySession(proxyType, proxyProps);
                        }
                    } else {
                        this.trace(Level.FINEST, CLASS_NAME, "createConnection", "not an oracle connection", null, null, new Object[0]);
                    }
                }
                if (null != connection) {
                    this.onSuccessfulConnectionCreation(connection);
                }
            }
            catch (SQLException e) {
                this.onFailedConnectionCreation(e);
                this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
            }
            Connection connection2 = connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "createConnection", "returning {0}", null, null, connection2);
            return connection2;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter", "createConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

