/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import oracle.ucp.ConnectionCreationInformation;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

public abstract class JDBCConnectionPool
extends UniversalConnectionPoolImpl {
    private String m_SQLForValidateConnection = null;
    private int m_maxStatements = 0;
    private AtomicReference<Object> connectionfactory = new AtomicReference<Object>(null);
    private volatile ConnectionInitializationCallback connectionInitializationCallback = null;
    private volatile Consumer<ConnectionCreationInformation> connectionCreationConsumer = null;

    public JDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
    }

    public JDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    public void setSQLForValidateConnection(String SQLString) throws SQLException {
        JDBCUniversalPooledConnection conn;
        if (SQLString != null && SQLString.equals("")) {
            throw UCPErrorHandler.newSQLException(22);
        }
        if (this.isLifecycleRunning() && null != SQLString && null != (conn = (JDBCUniversalPooledConnection)this.createOnePooledConnection())) {
            Statement stmt = null;
            try {
                stmt = conn.getSQLConnection(conn.getPhysicalConnection()).createStatement();
                stmt.execute(SQLString);
            }
            catch (SQLRecoverableException sQLRecoverableException) {
            }
            catch (SQLException e) {
                this.setValidateConnectionOnBorrow(false);
                throw e;
            }
            finally {
                if (null != stmt) {
                    stmt.close();
                }
                this.closePhysicalConnection(conn.getPhysicalConnection());
            }
        }
        this.m_SQLForValidateConnection = SQLString;
    }

    public String getSQLForValidateConnection() {
        return this.m_SQLForValidateConnection;
    }

    public void setMaxStatements(int maxStatements) throws SQLException {
        if (maxStatements < 0) {
            throw UCPErrorHandler.newSQLException(22);
        }
        this.m_maxStatements = maxStatements;
    }

    public int getMaxStatements() {
        return this.m_maxStatements;
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        this.validateConnectionRetrievalInfo(connectionRetrievalInfo);
        JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)super.borrowConnection(connectionRetrievalInfo);
        try {
            if (jdbcPooledConnection != null) {
                jdbcPooledConnection.setMaxStatements(this.getMaxStatements());
            }
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e);
        }
        return jdbcPooledConnection;
    }

    public void registerConnectionInitializationCallback(ConnectionInitializationCallback cbk) throws UniversalConnectionPoolException {
        if (null != this.connectionInitializationCallback) {
            UCPErrorHandler.throwUniversalConnectionPoolException(270);
        }
        this.connectionInitializationCallback = cbk;
    }

    public void unregisterConnectionInitializationCallback() {
        this.connectionInitializationCallback = null;
    }

    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        return this.connectionInitializationCallback;
    }

    public void registerConnectionCreationConsumer(Consumer<ConnectionCreationInformation> consumer) {
        Objects.requireNonNull(consumer);
        this.connectionCreationConsumer = consumer;
    }

    public void unregisterConnectionCreationConsumer() {
        this.connectionCreationConsumer = null;
    }

    public Consumer<ConnectionCreationInformation> getConnectionCreationConsumer() {
        return this.connectionCreationConsumer;
    }

    @Override
    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection upc) {
        JDBCUniversalPooledConnection jupc = (JDBCUniversalPooledConnection)upc;
        return this.getProxyFactory().proxyForConnection(this, jupc);
    }

    protected void setConnectionFactory(Object connectionFactory) {
        if (this.isLifecycleRunning()) {
            throw new IllegalStateException("Cannot set factory class when the pool is started");
        }
        this.connectionfactory.compareAndSet(null, connectionFactory);
    }

    Object getConnectionFactory() {
        return this.connectionfactory.get();
    }

    private void validateConnectionRetrievalInfo(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            if (this.core.connectionSource().isShardedDatabase()) {
                if (jdbcCri.getShardingKey() == null) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(277);
                }
            } else if (!(this.core.connectionSource().isRacDataAffinityEnabled() || jdbcCri.getShardingKey() == null && jdbcCri.getSuperShardingKey() == null)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(278);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
    }

    protected abstract ConnectionProxyFactory getProxyFactory();
}

