/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public class WLSJTAPlugin {
    static final String CLASS_NAME = WLSJTAPlugin.class.getName();
    public static final boolean jtaWLSEnabled = Util.isJTASupportForWLSEnabled();
    static final boolean DEBUG = false;
    static final Map<Xid, ServiceMember> xaAffinityMap = new ConcurrentHashMap<Xid, ServiceMember>();

    public static void registerXAResource(XAResource xar, String dsName) {
        if (jtaWLSEnabled) {
            try {
                Properties registrationProperties = new Properties();
                registrationProperties.put("weblogic.transaction.registration.type", "dynamic");
                registrationProperties.put("weblogic.transaction.resource.type", "datasource");
                String xarName = dsName + "@" + xar.toString();
                ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerResource(xarName, xar, (Hashtable)registrationProperties);
                WLSJTAPlugin.debug("##### PoolXADS.getXAConn(): successfully registered XAResource: " + xar);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "registerXAResource", "Successfully registered XAResource:  {0}", null, null, xar);
            }
            catch (Exception exc) {
                WLSJTAPlugin.debug("##### PoolXADS.getXAConn(): failed to register XAResource: ", exc);
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "registerXAResource", "", null, exc, new Object[0]);
            }
        }
    }

    public static ServiceMember getXAInstance() {
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            WLSJTAPlugin.debug("##### getXAInstance(): got XA-transaction from WLS: " + tx);
            if (tx != null) {
                ServiceMember inst = xaAffinityMap.get(tx.getXid());
                WLSJTAPlugin.debug("##### getXAInstance(): got instance from XA-affinity-map: " + inst);
                return inst;
            }
        }
        return null;
    }

    static final Predicate<CoreConnection> xaAffSelector() {
        if (jtaWLSEnabled) {
            ServiceMember xaInstance = WLSJTAPlugin.getXAInstance();
            return conn -> xaInstance == null || xaInstance.equals(conn.serviceMember());
        }
        return p -> true;
    }

    public static void enlistXAResource(XAConnection xaconn) throws SQLException {
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            WLSJTAPlugin.debug("##### ConnProxyBase.getConn(): successfully got Transaction object from WLS");
            if (tx != null) {
                XAResource xar = xaconn.getXAResource();
                WLSJTAPlugin.enlist(tx, xar);
            }
        }
    }

    public static void enlistXAResource(XAResource xar) throws SQLException {
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            WLSJTAPlugin.debug("##### ConnProxyBase.getConn(): successfully got Transaction object from WLS");
            if (tx != null) {
                WLSJTAPlugin.enlist(tx, xar);
            }
        }
    }

    private static void enlist(Transaction tx, XAResource xar) throws SQLException {
        SQLException se = null;
        try {
            Map nullEnlistProps = null;
            tx.enlistResourceWithProperties(xar, nullEnlistProps);
            WLSJTAPlugin.debug("##### ConnProxyBase.getConn(): successfully enlisted XAResource with WLS: " + xar);
        }
        catch (Exception ex) {
            WLSJTAPlugin.debug("##### ConnProxyBase.getConn(): failed to enlist XAResource with WLS: ", ex);
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "enlist", "", null, ex, new Object[0]);
            se = new SQLException("Unexpected exception: " + ex.getMessage());
        }
        if (se != null) {
            throw se;
        }
    }

    public static void checkXAAffinity(ServiceMember connInstance) throws UniversalConnectionPoolException {
        Transaction tx;
        if (jtaWLSEnabled && (tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction()) != null) {
            Xid xid = tx.getXid();
            ServiceMember affInst = xaAffinityMap.get(xid);
            if (affInst == null) {
                xaAffinityMap.put(xid, connInstance);
            } else if (affInst.equals(connInstance)) {
                WLSJTAPlugin.debug("##### checkXAAffinity: followed XA affinity to instance on WLS: " + connInstance);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "followed XA affinity to instance on WLS: {0}", null, null, connInstance);
            } else {
                WLSJTAPlugin.debug("##### checkXAAffinity: violated XA affinity to instance on WLS, affinity instance: " + affInst + "actual instance: " + connInstance);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "violated XA affinity to instance on WLS, affinity instance: {0}, actual instance: {1}", null, null, affInst, connInstance);
                try {
                    tx.rollback();
                    WLSJTAPlugin.debug("##### checkXAAffinity: rolled back XA transaction on WLS, xid = " + xid);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "rolled back XA transaction on WLS, xid = {0}", null, null, xid);
                }
                catch (Exception exc) {
                    WLSJTAPlugin.debug("##### checkXAAffinity: rolling back XA transaction on WLS, xid = " + xid + ", got exception: ", exc);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "rolling back XA transaction on WLS got exception: {0}, xid={1]", null, null, exc, xid);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "checkXAAffinity", "", null, exc, new Object[0]);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(420);
            }
        }
    }

    public static void debug(String mesg) {
    }

    public static void debug(String mesg, Throwable exc) {
    }
}

