/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.ShardConnectionStatistics;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AbandonedConnectionTimerTask;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionHarvestingTimerTask;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.Core;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CounterImpl;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.Failoverable;
import oracle.ucp.common.Limits;
import oracle.ucp.common.PeakLongCounter;
import oracle.ucp.common.TimeToLiveConnectionTimerTask;
import oracle.ucp.common.Topology;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.tuners.ConnectionGrower;
import oracle.ucp.tuners.ConnectionReducer;
import oracle.ucp.tuners.PoolSizeTuner;
import oracle.ucp.tuners.Tunable;
import oracle.ucp.tuners.stats.CounterMap;
import oracle.ucp.tuners.stats.HistogramRingRegistry;
import oracle.ucp.tuners.stats.RingRegistry;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.UniqueIdentifier;

public abstract class UniversalConnectionPoolBase
implements UniversalConnectionPool,
Failoverable {
    static final String CLASS_NAME = UniversalConnectionPoolBase.class.getName();
    static final int DEFAULT_INITIAL_POOL_SIZE = 0;
    public static final int DEFAULT_MIN_POOL_SIZE = 1;
    public static final int DEFAULT_MAX_POOL_SIZE = 8;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_SERVICE = Integer.MAX_VALUE;
    static final int DEFAULT_INACTIVE_CONNECTION_TIMEOUT = 0;
    private static final int DEFAULT_TIMEOUT_CHECK_INTERVAL = 30;
    static final int DEFAULT_ABANDONED_CONNECTION_TIMEOUT = 0;
    static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 3;
    static final int DEFAULT_TIME_TO_LIVE_CONNECTION_TIMEOUT = 0;
    public static final boolean DEFAULT_VALIDATE_BORROWED_CONNECTION = true;
    public static final int DEFAULT_SECONDS_TO_TRUST_IDLE_CONNECTION = 120;
    private static final int DEFAULT_CONNECTION_HARVEST_TRIGGER_COUNT = Integer.MAX_VALUE;
    private static final int DEFAULT_CONNECTION_HARVEST_MAX_COUNT = 1;
    private static final int DEFAULT_QUERY_TIMEOUT = 0;
    private static final int DEFAULT_QUERY_TIMEOUT_IF_ABANDONEMENT_RUNS = 60;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_SHARD = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTION_VALIDATION_TIMEOUT = 15;
    private static final String DEFAULT_POOLNAME_PREFIX = "UniversalConnectionPool(" + UniversalConnectionPoolBase.class.hashCode() + ")-";
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private volatile int initialPoolSize = 0;
    private volatile int minPoolSize = 1;
    private volatile int maxPoolSize = 8;
    private volatile boolean maxPoolSizeWasExplicitlySet = false;
    private final AtomicInteger maxConnectionsPerService = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger m_inactiveConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger m_timeoutCheckInterval = new AtomicInteger(30);
    private final AtomicInteger m_abandonedConnectionTimeout = new AtomicInteger(0);
    private volatile int connectionWaitTimeout = 3;
    final AtomicInteger m_numConnectionsCreated = new AtomicInteger(0);
    private final AtomicInteger m_numConnectionsClosed = new AtomicInteger(0);
    private final AtomicInteger m_timeToLiveConnectionTimeout = new AtomicInteger(0);
    private volatile boolean validateConnectionOnBorrow = true;
    private final AtomicInteger m_connectionHarvestTriggerCount = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicLong m_maxConnectionReuseTime = new AtomicLong(0L);
    private final AtomicInteger m_maxConnectionReuseCount = new AtomicInteger(0);
    private final AtomicInteger m_connectionHarvestMaxCount = new AtomicInteger(1);
    private final AtomicInteger connectionValidationTimeout = new AtomicInteger(15);
    private final AtomicBoolean readOnlyInstanceAllowed = new AtomicBoolean(false);
    private final ConnectionFactoryAdapter m_connectionFactoryAdapter;
    private volatile ConnectionRetrievalInfo defaultConnectionRetrievalInfo = null;
    private final AtomicReference<ConnectionLabelingCallback> m_connectionLabelingCallback = new AtomicReference<Object>(null);
    private volatile ConnectionAffinityCallback connectionAffinityCallback = null;
    private final AtomicReference<TimerHandle> m_abandonedConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_inactiveConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_timeToLiveConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_connectionHarvestTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> replaceBadConnectionsTimer = new AtomicReference();
    private final AtomicBoolean m_failoverEnabled = new AtomicBoolean(false);
    private final AtomicBoolean failoverExplicitlySet = new AtomicBoolean(false);
    private AtomicReference<String> m_poolName = new AtomicReference<String>(new UniqueIdentifier(DEFAULT_POOLNAME_PREFIX).toString());
    private final AtomicInteger m_abandonedConnectionsCount = new AtomicInteger(0);
    protected volatile long cumulativeReturnedConnectionsCount = 0L;
    protected volatile long cumulativeBorrowedConnectionsCount = 0L;
    protected final LongAdder cumulativeSuccessfulConnectionWaitCount = new LongAdder();
    protected final LongAdder cumulativeFailedConnectionWaitCount = new LongAdder();
    AtomicInteger m_cumulativeConnectionsCreated = new AtomicInteger();
    protected final LongAdder cumulativeSuccessfulConnectionWaitTime = new LongAdder();
    protected final LongAdder cumulativeFailedConnectionWaitTime = new LongAdder();
    PeakLongCounter m_peakConnectionWaitTime = new PeakLongCounter();
    final AtomicInteger m_pendingRequestsCount = new AtomicInteger(0);
    final AtomicLong m_cumulativeConnectionUseTime = new AtomicLong(0L);
    final AtomicLong borrowedAccumulator = new AtomicLong(0L);
    final AtomicLong borrowedSamples = new AtomicLong(0L);
    private AtomicReference<TimerHandle> m_replaceNonReusableConnectionsTimer = new AtomicReference<Object>(null);
    private static final AtomicInteger m_poolsRunning = new AtomicInteger(0);
    private AtomicInteger connectionLabelingHighCost = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger highCostConnectionReuseThreshold = new AtomicInteger(0);
    private volatile int secondsToTrustIdleConnection = 120;
    private final AtomicInteger connectionRepurposeThreshold = new AtomicInteger(0);
    private final AtomicInteger maxConnectionsPerShard = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicBoolean shareable = new AtomicBoolean(false);
    private final AtomicBoolean shardingMode = new AtomicBoolean(true);
    private Limits limits = new Limits(){

        @Override
        public int getMin() {
            return UniversalConnectionPoolBase.this.minPoolSize;
        }

        @Override
        public int getInitial() {
            return UniversalConnectionPoolBase.this.initialPoolSize;
        }

        @Override
        public int getMax() {
            return UniversalConnectionPoolBase.this.maxPoolSize;
        }

        @Override
        public int getRepurposeThreshold() {
            return UniversalConnectionPoolBase.this.connectionRepurposeThreshold.get();
        }

        @Override
        public int getMaxPerService() {
            return UniversalConnectionPoolBase.this.maxConnectionsPerService.get();
        }

        @Override
        public int getMaxPerShard() {
            return UniversalConnectionPoolBase.this.maxConnectionsPerShard.get();
        }

        @Override
        public int getHarvestTriggerCount() {
            return UniversalConnectionPoolBase.this.m_connectionHarvestTriggerCount.get();
        }

        @Override
        public int getHarvestMaxCount() {
            return UniversalConnectionPoolBase.this.m_connectionHarvestMaxCount.get();
        }
    };
    final Counter totalConnectionsCount = new CounterImpl(){

        @Override
        public int getAndIncrement() {
            int count = super.getAndIncrement();
            if (count > UniversalConnectionPoolBase.this.limits.getMax()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        @Override
        public int decrementAndGet() {
            int count = super.decrementAndGet();
            if (count < UniversalConnectionPoolBase.this.limits.getMin()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        @Override
        public int getAndDecrement() {
            int count = super.getAndDecrement();
            if (count < UniversalConnectionPoolBase.this.limits.getMin()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        @Override
        public int incrementAndGet() {
            int count = super.incrementAndGet();
            if (count > UniversalConnectionPoolBase.this.limits.getMax()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }
    };
    final Counter borrowedConnectionsCount = new CounterImpl();
    final Counter labeledConnectionsCount = new CounterImpl();
    private String onsConfig;
    private static final int MAX_PERMITS = Integer.MAX_VALUE;
    private static final int MIN_PERMITS = 1;
    protected final Semaphore startStopSemaphore = new Semaphore(Integer.MAX_VALUE, true);
    private volatile UniversalConnectionPoolLifeCycleState lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
    protected final Core core;
    private volatile int queryTimeout = 0;
    private AtomicInteger loginTimeout = new AtomicInteger();
    private PrintWriter logWriter = null;
    public static final long HISTOGRAM_TIME_SPAN = 60000L;
    public static final long HISTOGRAM_STEP = 5L;
    public static final int FRAMES = 5;
    private final HistogramRingRegistry availableRegistry;
    private final HistogramRingRegistry borrowedRegistry;
    private final HistogramRingRegistry createdRegistry;
    private CounterMap neverUsedConnectionsCounter = new CounterMap();
    private final Tunable poolSizeTunable = new Tunable(){

        @Override
        public RingRegistry getAvailableRegistry() {
            return UniversalConnectionPoolBase.this.availableRegistry.merge(UniversalConnectionPoolBase.this.composeCurrentAvailableHistogramRingRegistry());
        }

        @Override
        public RingRegistry getBorrowedRegistry() {
            return UniversalConnectionPoolBase.this.borrowedRegistry.merge(UniversalConnectionPoolBase.this.composeCurrentBorrowedHistogramRingRegistry());
        }

        @Override
        public RingRegistry getCreatedRegistry() {
            return UniversalConnectionPoolBase.this.createdRegistry;
        }

        @Override
        public CounterMap getNeverUsedConnectionsCounter() {
            return UniversalConnectionPoolBase.this.neverUsedConnectionsCounter;
        }

        @Override
        public boolean availableGrowsInProgress() {
            return 0 != UniversalConnectionPoolBase.this.core.pendingAvailableGrows();
        }

        @Override
        public int getTotalConnectionsCount(ConnectionRetrievalInfo cri) {
            return UniversalConnectionPoolBase.this.core.connectionSource().totalCount(cri).get();
        }

        @Override
        public ConnectionGrower getConnectionGrower() {
            return cri -> UniversalConnectionPoolBase.this.core.growAvailableAsynch(cri);
        }

        @Override
        public ConnectionReducer getConnectionReducer() {
            return cri -> UniversalConnectionPoolBase.this.core.reduce(cri);
        }
    };
    private volatile boolean isOraclePool;

    public String toStringProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("[minPoolSize=").append(this.limits.getMin());
        sb.append(", maxPoolSize=").append(this.limits.getMax());
        sb.append(", initPoolSize=").append(this.limits.getInitial());
        sb.append(", repurposeThreshold=").append(this.limits.getRepurposeThreshold());
        sb.append(", maxPerService=").append(this.limits.getMaxPerService());
        sb.append(", maxPerShard=").append(this.limits.getMaxPerShard());
        sb.append(", maxPerShard=").append(this.limits.getMaxPerShard());
        sb.append(", inactiveConnectionsTimeout=").append(this.m_inactiveConnectionTimeout.get());
        sb.append(", timeoutCheckInterval=").append(this.m_timeoutCheckInterval.get());
        sb.append(", abandonedConnectionTimeout=").append(this.m_abandonedConnectionTimeout.get());
        sb.append(", connectionWaitTimeout=").append(this.connectionWaitTimeout);
        sb.append(", timeToLiveConnectionTimeout=").append(this.m_timeToLiveConnectionTimeout.get());
        sb.append(", validateConnectionOnBorrow=").append(this.validateConnectionOnBorrow);
        sb.append(", connectionHarvestTriggerCount=").append(this.m_connectionHarvestTriggerCount.get());
        sb.append(", maxConnectionReuseTime=").append(this.m_maxConnectionReuseTime.get());
        sb.append(", maxConnectionReuseCount=").append(this.m_maxConnectionReuseCount.get());
        sb.append(", connectionHarvestMaxCount=").append(this.m_connectionHarvestMaxCount.get());
        sb.append(", connectionValidationTimeout=").append(this.connectionValidationTimeout.get());
        sb.append(", failoverEnabled=").append(this.m_failoverEnabled.get());
        sb.append(", failoverExplicitlySet=").append(this.failoverExplicitlySet.get());
        sb.append(", connectionLabelingHighCost=").append(this.connectionLabelingHighCost.get());
        sb.append(", secondsToTrustIdleConnection=").append(this.secondsToTrustIdleConnection);
        sb.append(", connectionRepurposeThreshold=").append(this.connectionRepurposeThreshold.get());
        sb.append(", shareable=").append(this.shareable.get());
        sb.append(", shardingMode=").append(this.shardingMode.get());
        sb.append(", readOnlyInstanceAllowed=").append(this.readOnlyInstanceAllowed.get()).append("]");
        return sb.toString();
    }

    UniversalConnectionPoolBase(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, DiagnosticsCollectorImpl.getCommon());
    }

    UniversalConnectionPoolBase(ConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        PoolSizeTuner.plug(this.poolSizeTunable);
        this.isOraclePool = true;
        if (connectionFactoryAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(104);
        }
        this.m_connectionFactoryAdapter = connectionFactoryAdapter;
        this.m_connectionFactoryAdapter.setUniversalConnectionPool(this);
        this.core = new Core(diagnosticsCollector);
        this.core.plugConnectionSource(new Topology(diagnosticsCollector){

            @Override
            protected ConnectionFactoryAdapter getConnectionFactoryAdapter() {
                return UniversalConnectionPoolBase.this.m_connectionFactoryAdapter;
            }

            @Override
            public boolean failoverEnabled() {
                return UniversalConnectionPoolBase.this.isFailoverExplicitlySet() ? UniversalConnectionPoolBase.this.isFailoverEnabled() : this.isFANHeuristicallyEnabled();
            }

            @Override
            protected String getONSConfig() {
                return UniversalConnectionPoolBase.this.getONSConfiguration();
            }

            @Override
            protected AtomicInteger connectionsCreated() {
                return UniversalConnectionPoolBase.this.m_numConnectionsCreated;
            }

            @Override
            protected AtomicInteger connectionsClosed() {
                return UniversalConnectionPoolBase.this.m_numConnectionsClosed;
            }

            @Override
            protected AtomicLong cumulativeConnectionUseTime() {
                return UniversalConnectionPoolBase.this.m_cumulativeConnectionUseTime;
            }

            @Override
            public Counter totalCount() {
                return UniversalConnectionPoolBase.this.totalConnectionsCount;
            }

            @Override
            public Counter borrowedCount() {
                return UniversalConnectionPoolBase.this.borrowedConnectionsCount;
            }

            @Override
            public Limits limits() {
                return UniversalConnectionPoolBase.this.limits;
            }

            @Override
            protected boolean shardingMode() {
                return UniversalConnectionPoolBase.this.shardingMode.get();
            }

            @Override
            public boolean isShareable() {
                return UniversalConnectionPoolBase.this.shareable.get();
            }

            @Override
            public boolean isReadOnlyInstanceAllowed() {
                return UniversalConnectionPoolBase.this.readOnlyInstanceAllowed.get();
            }

            @Override
            public ConnectionRetrievalInfo defaultCri() {
                return UniversalConnectionPoolBase.this.defaultConnectionRetrievalInfo;
            }

            @Override
            public boolean isOracle() {
                return UniversalConnectionPoolBase.this.isOraclePool();
            }
        });
        this.core.plugLimits(this.limits);
        this.diagnosticsCollector = diagnosticsCollector;
        this.availableRegistry = new HistogramRingRegistry(5, 0L, 60000L, 5L, diagnosticsCollector);
        this.borrowedRegistry = new HistogramRingRegistry(5, 0L, 60000L, 5L, diagnosticsCollector);
        this.createdRegistry = new HistogramRingRegistry(5, 0L, 60000L, 5L, diagnosticsCollector);
    }

    public String getONSConfiguration() {
        return this.onsConfig;
    }

    public void setONSConfiguration(String onsConfig) {
        if (null == onsConfig) {
            onsConfig = "";
        }
        this.onsConfig = onsConfig;
    }

    @Override
    public abstract UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    protected abstract UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void returnConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void closeConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void purge() throws UniversalConnectionPoolException;

    @Override
    public abstract void refresh() throws UniversalConnectionPoolException;

    @Override
    public abstract void recycle() throws UniversalConnectionPoolException;

    @Override
    public void reconfigure(Properties props) throws UniversalConnectionPoolException {
    }

    public boolean isLifecycleRunning() {
        return this.getLifeCycleState() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING;
    }

    public boolean isLifecycleStarting() {
        return this.getLifeCycleState() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING;
    }

    public boolean isLifecycleStopping() {
        return this.getLifeCycleState() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING;
    }

    public boolean isLifecycleStopped() {
        return this.getLifeCycleState() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
    }

    public boolean isLifecycleFailed() {
        return this.getLifeCycleState() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ConnectionRetrievalInfo cri, boolean keepMetadataConn) throws UniversalConnectionPoolException {
        try {
            this.startStopSemaphore.acquire(Integer.MAX_VALUE);
            if (UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED != this.lifeCycleState && UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED != this.lifeCycleState) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING;
            this.trace(Level.FINE, CLASS_NAME, "start", "pool {0} starting", null, null, this.getName());
            if (1 == m_poolsRunning.incrementAndGet()) {
                UniversalConnectionPoolManagerBase.getTimerManager().start();
                Clock.start();
            }
            if (this.getConnectionRetrievalInfo() == null) {
                this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
                UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(203);
                this.trace(Level.WARNING, CLASS_NAME, "start", "pool {0} startup failed", null, ucpe, this.getName());
                throw ucpe;
            }
            try {
                if (cri instanceof JDBCConnectionRetrievalInfo) {
                    JDBCConnectionRetrievalInfo jcri = (JDBCConnectionRetrievalInfo)cri;
                    JDBCConnectionRetrievalInfo newDefaultCri = new JDBCConnectionRetrievalInfo(jcri.getUser(), jcri.getPassword());
                    if (jcri.getSSLContext() == null) {
                        this.setConnectionRetrievalInfo(newDefaultCri.getCopyWithService(jcri.getServiceName()));
                    } else {
                        this.setConnectionRetrievalInfo(newDefaultCri.getCopyWithService(jcri.getServiceName()).getCopyWithSSLContext(jcri.getSSLContext()));
                    }
                } else {
                    this.setConnectionRetrievalInfo(cri);
                }
                this.core.start(cri, keepMetadataConn);
                if (this.core.connectionSource().isRacDataAffinityEnabled() && this.getConnectionAffinityCallback() != null) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(314);
                }
                this.initAbandonedConnectionTimeoutTimer();
                this.initInactiveConnectionTimeoutTimer();
                this.initTimeToLiveConnectionTimeoutTimer();
                this.initConnectionHarvestingTimer();
                this.initReplaceNonReusableConnectionsTimer();
                this.initReplaceBadConnectionsTimer();
                this.validatePoolSizes();
                this.core.initialize();
            }
            catch (UniversalConnectionPoolException e) {
                this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
                this.trace(Level.WARNING, CLASS_NAME, "start", "pool startup failed", null, e, new Object[0]);
                this.core.closeAll();
                this.disableAbandonedConnectionTimeoutTimer();
                this.disableInactiveConnectionTimeoutTimer();
                this.disableTimeToLiveConnectionTimeoutTimer();
                this.disableConnectionHarvestingTimer();
                this.disableReplaceNonReusableConnectionsTimer();
                this.disableReplaceBadConnectionsTimer();
                this.core.stop();
                this.failoverExplicitlySet.set(false);
                if (1 == m_poolsRunning.getAndDecrement()) {
                    Clock.stop();
                    UniversalConnectionPoolManagerBase.getTimerManager().stop();
                    m_poolsRunning.set(0);
                }
                throw e;
            }
            this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING;
            this.trace(Level.FINE, CLASS_NAME, "start", "pool {0} started", null, null, this.getName());
        }
        catch (InterruptedException e) {
            this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
            this.trace(Level.WARNING, CLASS_NAME, "start", "", null, e, new Object[0]);
        }
        finally {
            assert (UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING == this.lifeCycleState || UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED == this.lifeCycleState) : "pool start procedure finished with wrong life cycle state, lifecycle=" + this.lifeCycleState.toString();
            this.startStopSemaphore.release(Integer.MAX_VALUE);
        }
    }

    @Override
    public void stop() throws UniversalConnectionPoolException {
        if (this.isLifecycleStopped()) {
            return;
        }
        try {
            boolean wasRunning;
            this.startStopSemaphore.acquire(Integer.MAX_VALUE);
            boolean bl = wasRunning = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING == this.lifeCycleState;
            assert (UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING == this.lifeCycleState || UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED == this.lifeCycleState) : "pool stop procedure started with wrong life cycle state, lifecycle=" + this.lifeCycleState.toString();
            this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING;
            this.trace(Level.FINE, CLASS_NAME, "stop", "pool stopping", null, null, new Object[0]);
            this.core.closeAll();
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.disableReplaceNonReusableConnectionsTimer();
            this.resetNonCumulativePoolStatistics();
            this.core.stop();
            this.failoverExplicitlySet.set(false);
            PoolSizeTuner.unplug(this.poolSizeTunable);
            if (wasRunning && 1 == m_poolsRunning.getAndDecrement()) {
                Clock.stop();
                UniversalConnectionPoolManagerBase.getTimerManager().stop();
                m_poolsRunning.set(0);
            }
            this.resetNonCumulativePoolStatistics();
            this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
            this.trace(Level.FINE, CLASS_NAME, "stop", "pool {0} stopped", null, null, this.getName());
        }
        catch (InterruptedException e) {
            this.lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
            this.trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
        }
        finally {
            assert (UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED == this.lifeCycleState) : "pool stop procedure finished with wrong life cycle state, lifecycle=" + this.lifeCycleState.toString();
            this.startStopSemaphore.release(Integer.MAX_VALUE);
        }
    }

    protected void resetAllPoolStatistics() {
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.core.peakBorrowedConnectionsCount.reset();
        this.core.peakConnectionsCount.reset();
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.cumulativeReturnedConnectionsCount = 0L;
        this.cumulativeBorrowedConnectionsCount = 0L;
        this.cumulativeSuccessfulConnectionWaitCount.reset();
        this.cumulativeFailedConnectionWaitCount.reset();
        this.cumulativeSuccessfulConnectionWaitTime.reset();
        this.cumulativeFailedConnectionWaitTime.reset();
        this.core.connectionSource().getCumulativeConnectionCreationAttempts().reset();
        this.core.connectionSource().getConnectionCreationAttemptsSinceLastOutage().reset();
        this.m_cumulativeConnectionUseTime.set(0L);
        this.m_cumulativeConnectionsCreated.set(0);
        this.borrowedAccumulator.set(0L);
        this.borrowedSamples.set(0L);
        this.trace(Level.FINE, CLASS_NAME, "resetAllPoolStatistics", "reset", null, null, new Object[0]);
    }

    protected void resetNonCumulativePoolStatistics() {
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.core.peakBorrowedConnectionsCount.reset();
        this.core.peakConnectionsCount.reset();
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.borrowedAccumulator.set(0L);
        this.borrowedSamples.set(0L);
        this.trace(Level.FINE, CLASS_NAME, "resetNonCumulativePoolStatistics", "reset", null, null, new Object[0]);
    }

    @Override
    public String getName() {
        return this.m_poolName.get();
    }

    @Override
    public void setName(String name) {
        this.m_poolName.set(name);
        this.trace(Level.FINE, CLASS_NAME, "setName", "name={0}", null, null, name);
    }

    @Override
    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) throws UniversalConnectionPoolException {
        if (initialPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.initialPoolSize = initialPoolSize;
        this.trace(Level.FINE, CLASS_NAME, "setInitialPoolSize", "initialPoolSize={0}", null, null, initialPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinPoolSize(int minPoolSize) throws UniversalConnectionPoolException {
        if (minPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.minPoolSize = minPoolSize;
        this.trace(Level.FINE, CLASS_NAME, "setMinPoolSize", "minPoolSize={0}", null, null, minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws UniversalConnectionPoolException {
        if (maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.maxPoolSize = maxPoolSize;
        this.core.adjustMaxLimit();
        this.maxPoolSizeWasExplicitlySet = true;
        this.trace(Level.FINE, CLASS_NAME, "setMaxPoolSize", "maxPoolSize={0}", null, null, maxPoolSize);
    }

    protected void closePhysicalConnection(Object physicalConnection) {
        try {
            this.m_connectionFactoryAdapter.closeConnection(physicalConnection);
            this.trace(Level.FINE, CLASS_NAME, "closePhysicalConnection", "physicalConnection={0}", null, null, physicalConnection);
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "closePhysicalConnection", "adapter closeConnection hit error:", null, e, new Object[0]);
        }
        finally {
            if (this.isLifecycleRunning()) {
                this.incrementConnectionsClosedCount();
            } else {
                this.trace(Level.WARNING, CLASS_NAME, "closePhysicalConnection", "pool is not running", null, null, new Object[0]);
            }
        }
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.m_inactiveConnectionTimeout.get();
    }

    private void initInactiveConnectionTimeoutTimer() {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_inactiveConnectionTimeout.get() > 0 && this.m_inactiveConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){

            @Override
            public void run() {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                    @Override
                    public void run() {
                        UniversalConnectionPoolBase.this.core.closeAvailableInactive(UniversalConnectionPoolBase.this.m_inactiveConnectionTimeout.get() * 1000);
                    }
                });
            }
        }, 0L, timeoutCheck * 1000))) {
            this.trace(Level.FINE, CLASS_NAME, "initInactiveConnectionTimeoutTimer", "scheduled", null, null, new Object[0]);
        }
    }

    private void disableInactiveConnectionTimeoutTimer() {
        TimerHandle timerToCancel = this.m_inactiveConnectionTimer.getAndSet(null);
        if (timerToCancel != null) {
            timerToCancel.cancel();
            this.trace(Level.FINE, CLASS_NAME, "disableInactiveConnectionTimeoutTimer", "canceled", null, null, new Object[0]);
        }
    }

    private void initReplaceBadConnectionsTimer() {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        this.replaceBadConnectionsTimer.updateAndGet(p -> Objects.nonNull(p) ? p : UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(() -> {
            try {
                this.core.replaceBadConnections();
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "initReplaceBadConnectionsTimer", "", null, e, new Object[0]);
            }
        }, 0L, (long)timeoutCheck * 1000L));
    }

    private void disableReplaceBadConnectionsTimer() {
        TimerHandle timerToCancel = this.replaceBadConnectionsTimer.getAndSet(null);
        if (Objects.nonNull(timerToCancel)) {
            timerToCancel.cancel();
            this.trace(Level.FINEST, CLASS_NAME, "disableReplaceBadConnectionsTimer", "timer for replacing bad connections cancelled", null, null, new Object[0]);
        }
    }

    @Override
    public void setInactiveConnectionTimeout(int inactiveConnectionTimeout) throws UniversalConnectionPoolException {
        int formerValue;
        if (inactiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((formerValue = this.m_inactiveConnectionTimeout.getAndSet(inactiveConnectionTimeout)) != inactiveConnectionTimeout) {
            this.disableInactiveConnectionTimeoutTimer();
            if (inactiveConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initInactiveConnectionTimeoutTimer();
            }
        }
        this.trace(Level.FINE, CLASS_NAME, "setInactiveConnectionTimeout", "inactiveConnectionTimeout={0}", null, null, inactiveConnectionTimeout);
    }

    protected TimerHandle getInactiveConnectionTimer() {
        return this.m_inactiveConnectionTimer.get();
    }

    @Override
    public int getConnectionWaitTimeout() {
        return Math.max(this.connectionWaitTimeout, this.core.connectionSource().getOutboundConnectTimeout());
    }

    @Override
    public void setConnectionWaitTimeout(int connectionWaitTimeout) throws UniversalConnectionPoolException {
        if (connectionWaitTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionWaitTimeout = connectionWaitTimeout;
        this.trace(Level.FINE, CLASS_NAME, "setConnectionWaitTimeout", "waitTimeout={0}", null, null, connectionWaitTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.m_timeToLiveConnectionTimeout.get();
    }

    void processTimeToLiveTimeout() {
        final int ttl = this.m_timeToLiveConnectionTimeout.get();
        if (ttl > 0) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    UniversalConnectionPoolBase.this.core.returnTTLed(ttl * 1000);
                }
            });
        }
    }

    private void initTimeToLiveConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_timeToLiveConnectionTimeout.get() > 0 && this.m_timeToLiveConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new TimeToLiveConnectionTimerTask(this), 0L, timeoutCheck * 1000))) {
            this.trace(Level.FINE, CLASS_NAME, "initTimeToLiveConnectionTimeoutTimer", "scheduled", null, null, new Object[0]);
        }
    }

    private void disableTimeToLiveConnectionTimeoutTimer() {
        TimerHandle timerToCancel = this.m_timeToLiveConnectionTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            this.trace(Level.FINE, CLASS_NAME, "disableTimeToLiveConnectionTimeoutTimer", "canceled", null, null, new Object[0]);
        }
    }

    @Override
    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws UniversalConnectionPoolException {
        int prevValue;
        if (timeToLiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((prevValue = this.m_timeToLiveConnectionTimeout.getAndSet(timeToLiveConnectionTimeout)) != timeToLiveConnectionTimeout) {
            this.disableTimeToLiveConnectionTimeoutTimer();
            if (timeToLiveConnectionTimeout != 0 && this.isLifecycleRunning()) {
                this.initTimeToLiveConnectionTimeoutTimer();
            }
        }
        this.trace(Level.FINE, CLASS_NAME, "setTimeToLiveConnectionTimeout", "timeToLiveConnectionTimeout={0}", null, null, timeToLiveConnectionTimeout);
    }

    protected TimerHandle getTimeToLiveConnectionTimer() {
        return this.m_timeToLiveConnectionTimer.get();
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.m_timeoutCheckInterval.get();
    }

    @Override
    public void setTimeoutCheckInterval(int timeoutCheckInterval) throws UniversalConnectionPoolException {
        int prevValue;
        if (timeoutCheckInterval < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((prevValue = this.m_timeoutCheckInterval.getAndSet(timeoutCheckInterval)) != timeoutCheckInterval) {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.disableReplaceNonReusableConnectionsTimer();
            this.disableReplaceBadConnectionsTimer();
            if (timeoutCheckInterval != 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
                this.initInactiveConnectionTimeoutTimer();
                this.initTimeToLiveConnectionTimeoutTimer();
                this.initConnectionHarvestingTimer();
                this.initReplaceNonReusableConnectionsTimer();
                this.initReplaceBadConnectionsTimer();
            }
        }
        this.trace(Level.FINE, CLASS_NAME, "setTimeoutCheckInterval", "timeoutCheckInterval={0}", null, null, timeoutCheckInterval);
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.validateConnectionOnBorrow;
    }

    @Override
    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
        this.validateConnectionOnBorrow = validateConnectionOnBorrow;
        this.trace(Level.FINE, CLASS_NAME, "setValidateConnectionOnBorrow", "validateConnectionOnBorrow={0}", null, null, validateConnectionOnBorrow);
    }

    @Override
    public int getSecondsToTrustIdleConnection() {
        return this.secondsToTrustIdleConnection;
    }

    @Override
    public void setSecondsToTrustIdleConnection(int secondsToTrustIdleConnection) throws UniversalConnectionPoolException {
        if (!(secondsToTrustIdleConnection == 120 || this.getValidateConnectionOnBorrow() && secondsToTrustIdleConnection >= 0)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.secondsToTrustIdleConnection = secondsToTrustIdleConnection;
        this.trace(Level.FINE, CLASS_NAME, "setSecondsToTrustIdleConnection", "secondsToTrustIdleConnection={0}", null, null, secondsToTrustIdleConnection);
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.m_connectionHarvestTriggerCount.get();
    }

    @Override
    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws UniversalConnectionPoolException {
        int prevValue;
        if (connectionHarvestTriggerCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (connectionHarvestTriggerCount != (prevValue = this.m_connectionHarvestTriggerCount.getAndSet(connectionHarvestTriggerCount))) {
            this.disableConnectionHarvestingTimer();
            if (this.m_connectionHarvestTriggerCount.get() >= 0 && this.m_connectionHarvestTriggerCount.get() < Integer.MAX_VALUE && this.isLifecycleRunning()) {
                this.initConnectionHarvestingTimer();
            }
        }
        this.trace(Level.FINE, CLASS_NAME, "setConnectionHarvestTriggerCount", "connectionHarvestTriggerCount={0}", null, null, connectionHarvestTriggerCount);
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.m_connectionHarvestMaxCount.get();
    }

    @Override
    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws UniversalConnectionPoolException {
        if (connectionHarvestMaxCount < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionHarvestMaxCount.set(connectionHarvestMaxCount);
        this.trace(Level.FINE, CLASS_NAME, "setConnectionHarvestMaxCount", "connectionHarvestMaxCount={0}", null, null, connectionHarvestMaxCount);
    }

    int getConnectionsCreatedCount() {
        return this.m_numConnectionsCreated.get();
    }

    protected void incrementConnectionsCreatedCount() {
        this.m_numConnectionsCreated.incrementAndGet();
    }

    int getConnectionsClosedCount() {
        return this.m_numConnectionsClosed.get();
    }

    protected void incrementConnectionsClosedCount() {
        this.m_numConnectionsClosed.incrementAndGet();
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.totalConnectionsCount.get() - this.borrowedConnectionsCount.get();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.borrowedConnectionsCount.get();
    }

    public int getTotalConnectionsCount() {
        return this.totalConnectionsCount.get();
    }

    @Override
    public abstract UniversalConnectionPoolStatistics getStatistics();

    @Override
    public UniversalConnectionPoolLifeCycleState getLifeCycleState() {
        UniversalConnectionPoolLifeCycleState state = this.lifeCycleState;
        try {
            this.startStopSemaphore.acquire(1);
            state = this.lifeCycleState;
        }
        catch (InterruptedException e) {
            this.trace(Level.WARNING, CLASS_NAME, "getLifeCycleState", "semaphore acquire hit error:", null, e, new Object[0]);
        }
        finally {
            this.startStopSemaphore.release(1);
        }
        return state;
    }

    public ConnectionFactoryAdapter getConnectionFactoryAdapter() {
        return this.m_connectionFactoryAdapter;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.defaultConnectionRetrievalInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void defaultCRI;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "setConnectionRetrievalInfo", "entering args ({0})", null, null, connectionRetrievalInfo);
            this.defaultConnectionRetrievalInfo = defaultCRI;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "setConnectionRetrievalInfo", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "setConnectionRetrievalInfo", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public String getServiceName() {
        return this.core.connectionSource().defaultServiceName();
    }

    @Override
    public void registerConnectionLabelingCallback(ConnectionLabelingCallback cbk) throws UniversalConnectionPoolException {
        if (!this.m_connectionLabelingCallback.compareAndSet(null, cbk)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(91);
        }
        this.trace(Level.FINE, CLASS_NAME, "registerConnectionLabelingCallback", "cbk={0}", null, null, cbk);
    }

    @Override
    public void removeConnectionLabelingCallback() {
        this.m_connectionLabelingCallback.set(null);
        this.trace(Level.FINE, CLASS_NAME, "removeConnectionLabelingCallback", "removed", null, null, new Object[0]);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.connectionAffinityCallback = cbk;
        this.trace(Level.FINE, CLASS_NAME, "registerConnectionAffinityCallback", "cbk={0}", null, null, cbk);
    }

    @Override
    public void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        this.connectionAffinityCallback = null;
        this.trace(Level.FINE, CLASS_NAME, "removeConnectionAffinityCallback", "removed", null, null, new Object[0]);
    }

    public ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.connectionAffinityCallback;
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.m_abandonedConnectionTimeout.get();
    }

    void processAbandonedConnections() {
        this.trace(Level.FINE, CLASS_NAME, "processAbandonedConnections", "about to process abandoned connections", null, null, new Object[0]);
        final int abandonedTimeout = this.m_abandonedConnectionTimeout.get();
        if (abandonedTimeout > 0) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    UniversalConnectionPoolBase.this.core.returnAbandoned(abandonedTimeout * 1000);
                }
            });
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void initAbandonedConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "initAbandonedConnectionTimeoutTimer", "entering args ()", null, null, new Object[0]);
            int timeoutCheck = this.m_timeoutCheckInterval.get();
            if (timeoutCheck > 0 && this.m_abandonedConnectionTimeout.get() > 0) {
                this.m_abandonedConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new AbandonedConnectionTimerTask(this), 0L, timeoutCheck * 1000));
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "initAbandonedConnectionTimeoutTimer", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "initAbandonedConnectionTimeoutTimer", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected void validatePoolSizes() throws UniversalConnectionPoolException {
        if (this.minPoolSize < 0) {
            this.trace(Level.WARNING, CLASS_NAME, "validatePoolSizes", "configured: minPoolSize={0}, automatically set to 0", null, null, this.minPoolSize);
            this.minPoolSize = 0;
        }
        if (this.maxPoolSize < 0) {
            this.trace(Level.WARNING, CLASS_NAME, "validatePoolSizes", "configured: maxPoolSize={0}, automatically set to 0", null, null, this.maxPoolSize);
            this.maxPoolSize = 0;
        }
        if (this.initialPoolSize < 0) {
            this.trace(Level.WARNING, CLASS_NAME, "validatePoolSizes", "configured: initialPoolSize={0}, automatically set to 0", null, null, this.initialPoolSize);
            this.initialPoolSize = 0;
        }
        if (Math.max(this.initialPoolSize, this.minPoolSize) > this.maxPoolSize) {
            if (this.maxPoolSizeWasExplicitlySet) {
                if (this.minPoolSize > this.maxPoolSize) {
                    this.trace(Level.WARNING, CLASS_NAME, "validatePoolSizes", "configured: minPoolSize={0} > maxPoolSize={1} and maxPoolSize was explicitly set, automatically set minPoolSize=maxPoolSize", null, null, this.minPoolSize, this.maxPoolSize);
                    this.minPoolSize = this.maxPoolSize;
                }
                if (this.initialPoolSize > this.maxPoolSize) {
                    this.trace(Level.WARNING, CLASS_NAME, "validatePoolSizes", "configured: initialPoolSize={0} > maxPoolSize={1} and maxPoolSize was explicitly set, automatically set initialPoolSize=maxPoolSize", null, null, this.initialPoolSize, this.maxPoolSize);
                    this.initialPoolSize = this.maxPoolSize;
                }
            } else {
                this.trace(Level.WARNING, CLASS_NAME, "validatePoolSizes", "configured: max(minPoolSize={0}, initialPoolSize={1}) > maxPoolSize={2} and maxPoolSize was not explicitly set, automatically set maxPoolSize=max(minPoolSize, initialPoolSize)", null, null, this.minPoolSize, this.initialPoolSize, this.maxPoolSize);
                this.maxPoolSize = Math.max(this.minPoolSize, this.initialPoolSize);
            }
        }
        if (0 == this.maxPoolSize) {
            UCPErrorHandler.throwUniversalConnectionPoolException(59);
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void disableAbandonedConnectionTimeoutTimer() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "disableAbandonedConnectionTimeoutTimer", "entering args ()", null, null, new Object[0]);
            TimerHandle timerToCancel = this.m_abandonedConnectionTimer.getAndSet(null);
            if (null != timerToCancel) {
                timerToCancel.cancel();
                this.trace(Level.FINE, CLASS_NAME, "disableAbandonedConnectionTimeoutTimer", "cancelled", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "disableAbandonedConnectionTimeoutTimer", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "disableAbandonedConnectionTimeoutTimer", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws UniversalConnectionPoolException {
        int prevValue;
        if (abandonedConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (abandonedConnectionTimeout != (prevValue = this.m_abandonedConnectionTimeout.getAndSet(abandonedConnectionTimeout))) {
            this.disableAbandonedConnectionTimeoutTimer();
            if (abandonedConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
                this.setQueryTimeout(60);
            } else {
                this.setQueryTimeout(0);
            }
        }
        this.trace(Level.FINE, CLASS_NAME, "setAbandonedConnectionTimeout", "abandonedConnectionTimeout={0}", null, null, abandonedConnectionTimeout);
    }

    protected TimerHandle getAbandonedConnectionTimer() {
        return this.m_abandonedConnectionTimer.get();
    }

    abstract void processConnectionHarvesting();

    private void initConnectionHarvestingTimer() throws UniversalConnectionPoolException {
        int connectionHarvestTriggerCount = this.m_connectionHarvestTriggerCount.get();
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && connectionHarvestTriggerCount >= 0 && connectionHarvestTriggerCount < Integer.MAX_VALUE && this.m_connectionHarvestTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new ConnectionHarvestingTimerTask(this), 0L, timeoutCheck * 1000))) {
            this.trace(Level.FINE, CLASS_NAME, "initConnectionHarvestingTimer", "scheduled", null, null, new Object[0]);
        }
    }

    private void disableConnectionHarvestingTimer() {
        TimerHandle timerToCancel = this.m_connectionHarvestTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            this.trace(Level.FINE, CLASS_NAME, "disableConnectionHarvestingTimer", "cancelled", null, null, new Object[0]);
        }
    }

    private void initReplaceNonReusableConnectionsTimer() {
        long reuseTime = this.m_maxConnectionReuseTime.get();
        long timerInterval = reuseTime / 4L + reuseTime % 4L;
        if (reuseTime > 0L && this.m_replaceNonReusableConnectionsTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){

            @Override
            public void run() {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                    @Override
                    public void run() {
                        UniversalConnectionPoolBase.this.core.replaceNonReusable();
                    }
                });
            }
        }, 0L, timerInterval * 1000L))) {
            this.trace(Level.FINE, CLASS_NAME, "initReplaceNonReusableConnectionsTimer", "scheduled", null, null, new Object[0]);
        }
    }

    private void disableReplaceNonReusableConnectionsTimer() {
        TimerHandle timerToCancel = this.m_replaceNonReusableConnectionsTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            this.trace(Level.FINE, CLASS_NAME, "cancelReplaceNonReusableConnectionsTimer", "cancelled", null, null, new Object[0]);
        }
    }

    public boolean isFailoverEnabled() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return this.isFailoverExplicitlySet() ? this.m_failoverEnabled.get() : ((Topology)cs).isFANHeuristicallyEnabled();
        }
        return this.m_failoverEnabled.get();
    }

    protected boolean isFailoverExplicitlySet() {
        return this.failoverExplicitlySet.get();
    }

    public void setFailoverEnabled(boolean failoverEnabled) {
        this.m_failoverEnabled.set(failoverEnabled);
        this.failoverExplicitlySet.set(true);
        this.trace(Level.FINE, CLASS_NAME, "setFailoverEnabled", "failoverEnabled={0}", null, null, failoverEnabled);
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.m_maxConnectionReuseTime.get();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws UniversalConnectionPoolException {
        if (maxConnectionReuseTime < 0L) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (maxConnectionReuseTime != this.m_maxConnectionReuseTime.get()) {
            this.disableReplaceNonReusableConnectionsTimer();
            this.m_maxConnectionReuseTime.set(maxConnectionReuseTime);
            if (maxConnectionReuseTime > 0L && this.isLifecycleRunning()) {
                this.initReplaceNonReusableConnectionsTimer();
            }
        }
        this.trace(Level.FINE, CLASS_NAME, "setMaxConnectionReuseTime", "maxConnectionReuseTime={0}", null, null, maxConnectionReuseTime);
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.m_maxConnectionReuseCount.get();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws UniversalConnectionPoolException {
        if (maxConnectionReuseCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_maxConnectionReuseCount.set(maxConnectionReuseCount);
        this.trace(Level.FINE, CLASS_NAME, "setMaxConnectionReuseCount", "maxConnectionReuseCount={0}", null, null, maxConnectionReuseCount);
    }

    public boolean isRuntimeLoadBalancingEnabled() {
        return false;
    }

    public void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
    }

    protected abstract UniversalPooledConnection getUsedConnection(Object var1);

    protected abstract boolean returnUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    @Override
    public void setFailoverInfo(Object info) {
    }

    @Override
    public Object getFailoverInfo() {
        return null;
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) {
    }

    int getAbandonedConnectionsCount() {
        return this.m_abandonedConnectionsCount.get();
    }

    int getPendingRequestsCount() {
        return this.m_pendingRequestsCount.get();
    }

    long getCumulativeConnectionReturnedCount() {
        return this.cumulativeReturnedConnectionsCount;
    }

    long getCumulativeSuccessfulConnectionWaitCount() {
        return this.cumulativeSuccessfulConnectionWaitCount.longValue();
    }

    long getCumulativeFailedConnectionWaitCount() {
        return this.cumulativeFailedConnectionWaitCount.longValue();
    }

    long getCumulativeSuccessfulConnectionWaitTime() {
        return this.cumulativeSuccessfulConnectionWaitTime.longValue();
    }

    long getCumulativeFailedConnectionWaitTime() {
        return this.cumulativeFailedConnectionWaitTime.longValue();
    }

    long getCumulativeConnectionBorrowedCount() {
        return this.cumulativeBorrowedConnectionsCount;
    }

    long getPeakConnectionWaitTime() {
        return this.m_peakConnectionWaitTime.get();
    }

    long getCumulativeConnectionUseTime() {
        return this.m_cumulativeConnectionUseTime.get();
    }

    int getPeakConnectionsCount() {
        return this.core.peakConnectionsCount.get();
    }

    int getPeakBorrowedConnectionsCount() {
        return this.core.peakBorrowedConnectionsCount.get();
    }

    int getCumulativeConnectionsCreated() {
        return this.m_cumulativeConnectionsCreated.get();
    }

    int getAverageBorrowedConnectionsCount() {
        long accum = this.borrowedAccumulator.get();
        long samples = this.borrowedSamples.get();
        return 0L != samples ? Math.toIntExact(accum / samples) : 0;
    }

    public ConnectionLabelingCallback getConnectionLabelingCallback() {
        return this.m_connectionLabelingCallback.get();
    }

    protected long getCumulativeReturnedConnectionCount() {
        return this.cumulativeReturnedConnectionsCount;
    }

    @Override
    public int getConnectionLabelingHighCost() {
        return this.connectionLabelingHighCost.get();
    }

    @Override
    public void setConnectionLabelingHighCost(int highCost) throws UniversalConnectionPoolException {
        if (highCost < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionLabelingHighCost.set(highCost);
        this.trace(Level.FINE, CLASS_NAME, "setConnectionLabelingHighCost", "highCost={0}", null, null, highCost);
    }

    @Override
    public int getHighCostConnectionReuseThreshold() {
        return this.highCostConnectionReuseThreshold.get();
    }

    @Override
    public void setHighCostConnectionReuseThreshold(int threshold) throws UniversalConnectionPoolException {
        if (threshold < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.highCostConnectionReuseThreshold.set(threshold);
        this.trace(Level.FINE, CLASS_NAME, "setHighCostConnectionReuseThreshold", "threshold={0}", null, null, threshold);
    }

    @Override
    public int getMaxConnectionsPerService() {
        return this.maxConnectionsPerService.get();
    }

    @Override
    public void setMaxConnectionsPerService(int maxPerService) throws UniversalConnectionPoolException {
        if (maxPerService < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.isLifecycleRunning() && maxPerService != this.maxConnectionsPerService.get()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(279);
        }
        this.maxConnectionsPerService.set(maxPerService);
        this.trace(Level.FINE, CLASS_NAME, "setMaxConnectionsPerService", "maxPerService={0}", null, null, maxPerService);
    }

    public void setShareable(boolean shared) {
        this.shareable.set(shared);
        this.trace(Level.FINE, CLASS_NAME, "setShareable", "shared={0}", null, null, shared);
    }

    @Override
    public boolean isShareable() {
        return this.shareable.get();
    }

    @Override
    public int getConnectionRepurposeThreshold() {
        return this.connectionRepurposeThreshold.get();
    }

    @Override
    public void setConnectionRepurposeThreshold(Integer threshold) throws UniversalConnectionPoolException {
        if (threshold < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionRepurposeThreshold.set(threshold);
        this.trace(Level.FINE, CLASS_NAME, "setConnectionRepurposeThreshold", "threshold={0}", null, null, threshold);
    }

    public int getMaxConnectionsPerShard() {
        return this.maxConnectionsPerShard.get();
    }

    public void setMaxConnectionsPerShard(Integer maxConnsPerShard) throws UniversalConnectionPoolException {
        if (maxConnsPerShard < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.maxConnectionsPerShard.set(maxConnsPerShard);
        this.trace(Level.FINE, CLASS_NAME, "setMaxConnectionsPerShard", "maxConnsPerShard={0}", null, null, maxConnsPerShard);
    }

    @Override
    public void setConnectionValidationTimeout(int connectionValidationTimeout) throws UniversalConnectionPoolException {
        if (connectionValidationTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionValidationTimeout.set(connectionValidationTimeout);
        this.trace(Level.FINE, CLASS_NAME, "setConnectionValidationTimeout", "connectionValidationTimeout={0}", null, null, connectionValidationTimeout);
    }

    @Override
    public int getConnectionValidationTimeout() {
        return this.connectionValidationTimeout.get();
    }

    @Override
    public void setShardingMode(boolean shardingMode) {
        this.shardingMode.set(shardingMode);
        this.trace(Level.FINE, CLASS_NAME, "setShardingMode", "shardingMode={0}", null, null, shardingMode);
    }

    @Override
    public boolean getShardingMode() {
        return this.shardingMode.get();
    }

    @Override
    public boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed.get();
    }

    @Override
    public void setReadOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.readOnlyInstanceAllowed.set(readOnlyInstanceAllowed);
        this.trace(Level.FINE, CLASS_NAME, "setReadOnlyInstanceAllowed", "readOnlyInstanceAllowed={0}", null, null, readOnlyInstanceAllowed);
    }

    int pendingGrowsCount() {
        return this.core.pendingGrowsCount();
    }

    public String getDatabaseTopologyInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getDatabaseTopologyInfo();
        }
        return "not collected yet";
    }

    public String getShardedDatabaseInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardedDatabaseInfo();
        }
        return "not discovered";
    }

    public String getShardRoutingCacheInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardRoutingCacheInfo();
        }
        return "No shard routing cache built in UCP";
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) throws UniversalConnectionPoolException {
        if (queryTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.queryTimeout = queryTimeout;
        this.trace(Level.FINE, CLASS_NAME, "setQueryTimeout", "queryTimeout={0}", null, null, queryTimeout);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout.get();
    }

    @Override
    public void setLoginTimeout(int seconds) throws UniversalConnectionPoolException {
        if (seconds < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.loginTimeout.set(seconds);
        this.trace(Level.FINE, CLASS_NAME, "setLoginTimeout", "loginTimeout={0}", null, null, seconds);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Debug(level=Debug.Level.FINEST)
    private HistogramRingRegistry composeCurrentAvailableHistogramRingRegistry() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "composeCurrentAvailableHistogramRingRegistry", "entering args ()", null, null, new Object[0]);
            HistogramRingRegistry regAvailable = new HistogramRingRegistry(1, 0L, 60000L, 5L, this.getDiagnosable());
            this.core.forEach(conn -> {
                UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
                if (conn.available()) {
                    long delta = Clock.clock() - upc.getAvailableStartTime();
                    regAvailable.insert(conn.cri(), delta);
                }
            });
            HistogramRingRegistry histogramRingRegistry = regAvailable;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "composeCurrentAvailableHistogramRingRegistry", "returning {0}", null, null, histogramRingRegistry);
            return histogramRingRegistry;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "composeCurrentAvailableHistogramRingRegistry", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private HistogramRingRegistry composeCurrentBorrowedHistogramRingRegistry() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "composeCurrentBorrowedHistogramRingRegistry", "entering args ()", null, null, new Object[0]);
            HistogramRingRegistry regBorrowed = new HistogramRingRegistry(1, 0L, 60000L, 5L, this.getDiagnosable());
            this.core.forEach(conn -> {
                UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
                if (!conn.available()) {
                    regBorrowed.insert(conn.cri(), Clock.clock() - upc.getBorrowedStartTime());
                }
            });
            HistogramRingRegistry histogramRingRegistry = regBorrowed;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "composeCurrentBorrowedHistogramRingRegistry", "returning {0}", null, null, histogramRingRegistry);
            return histogramRingRegistry;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolBase", "composeCurrentBorrowedHistogramRingRegistry", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    void insertToAvailableHistogram(ConnectionRetrievalInfo cri, long time) {
        this.availableRegistry.insert(cri, time);
    }

    void insertToBorrowedHistogram(ConnectionRetrievalInfo cri, long time) {
        this.borrowedRegistry.insert(cri, time);
    }

    void insertToCreatedHistogram(ConnectionRetrievalInfo cri, long time) {
        this.createdRegistry.insert(cri, time);
    }

    CounterMap getNeverUsedConnectionsCounter() {
        return this.neverUsedConnectionsCounter;
    }

    int getLabeledConnectionsCount() {
        return this.labeledConnectionsCount.get();
    }

    Map<String, ShardConnectionStatistics> getShardConnectionStats() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardConnectionStats();
        }
        return Collections.emptyMap();
    }

    public void setOraclePool(boolean isOraclePool) {
        this.isOraclePool = isOraclePool;
        this.trace(Level.FINE, CLASS_NAME, "setOraclePool", "isOraclePool={0}", null, null, isOraclePool);
    }

    boolean isOraclePool() {
        return this.isOraclePool;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public long getCumulativeConnectionCreationAttempts() {
        return this.core.connectionSource().getCumulativeConnectionCreationAttempts().longValue();
    }

    public long getConnectionCreationAttemptsSinceLastOutage() {
        return this.core.connectionSource().getConnectionCreationAttemptsSinceLastOutage().longValue();
    }
}

