/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.RingBuffer;
import oracle.ucp.util.Util;

public class DiagnosticsSummary {
    static final String CLASS_NAME;
    private static RingBuffer<Throwable> throwables;
    private static RingBuffer<String> lbSummaries;
    private static final Object securedLogger;

    private DiagnosticsSummary() {
    }

    public static void addException(Throwable e) {
        throwables.addItem(e);
    }

    public static void addLBSummary(String summary) {
        lbSummaries.addItem(summary);
    }

    public static String collect() throws UniversalConnectionPoolException {
        StringBuilder sb = new StringBuilder();
        UniversalConnectionPoolManager manager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(DiagnosticsCollectorImpl.getCommon());
        String[] poolNames = manager.getConnectionPoolNames();
        sb.append("<pools>");
        for (String poolName : poolNames) {
            UniversalConnectionPoolBase ucp = (UniversalConnectionPoolBase)manager.getConnectionPool(poolName);
            sb.append("<pool name=\"").append(poolName);
            sb.append("\", lifecycle=\"").append(ucp.getLifeCycleState());
            sb.append("\", properties=\"").append(ucp.toStringProperties());
            sb.append("\", stats=\"").append(ucp.getStatistics().toString());
            sb.append("\", topology=\"").append(ucp.getDatabaseTopologyInfo());
            sb.append("\", shardedDb=\"").append(ucp.getShardedDatabaseInfo());
            sb.append("\", shardRoutingCache=\"").append(ucp.getShardRoutingCacheInfo());
            sb.append("\", workingSet=\"");
            ucp.core.forEach(conn -> sb.append(conn.getDelegate().toString()).append(", "));
            sb.append("\" />");
        }
        sb.append("</pools>");
        sb.append("<throwables>");
        throwables.getAsList().forEach(e -> sb.append("<throwable message=\"").append(e.getMessage()).append("\", stack=\"").append(Arrays.deepToString(e.getStackTrace())).append("\" />"));
        sb.append("</throwables>");
        sb.append("<lbstats>");
        lbSummaries.getAsList().forEach(s -> sb.append("<lbstat>").append((String)s).append("</lbstat>"));
        sb.append("</lbstats>");
        return sb.toString();
    }

    public static Object getSecuredLogger() {
        return securedLogger;
    }

    static {
        Class<?> clsSecuredLogger;
        CLASS_NAME = DiagnosticsSummary.class.getName();
        throwables = new RingBuffer(1024);
        lbSummaries = new RingBuffer(1024);
        try {
            clsSecuredLogger = Util.getClassForName("oracle.jdbc.diagnostics.SecuredLogger", false, Thread.currentThread().getContextClassLoader(), DiagnosticsSummary.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            clsSecuredLogger = null;
        }
        if (null != clsSecuredLogger) {
            Object logger;
            try {
                Method m = clsSecuredLogger.getMethod("newLogger", String.class);
                logger = m.invoke(null, "UCP-logBuffer-" + UUID.randomUUID().toString(), null);
            }
            catch (IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                logger = null;
            }
            securedLogger = logger;
        } else {
            securedLogger = null;
        }
        if (null != DiagnosticsSummary.getSecuredLogger()) {
            if (Util.isShutdownHookEnabled()) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "addShutdownHook", DiagnosticsSummary.collect(), null, null, new Object[0]);
                    }
                    catch (UniversalConnectionPoolException e) {
                        DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "addShutdownHook", "", null, e, new Object[0]);
                    }
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "addShutdownHook", "diagnostics summary hook stopped", null, null, new Object[0]);
                }));
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "shutdownHook", "The diagnostics summary collector was explicitly disabled and it is customer\u2019s \nresponsibility to explicitly call it if this summary is needed", null, null, null);
            }
        }
    }
}

