/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

public class Clock {
    static final String CLASS_NAME = Clock.class.getName();
    public static final long GRANULARITY = 60L;
    public static final long ACCURACY = 300L;
    public static final long IDLE_TIMEOUT = 1500L;
    private static volatile long clock = 0L;
    private static volatile long clockTerm = 0L;
    private static boolean stopped = true;
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition cond = lock.newCondition();
    private static Thread clockThread = new Thread(() -> {
        try {
            while (true) {
                DiagnosticsCollectorImpl.getCommon().debug(Level.FINEST, CLASS_NAME, "run", "clock thread about to wait", null, null, new Object[0]);
                lock.lock();
                try {
                    while (0L == clock) {
                        cond.await();
                    }
                }
                finally {
                    lock.unlock();
                }
                DiagnosticsCollectorImpl.getCommon().debug(Level.FINEST, CLASS_NAME, "run", "clock thread woke up", null, null, new Object[0]);
                while (clock < clockTerm) {
                    long ct = clock + 300L;
                    while (clock < ct) {
                        Thread.sleep(30L);
                        clock += 30L;
                    }
                    clock = System.currentTimeMillis();
                }
                clock = 0L;
            }
        }
        catch (InterruptedException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "run", "", null, e, new Object[0]);
            return;
        }
    }, "UCP Clock");

    public static long clock() {
        if (stopped) {
            return System.currentTimeMillis();
        }
        long t = clock;
        if (0L == t) {
            lock.lock();
            try {
                t = clock = System.currentTimeMillis();
                clockTerm = t + 1500L;
                cond.signal();
                DiagnosticsCollectorImpl.getCommon().debug(Level.FINEST, CLASS_NAME, "clock", "clock signaled", null, null, new Object[0]);
            }
            finally {
                lock.unlock();
            }
        }
        return t;
    }

    public static void start() {
        stopped = false;
    }

    public static void stop() {
        stopped = true;
    }

    public static boolean isBefore(long time1, long time2) {
        return time1 < time2 - 300L;
    }

    static {
        clockThread.setDaemon(true);
        clockThread.start();
    }
}

