/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollector;
import oracle.ucp.util.UCPErrorHandler;

public class UniversalConnectionPoolMBeanBase
implements UniversalConnectionPoolMBean,
Diagnosable {
    static final String CLASS_NAME = UniversalConnectionPoolMBeanBase.class.getName();
    protected final UniversalConnectionPool connectionPool;

    public UniversalConnectionPoolMBeanBase(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        this.connectionPool = connectionPool;
    }

    @Override
    public void refresh() throws UniversalConnectionPoolException {
        this.connectionPool.refresh();
    }

    @Override
    public void recycle() throws UniversalConnectionPoolException {
        this.connectionPool.recycle();
    }

    @Override
    public void purge() throws UniversalConnectionPoolException {
        this.connectionPool.purge();
    }

    @Override
    public void start() throws UniversalConnectionPoolException {
        this.connectionPool.start();
    }

    @Override
    public void stop() throws UniversalConnectionPoolException {
        this.connectionPool.stop();
    }

    @Override
    public String getName() {
        return this.connectionPool.getName();
    }

    @Override
    public void setName(String name) throws UniversalConnectionPoolException {
        try {
            UniversalConnectionPoolManagerHelper umh = new UniversalConnectionPoolManagerHelper(this.connectionPool);
            umh.setManagerPoolID(name);
        }
        catch (UniversalConnectionPoolException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(379);
        }
        this.connectionPool.setName(name);
    }

    @Override
    public int getInitialPoolSize() {
        return this.connectionPool.getInitialPoolSize();
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) throws UniversalConnectionPoolException {
        this.connectionPool.setInitialPoolSize(initialPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.connectionPool.getMinPoolSize();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) throws UniversalConnectionPoolException {
        this.connectionPool.setMinPoolSize(minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.connectionPool.getMaxPoolSize();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws UniversalConnectionPoolException {
        this.connectionPool.setMaxPoolSize(maxPoolSize);
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.connectionPool.getInactiveConnectionTimeout();
    }

    @Override
    public void setInactiveConnectionTimeout(int inactiveConnectionTimeout) throws UniversalConnectionPoolException {
        this.connectionPool.setInactiveConnectionTimeout(inactiveConnectionTimeout);
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.connectionPool.getAbandonedConnectionTimeout();
    }

    @Override
    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws UniversalConnectionPoolException {
        this.connectionPool.setAbandonedConnectionTimeout(abandonedConnectionTimeout);
    }

    @Override
    public int getConnectionWaitTimeout() {
        return this.connectionPool.getConnectionWaitTimeout();
    }

    @Override
    public void setConnectionWaitTimeout(int connectionWaitTimeout) throws UniversalConnectionPoolException {
        this.connectionPool.setConnectionWaitTimeout(connectionWaitTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.connectionPool.getTimeToLiveConnectionTimeout();
    }

    @Override
    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws UniversalConnectionPoolException {
        this.connectionPool.setTimeToLiveConnectionTimeout(timeToLiveConnectionTimeout);
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.connectionPool.getTimeoutCheckInterval();
    }

    @Override
    public void setTimeoutCheckInterval(int timeoutCheckInterval) throws UniversalConnectionPoolException {
        this.connectionPool.setTimeoutCheckInterval(timeoutCheckInterval);
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.connectionPool.getValidateConnectionOnBorrow();
    }

    @Override
    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
        this.connectionPool.setValidateConnectionOnBorrow(validateConnectionOnBorrow);
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.connectionPool.getConnectionHarvestTriggerCount();
    }

    @Override
    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws UniversalConnectionPoolException {
        this.connectionPool.setConnectionHarvestTriggerCount(connectionHarvestTriggerCount);
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.connectionPool.getConnectionHarvestMaxCount();
    }

    @Override
    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws UniversalConnectionPoolException {
        this.connectionPool.setConnectionHarvestMaxCount(connectionHarvestMaxCount);
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.connectionPool.getMaxConnectionReuseTime();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws UniversalConnectionPoolException {
        this.connectionPool.setMaxConnectionReuseTime(maxConnectionReuseTime);
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.connectionPool.getMaxConnectionReuseCount();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws UniversalConnectionPoolException {
        this.connectionPool.setMaxConnectionReuseCount(maxConnectionReuseCount);
    }

    @Override
    public void setShardingMode(boolean shardingMode) {
        this.connectionPool.setShardingMode(shardingMode);
    }

    @Override
    public boolean getShardingMode() {
        return this.connectionPool.getShardingMode();
    }

    @Override
    public int getConnectionValidationTimeout() {
        return this.connectionPool.getConnectionValidationTimeout();
    }

    @Override
    public void setConnectionValidationTimeout(int connectionValidationTimeout) throws UniversalConnectionPoolException {
        this.connectionPool.setConnectionValidationTimeout(connectionValidationTimeout);
    }

    @Override
    public boolean isReadOnlyInstanceAllowed() {
        return this.connectionPool.isReadOnlyInstanceAllowed();
    }

    @Override
    public void setReadOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.connectionPool.setReadOnlyInstanceAllowed(readOnlyInstanceAllowed);
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.connectionPool.getAvailableConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.connectionPool.getBorrowedConnectionsCount();
    }

    @Override
    public String getStatistics() {
        return this.connectionPool.getStatistics().toString();
    }

    @Override
    public String getLifeCycleState() {
        return this.connectionPool.getLifeCycleState().toString();
    }

    @Override
    public void useStrictWebSessionAffinity(boolean strict) {
        throw new RuntimeException("has to be overridden");
    }

    @Override
    public void useStrictXAAffinity(boolean strict) {
        throw new RuntimeException("has to be overridden");
    }

    @Override
    public int getSecondsToTrustIdleConnection() {
        return this.connectionPool.getSecondsToTrustIdleConnection();
    }

    @Override
    public void setSecondsToTrustIdleConnection(int secondsToTrustIdleConnection) throws UniversalConnectionPoolException {
        this.connectionPool.setSecondsToTrustIdleConnection(secondsToTrustIdleConnection);
    }

    @Override
    public int getTotalConnectionsCount() {
        return this.connectionPool.getStatistics().getTotalConnectionsCount();
    }

    @Override
    public String getShardConnectionStats() {
        return this.connectionPool.getStatistics().getShardConnectionStats().toString();
    }

    @Override
    public int getAverageBorrowedConnectionsCount() {
        return this.connectionPool.getStatistics().getAverageBorrowedConnectionsCount();
    }

    @Override
    public int getPeakConnectionsCount() {
        return this.connectionPool.getStatistics().getPeakConnectionsCount();
    }

    @Override
    public int getPeakBorrowedConnectionsCount() {
        return this.connectionPool.getStatistics().getPeakBorrowedConnectionsCount();
    }

    @Override
    public int getRemainingPoolCapacityCount() {
        return this.connectionPool.getStatistics().getRemainingPoolCapacityCount();
    }

    @Override
    public int getLabeledConnectionsCount() {
        return this.connectionPool.getStatistics().getLabeledConnectionsCount();
    }

    @Override
    public int getConnectionsCreatedCount() {
        return this.connectionPool.getStatistics().getConnectionsCreatedCount();
    }

    @Override
    public int getConnectionsClosedCount() {
        return this.connectionPool.getStatistics().getConnectionsClosedCount();
    }

    @Override
    public long getAverageConnectionWaitTime() {
        return this.connectionPool.getStatistics().getAverageConnectionWaitTime();
    }

    @Override
    public long getPeakConnectionWaitTime() {
        return this.connectionPool.getStatistics().getPeakConnectionWaitTime();
    }

    @Override
    public int getAbandonedConnectionsCount() {
        return this.connectionPool.getStatistics().getAbandonedConnectionsCount();
    }

    @Override
    public int getPendingRequestsCount() {
        return this.connectionPool.getStatistics().getPendingRequestsCount();
    }

    @Override
    public long getCumulativeConnectionWaitTime() {
        return this.connectionPool.getStatistics().getCumulativeConnectionWaitTime();
    }

    @Override
    public long getCumulativeConnectionBorrowedCount() {
        return this.connectionPool.getStatistics().getCumulativeConnectionBorrowedCount();
    }

    @Override
    public long getCumulativeConnectionUseTime() {
        return this.connectionPool.getStatistics().getCumulativeConnectionUseTime();
    }

    @Override
    public long getCumulativeConnectionReturnedCount() {
        return this.connectionPool.getStatistics().getCumulativeConnectionReturnedCount();
    }

    @Override
    public long getCumulativeSuccessfulConnectionWaitTime() {
        return this.connectionPool.getStatistics().getCumulativeSuccessfulConnectionWaitTime();
    }

    @Override
    public long getCumulativeSuccessfulConnectionWaitCount() {
        return this.connectionPool.getStatistics().getCumulativeSuccessfulConnectionWaitCount();
    }

    @Override
    public long getCumulativeFailedConnectionWaitTime() {
        return this.connectionPool.getStatistics().getCumulativeFailedConnectionWaitTime();
    }

    @Override
    public long getCumulativeFailedConnectionWaitCount() {
        return this.connectionPool.getStatistics().getCumulativeFailedConnectionWaitCount();
    }

    @Override
    public long getSuccessfulAffinityBasedBorrowCount() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public long getFailedAffinityBasedBorrowCount() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public long getSuccessfulRCLBBasedBorrowCount() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public long getFailedRCLBBasedBorrowCount() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public String getFcfProcessingInfo() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public String getFcfProcessingInfoProcessedOnly() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public long getConnectionRepurposeCount() {
        throw new IllegalStateException("should be overridden");
    }

    @Override
    public boolean getTraceEnabled() {
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        return collector.getTraceEnabled();
    }

    @Override
    public void setTraceEnabled(boolean enabled) {
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        collector.setTraceEnabled(enabled);
    }

    @Override
    public boolean getLoggingEnabled() {
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        return collector.getLoggingEnabled();
    }

    @Override
    public void setLoggingEnabled(boolean enabled) {
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        collector.setLoggingEnabled(enabled);
    }

    @Override
    public Level getLogLevel() {
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        return collector.getLogLevel();
    }

    @Override
    public String getLogLevelStr() {
        return this.getLogLevel().getName();
    }

    @Override
    public void setLogLevel(Level level) {
        if (null == level) {
            throw new IllegalArgumentException("level is null");
        }
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        collector.setLogLevel(level);
    }

    @Override
    public void setLogLevelStr(String level) {
        if (null == level) {
            throw new IllegalArgumentException("level is null");
        }
        this.setLogLevel(Level.parse(level));
    }

    @Override
    public int getBufferSize() {
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        return collector.getBufferSize();
    }

    @Override
    public void setBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("wrong size");
        }
        DiagnosticsCollector collector = (DiagnosticsCollector)this.connectionPool.getDiagnosable();
        collector.setBufferSize(size);
    }

    @Override
    public ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanDisplayName) throws UniversalConnectionPoolException {
        this.trace(Level.FINEST, CLASS_NAME, "getMBeanInfo", "constructing MBeanInfo", null, null, new Object[0]);
        if (mbeanObjName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(381);
        }
        if (mbeanDisplayName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(382);
        }
        ModelMBeanInfoSupport modelMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanName = "oracle.ucp.admin.UniversalConnectionPoolMBean";
            String mbeanDescription = "UniversalConnectionPoolMBean Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + mbeanObjName, "descriptorType=" + descriptorType, "displayName=" + mbeanDisplayName);
            modelMBeanInfo = new ModelMBeanInfoSupport(mbeanName, mbeanDescription, this.getUCPMBeanAttributes(), UniversalConnectionPoolMBeanBase.getConstructorsInfo(), this.getUCPMBeanOperations(), UniversalConnectionPoolMBeanBase.getNotificationsInfo());
            modelMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(374, e);
        }
        catch (MBeanException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(373, e);
        }
        return modelMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] constInfo = new ModelMBeanConstructorInfo[]{};
        return constInfo;
    }

    @Override
    public ModelMBeanAttributeInfo[] getUCPMBeanAttributes() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanAttributeInfo> attributes = new ArrayList<ModelMBeanAttributeInfo>();
        this.trace(Level.FINEST, CLASS_NAME, "getUCPMBeanAttributes", "constructing AttributesInfo", null, null, new Object[0]);
        try {
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "poolName");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PoolNameAttrDisplayName"));
            desc.setField("getMethod", "getName");
            desc.setField("setMethod", "setName");
            attributes.add(new ModelMBeanAttributeInfo("poolName", "java.lang.String", UCPErrorHandler.findMessage("PoolNameAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "initialPoolSize");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("InitialPoolSizeAttrDisplayName"));
            desc.setField("getMethod", "getInitialPoolSize");
            desc.setField("setMethod", "setInitialPoolSize");
            attributes.add(new ModelMBeanAttributeInfo("initialPoolSize", "int", UCPErrorHandler.findMessage("InitialPoolSizeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "minPoolSize");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MinPoolSizeAttrDisplayName"));
            desc.setField("getMethod", "getMinPoolSize");
            desc.setField("setMethod", "setMinPoolSize");
            attributes.add(new ModelMBeanAttributeInfo("minPoolSize", "int", UCPErrorHandler.findMessage("MinPoolSizeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxPoolSize");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxPoolSizeAttrDisplayName"));
            desc.setField("getMethod", "getMaxPoolSize");
            desc.setField("setMethod", "setMaxPoolSize");
            attributes.add(new ModelMBeanAttributeInfo("maxPoolSize", "int", UCPErrorHandler.findMessage("MaxPoolSizeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "inactiveConnectionTimeout");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("InactiveConnectionTimeoutAttrDisplayName"));
            desc.setField("getMethod", "getInactiveConnectionTimeout");
            desc.setField("setMethod", "setInactiveConnectionTimeout");
            attributes.add(new ModelMBeanAttributeInfo("inactiveConnectionTimeout", "int", UCPErrorHandler.findMessage("InactiveConnectionTimeoutAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "abandonedConnectionTimeout");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("AbandonedConnectionTimeoutAttrDisplayName"));
            desc.setField("getMethod", "getAbandonedConnectionTimeout");
            desc.setField("setMethod", "setAbandonedConnectionTimeout");
            attributes.add(new ModelMBeanAttributeInfo("abandonedConnectionTimeout", "int", UCPErrorHandler.findMessage("AbandonedConnectionTimeoutAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionWaitTimeout");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionWaitTimeoutAttrDisplayName"));
            desc.setField("getMethod", "getConnectionWaitTimeout");
            desc.setField("setMethod", "setConnectionWaitTimeout");
            attributes.add(new ModelMBeanAttributeInfo("connectionWaitTimeout", "int", UCPErrorHandler.findMessage("ConnectionWaitTimeoutAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "timeToLiveConnectionTimeout");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("TimeToLiveConnectionTimeoutAttrDisplayName"));
            desc.setField("getMethod", "getTimeToLiveConnectionTimeout");
            desc.setField("setMethod", "setTimeToLiveConnectionTimeout");
            attributes.add(new ModelMBeanAttributeInfo("timeToLiveConnectionTimeout", "int", UCPErrorHandler.findMessage("TimeToLiveConnectionTimeoutAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "timeoutCheckInterval");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("TimeoutCheckIntervalAttrDisplayName"));
            desc.setField("getMethod", "getTimeoutCheckInterval");
            desc.setField("setMethod", "setTimeoutCheckInterval");
            attributes.add(new ModelMBeanAttributeInfo("timeoutCheckInterval", "int", UCPErrorHandler.findMessage("TimeoutCheckIntervalAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "validateConnectionOnBorrow");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ValidateConnectionOnBorrowAttrDisplayName"));
            desc.setField("getMethod", "getValidateConnectionOnBorrow");
            desc.setField("setMethod", "setValidateConnectionOnBorrow");
            attributes.add(new ModelMBeanAttributeInfo("validateConnectionOnBorrow", "boolean", UCPErrorHandler.findMessage("ValidateConnectionOnBorrowAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "shardingMode");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ShardingModeAttrDisplayName"));
            desc.setField("getMethod", "getShardingMode");
            desc.setField("setMethod", "setShardingMode");
            attributes.add(new ModelMBeanAttributeInfo("shardingMode", "boolean", UCPErrorHandler.findMessage("ShardingModeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "readOnlyInstanceAllowed");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ReadOnlyInstanceAllowedAttrDisplayName"));
            desc.setField("getMethod", "isReadOnlyInstanceAllowed");
            desc.setField("setMethod", "setReadOnlyInstanceAllowed");
            attributes.add(new ModelMBeanAttributeInfo("readOnlyInstanceAllowed", "boolean", UCPErrorHandler.findMessage("ReadOnlyInstanceAllowedAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionValidationTimeout");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionValidationTimeoutAttrDisplayName"));
            desc.setField("getMethod", "getConnectionValidationTimeout");
            desc.setField("setMethod", "setConnectionValidationTimeout");
            attributes.add(new ModelMBeanAttributeInfo("connectionValidationTimeout", "int", UCPErrorHandler.findMessage("ConnectionValidationTimeoutAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionHarvestTriggerCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionHarvestTriggerCountAttrDisplayName"));
            desc.setField("getMethod", "getConnectionHarvestTriggerCount");
            desc.setField("setMethod", "setConnectionHarvestTriggerCount");
            attributes.add(new ModelMBeanAttributeInfo("connectionHarvestTriggerCount", "int", UCPErrorHandler.findMessage("ConnectionHarvestTriggerCountAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionHarvestMaxCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionHarvestMaxCountAttrDisplayName"));
            desc.setField("getMethod", "getConnectionHarvestMaxCount");
            desc.setField("setMethod", "setConnectionHarvestMaxCount");
            attributes.add(new ModelMBeanAttributeInfo("connectionHarvestMaxCount", "int", UCPErrorHandler.findMessage("ConnectionHarvestMaxCountAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "availableConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("AvailableConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getAvailableConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("availableConnectionsCount", "int", UCPErrorHandler.findMessage("AvailableConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "borrowedConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("BorrowedConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getBorrowedConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("borrowedConnectionsCount", "int", UCPErrorHandler.findMessage("BorrowedConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxConnectionReuseTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxConnectionReuseTimeAttrDisplayName"));
            desc.setField("getMethod", "getMaxConnectionReuseTime");
            desc.setField("setMethod", "setMaxConnectionReuseTime");
            attributes.add(new ModelMBeanAttributeInfo("maxConnectionReuseTime", "long", UCPErrorHandler.findMessage("MaxConnectionReuseTimeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxConnectionReuseCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxConnectionReuseCountAttrDisplayName"));
            desc.setField("getMethod", "getMaxConnectionReuseCount");
            desc.setField("setMethod", "setMaxConnectionReuseCount");
            attributes.add(new ModelMBeanAttributeInfo("maxConnectionReuseCount", "int", UCPErrorHandler.findMessage("MaxConnectionReuseCountAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "secondsToTrustIdleConnection");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SecondsToTrustIdleConnectionAttrDisplayName"));
            desc.setField("getMethod", "getSecondsToTrustIdleConnection");
            desc.setField("setMethod", "setSecondsToTrustIdleConnection");
            attributes.add(new ModelMBeanAttributeInfo("secondsToTrustIdleConnection", "int", UCPErrorHandler.findMessage("SecondsToTrustIdleConnectionAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "totalConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("TotalConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getTotalConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("totalConnectionsCount", "int", UCPErrorHandler.findMessage("TotalConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "averageBorrowedConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("AverageBorrowedConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getAverageBorrowedConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("averageBorrowedConnectionsCount", "int", UCPErrorHandler.findMessage("AverageBorrowedConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "peakConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PeakConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getPeakConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("peakConnectionsCount", "int", UCPErrorHandler.findMessage("PeakConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "peakBorrowedConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PeakBorrowedConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getPeakBorrowedConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("peakBorrowedConnectionsCount", "int", UCPErrorHandler.findMessage("PeakBorrowedConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "remainingPoolCapacityCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("RemainingPoolCapacityCountAttrDisplayName"));
            desc.setField("getMethod", "getRemainingPoolCapacityCount");
            attributes.add(new ModelMBeanAttributeInfo("remainingPoolCapacityCount", "int", UCPErrorHandler.findMessage("RemainingPoolCapacityCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "labeledConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LabeledConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getLabeledConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("labeledConnectionsCount", "int", UCPErrorHandler.findMessage("LabeledConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionsCreatedCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionsCreatedCountAttrDisplayName"));
            desc.setField("getMethod", "getConnectionsCreatedCount");
            attributes.add(new ModelMBeanAttributeInfo("connectionsCreatedCount", "int", UCPErrorHandler.findMessage("ConnectionsCreatedCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionsClosedCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionsClosedCountAttrDisplayName"));
            desc.setField("getMethod", "getConnectionsClosedCount");
            attributes.add(new ModelMBeanAttributeInfo("connectionsClosedCount", "int", UCPErrorHandler.findMessage("ConnectionsClosedCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "averageConnectionWaitTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("AverageConnectionWaitTimeAttrDisplayName"));
            desc.setField("getMethod", "getAverageConnectionWaitTime");
            attributes.add(new ModelMBeanAttributeInfo("averageConnectionWaitTime", "long", UCPErrorHandler.findMessage("AverageConnectionWaitTimeAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "peakConnectionWaitTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PeakConnectionWaitTimeAttrDisplayName"));
            desc.setField("getMethod", "getPeakConnectionWaitTime");
            attributes.add(new ModelMBeanAttributeInfo("peakConnectionWaitTime", "long", UCPErrorHandler.findMessage("PeakConnectionWaitTimeAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "abandonedConnectionsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("AbandonedConnectionsCountAttrDisplayName"));
            desc.setField("getMethod", "getAbandonedConnectionsCount");
            attributes.add(new ModelMBeanAttributeInfo("abandonedConnectionsCount", "int", UCPErrorHandler.findMessage("AbandonedConnectionsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "pendingRequestsCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PendingRequestsCountAttrDisplayName"));
            desc.setField("getMethod", "getPendingRequestsCount");
            attributes.add(new ModelMBeanAttributeInfo("pendingRequestsCount", "int", UCPErrorHandler.findMessage("PendingRequestsCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeConnectionWaitTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeConnectionWaitTimeAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeConnectionWaitTime");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeConnectionWaitTime", "long", UCPErrorHandler.findMessage("CumulativeConnectionWaitTimeAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeConnectionBorrowedCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeConnectionBorrowedCountAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeConnectionBorrowedCount");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeConnectionBorrowedCount", "long", UCPErrorHandler.findMessage("CumulativeConnectionBorrowedCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeConnectionUseTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeConnectionUseTimeAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeConnectionUseTime");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeConnectionUseTime", "long", UCPErrorHandler.findMessage("CumulativeConnectionUseTimeAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeConnectionReturnedCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeConnectionReturnedCountAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeConnectionReturnedCount");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeConnectionReturnedCount", "long", UCPErrorHandler.findMessage("CumulativeConnectionReturnedCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeSuccessfulConnectionWaitTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeSuccessfulConnectionWaitTimeAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeSuccessfulConnectionWaitTime");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeSuccessfulConnectionWaitTime", "long", UCPErrorHandler.findMessage("CumulativeSuccessfulConnectionWaitTimeAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeSuccessfulConnectionWaitCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeSuccessfulConnectionWaitCountAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeSuccessfulConnectionWaitCount");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeSuccessfulConnectionWaitCount", "long", UCPErrorHandler.findMessage("CumulativeSuccessfulConnectionWaitCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeFailedConnectionWaitTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeFailedConnectionWaitTimeAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeFailedConnectionWaitTime");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeFailedConnectionWaitTime", "long", UCPErrorHandler.findMessage("CumulativeFailedConnectionWaitTimeAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "cumulativeFailedConnectionWaitCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("CumulativeFailedConnectionWaitCountAttrDisplayName"));
            desc.setField("getMethod", "getCumulativeFailedConnectionWaitCount");
            attributes.add(new ModelMBeanAttributeInfo("cumulativeFailedConnectionWaitCount", "long", UCPErrorHandler.findMessage("CumulativeFailedConnectionWaitCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "traceEnabled");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("TraceEnabledAttrDisplayName"));
            desc.setField("getMethod", "getTraceEnabled");
            desc.setField("setMethod", "setTraceEnabled");
            attributes.add(new ModelMBeanAttributeInfo("traceEnabled", "boolean", UCPErrorHandler.findMessage("TraceEnabledAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "loggingEnabled");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LoggingEnabledAttrDisplayName"));
            desc.setField("getMethod", "getLoggingEnabled");
            desc.setField("setMethod", "setLoggingEnabled");
            attributes.add(new ModelMBeanAttributeInfo("loggingEnabled", "boolean", UCPErrorHandler.findMessage("LoggingEnabledAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "logLevelStr");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LogLevelAttrDisplayName"));
            desc.setField("getMethod", "getLogLevelStr");
            desc.setField("setMethod", "setLogLevelStr");
            attributes.add(new ModelMBeanAttributeInfo("logLevelStr", "java.lang.String", UCPErrorHandler.findMessage("LogLevelAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "logLevel");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("LogLevelAttrDisplayName"));
            desc.setField("getMethod", "getLogLevel");
            desc.setField("setMethod", "setLogLevel");
            attributes.add(new ModelMBeanAttributeInfo("logLevel", "java.util.logging.Level", UCPErrorHandler.findMessage("LogLevelAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "bufferSize");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("BufferSizeAttrDisplayName"));
            desc.setField("getMethod", "getBufferSize");
            desc.setField("setMethod", "setBufferSize");
            attributes.add(new ModelMBeanAttributeInfo("bufferSize", "int", UCPErrorHandler.findMessage("BufferSizeAttrDescription"), true, true, false, desc));
        }
        catch (RuntimeOperationsException ex) {
            UCPErrorHandler.throwUniversalConnectionPoolException(371, ex);
        }
        return attributes.toArray(new ModelMBeanAttributeInfo[0]);
    }

    @Override
    public ModelMBeanOperationInfo[] getUCPMBeanOperations() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        this.trace(Level.FINEST, CLASS_NAME, "getUCPMBeanOperations", "constructing OperationsInfo", null, null, new Object[0]);
        try {
            String mBeanName = "oracle.ucp.admin.UniversalConnectionPoolMBean";
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "start");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("start", UCPErrorHandler.findMessage("StartOperationDescription"), null, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "stop");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("stop", UCPErrorHandler.findMessage("StopOperationDescription"), null, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "refresh");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("refresh", UCPErrorHandler.findMessage("RefreshOperationDescription"), null, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "recycle");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("recycle", UCPErrorHandler.findMessage("RecycleOperationDescription"), null, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "purge");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("purge", UCPErrorHandler.findMessage("PurgeOperationDescription"), null, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getName");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getName", UCPErrorHandler.findMessage("GetNameOperationDescription"), null, "String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setName");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            String sDesc = UCPErrorHandler.findMessage("SetNameOperationDescription");
            MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("poolName", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setName", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getInitialPoolSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getInitialPoolSize", UCPErrorHandler.findMessage("GetInitialPoolSizeOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setInitialPoolSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetInitialPoolSizeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("initialPoolSize", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setInitialPoolSize", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMinPoolSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMinPoolSize", UCPErrorHandler.findMessage("GetMinPoolSizeOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMinPoolSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMinPoolSizeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("minPoolSize", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMinPoolSize", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxPoolSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxPoolSize", UCPErrorHandler.findMessage("GetMaxPoolSizeOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxPoolSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxPoolSizeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxPoolSize", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxPoolSize", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getInactiveConnectionTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getInactiveConnectionTimeout", UCPErrorHandler.findMessage("GetInactiveConnectionTimeoutOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setInactiveConnectionTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetInactiveConnectionTimeoutOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("inactiveConnectionTimeout", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setInactiveConnectionTimeout", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getAbandonedConnectionTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getAbandonedConnectionTimeout", UCPErrorHandler.findMessage("GetAbandonedConnectionTimeoutOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setAbandonedConnectionTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetAbandonedConnectionTimeoutOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("abandonedConnectionTimeout", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setAbandonedConnectionTimeout", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionWaitTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionWaitTimeout", UCPErrorHandler.findMessage("GetConnectionWaitTimeoutOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setConnectionWaitTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetConnectionWaitTimeoutOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionWaitTimeout", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setConnectionWaitTimeout", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getTimeToLiveConnectionTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getTimeToLiveConnectionTimeout", UCPErrorHandler.findMessage("GetTimeToLiveConnectionTimeoutOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setTimeToLiveConnectionTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetTimeToLiveConnectionTimeoutOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("timeToLiveConnectionTimeout", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setTimeToLiveConnectionTimeout", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getTimeoutCheckInterval");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getTimeoutCheckInterval", UCPErrorHandler.findMessage("GetTimeoutCheckIntervalOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setTimeoutCheckInterval");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetTimeoutCheckIntervalOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("timeoutCheckInterval", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setTimeoutCheckInterval", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getValidateConnectionOnBorrow");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getValidateConnectionOnBorrow", UCPErrorHandler.findMessage("GetValidateConnectionOnBorrowOperationDescription"), null, "boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setValidateConnectionOnBorrow");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetValidateConnectionOnBorrowOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("validateConnectionOnBorrow", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setValidateConnectionOnBorrow", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getShardingMode");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getShardingMode", UCPErrorHandler.findMessage("GetShardingModeOperationDescription"), null, "boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setShardingMode");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetShardingModeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("shardingMode", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setShardingMode", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "isReadOnlyInstanceAllowed");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("isReadOnlyInstanceAllowed", UCPErrorHandler.findMessage("IsReadOnlyInstanceAllowedOperationDescription"), null, "boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setReadOnlyInstanceAllowed");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetReadOnlyInstanceAllowedOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("readOnlyInstanceAllowed", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setReadOnlyInstanceAllowed", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionValidationTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionValidationTimeout", UCPErrorHandler.findMessage("GetConnectionValidationTimeoutOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setConnectionValidationTimeout");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetConnectionValidationTimeoutOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionValidationTimeout", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setConnectionValidationTimeout", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionHarvestTriggerCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionHarvestTriggerCount", UCPErrorHandler.findMessage("GetConnectionHarvestTriggerCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setConnectionHarvestTriggerCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetConnectionHarvestTriggerCountOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionHarvestTriggerCount", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setConnectionHarvestTriggerCount", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionHarvestMaxCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionHarvestMaxCount", UCPErrorHandler.findMessage("GetConnectionHarvestMaxCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setConnectionHarvestMaxCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetConnectionHarvestMaxCountOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionHarvestMaxCount", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setConnectionHarvestMaxCount", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getAvailableConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getAvailableConnectionsCount", UCPErrorHandler.findMessage("GetAvailableConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getBorrowedConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getBorrowedConnectionsCount", UCPErrorHandler.findMessage("GetBorrowedConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getStatistics");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("getStatistics", UCPErrorHandler.findMessage("GetStatisticsOperationDescription"), null, "String", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLifeCycleState");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            operations.add(new ModelMBeanOperationInfo("getLifeCycleState", UCPErrorHandler.findMessage("GetLifeCycleStateOperationDescription"), null, "String", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxConnectionReuseTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxConnectionReuseTime", UCPErrorHandler.findMessage("GetMaxConnectionReuseTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxConnectionReuseTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxConnectionReuseTimeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxConnectionReuseTime", "java.lang.Long", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxConnectionReuseTime", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxConnectionReuseCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxConnectionReuseCount", UCPErrorHandler.findMessage("GetMaxConnectionReuseCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxConnectionReuseCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxConnectionReuseCountOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxConnectionReuseCount", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxConnectionReuseCount", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "useStrictWebSessionAffinity");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            sDesc = UCPErrorHandler.findMessage("UseStrictWebSessionAffinityOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("strict", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("useStrictWebSessionAffinity", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "useStrictXAAffinity");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "operation");
            sDesc = UCPErrorHandler.findMessage("UseStrictXAAffinityOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("strict", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("useStrictXAAffinity", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getSecondsToTrustIdleConnection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSecondsToTrustIdleConnection", UCPErrorHandler.findMessage("GetSecondsToTrustIdleConnectionOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setSecondsToTrustIdleConnection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetSecondsToTrustIdleConnectionOperation");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("secondsToTrustIdleConnection", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setSecondsToTrustIdleConnection", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getTotalConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getTotalConnectionsCount", UCPErrorHandler.findMessage("GetTotalConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getShardConnectionStats");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getShardConnectionStats", UCPErrorHandler.findMessage("GetShardConnectionStatsOperationDescription"), null, "String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getAverageBorrowedConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getAverageBorrowedConnectionsCount", UCPErrorHandler.findMessage("GetAverageBorrowedConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getPeakConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getPeakConnectionsCount", UCPErrorHandler.findMessage("GetPeakConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getPeakBorrowedConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getPeakBorrowedConnectionsCount", UCPErrorHandler.findMessage("GetPeakBorrowedConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getRemainingPoolCapacityCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getRemainingPoolCapacityCount", UCPErrorHandler.findMessage("GetRemainingPoolCapacityCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLabeledConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLabeledConnectionsCount", UCPErrorHandler.findMessage("GetLabeledConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionsCreatedCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionsCreatedCount", UCPErrorHandler.findMessage("GetConnectionsCreatedCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionsClosedCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionsClosedCount", UCPErrorHandler.findMessage("GetConnectionsClosedCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getAverageConnectionWaitTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getAverageConnectionWaitTime", UCPErrorHandler.findMessage("GetAverageConnectionWaitTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getPeakConnectionWaitTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getPeakConnectionWaitTime", UCPErrorHandler.findMessage("GetPeakConnectionWaitTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getAbandonedConnectionsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getAbandonedConnectionsCount", UCPErrorHandler.findMessage("GetAbandonedConnectionsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getPendingRequestsCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getPendingRequestsCount", UCPErrorHandler.findMessage("GetPendingRequestsCountOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeConnectionWaitTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeConnectionWaitTime", UCPErrorHandler.findMessage("GetCumulativeConnectionWaitTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeConnectionBorrowedCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeConnectionBorrowedCount", UCPErrorHandler.findMessage("GetCumulativeConnectionBorrowedCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeConnectionUseTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeConnectionUseTime", UCPErrorHandler.findMessage("GetCumulativeConnectionUseTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeConnectionReturnedCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeConnectionReturnedCount", UCPErrorHandler.findMessage("GetCumulativeConnectionReturnedCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeSuccessfulConnectionWaitTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeSuccessfulConnectionWaitTime", UCPErrorHandler.findMessage("GetCumulativeSuccessfulConnectionWaitTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeSuccessfulConnectionWaitCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeSuccessfulConnectionWaitCount", UCPErrorHandler.findMessage("GetCumulativeSuccessfulConnectionWaitCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeFailedConnectionWaitTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeFailedConnectionWaitTime", UCPErrorHandler.findMessage("GetCumulativeFailedConnectionWaitTimeOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getCumulativeFailedConnectionWaitCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getCumulativeFailedConnectionWaitCount", UCPErrorHandler.findMessage("GetCumulativeFailedConnectionWaitCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getTraceEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getTraceEnabled", UCPErrorHandler.findMessage("GetTraceEnabledOperationDescription"), null, "boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setTraceEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetTraceEnabledOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("traceEnabled", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setTraceEnabled", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLoggingEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLoggingEnabled", UCPErrorHandler.findMessage("GetLoggingEnabledOperationDescription"), null, "boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLoggingEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLoggingEnabledOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("loggingEnabled", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLoggingEnabled", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLogLevelStr");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLogLevelStr", UCPErrorHandler.findMessage("GetLogLevelOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLogLevelStr");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLogLevelOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("logLevel", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLogLevelStr", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getLogLevel");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getLogLevel", UCPErrorHandler.findMessage("GetLogLevelOperationDescription"), null, "java.util.logging.Level", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setLogLevel");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetLogLevelOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("logLevel", "java.util.logging.Level", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setLogLevel", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getBufferSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getBufferSize", UCPErrorHandler.findMessage("GetBufferSizeOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setBufferSize");
            desc.setField("descriptorType", "operation");
            desc.setField("class", mBeanName);
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetBufferSizeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("BufferSize", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setBufferSize", sDesc, params, "void", 1, desc));
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(372, e);
        }
        return operations.toArray(new ModelMBeanOperationInfo[0]);
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() throws UniversalConnectionPoolException {
        ModelMBeanNotificationInfo[] notifInfo = new ModelMBeanNotificationInfo[]{};
        return notifInfo;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.connectionPool.getDiagnosable();
    }
}

