/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui;

import com.dbeaver.ee.qm.db.impl.EmbeddedDatabase;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qmdb.ui.QMDBUIMessages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.ContentUtils;

public class QMDBPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(QMDBPreferencePage.class);
    public static final String PAGE_ID = "com.dbeaver.ee.qmdb.persistence";
    private IAdaptable element;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        final EmbeddedDatabase database = DBWorkbench.getPlatform().getApplication().isPrimaryInstance() && !DBWorkbench.isDistributed() ? QMDBModel.getInstance().getEmbeddedDatabase() : null;
        Group composite = UIUtils.createControlGroup((Composite)parent, (String)QMDBUIMessages.preference_page_group_database, (int)2, (int)768, (int)0);
        UIUtils.createLabelText((Composite)composite, (String)QMDBUIMessages.preference_page_label_text_database_path, (String)(database == null ? "N/A" : database.getDatabasePath().toAbsolutePath().toString()), (int)2056, (Object)new GridData(768));
        Composite buttonsGroup = UIUtils.createComposite((Composite)composite, (int)1);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_backup_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.backupDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_repair_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.repairDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_truncate_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.truncateDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createInfoLabel((Composite)parent, (String)QMDBUIMessages.preference_page_info_label_h2_embedded_database);
        return composite;
    }

    private void backupDatabase(EmbeddedDatabase database) {
        File file = DialogUtils.selectFileForSave((Shell)this.getShell(), (String)"QMDB-backup.zip");
        if (file != null) {
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    monitor.beginTask("Backup QMDB database", 1);
                    try {
                        monitor.subTask(file.getAbsolutePath());
                        database.backupDatabase(file.toPath());
                        UIUtils.showMessageBox(null, (String)"Backup", (String)"Backup finished", (int)2);
                    }
                    catch (DBException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    monitor.done();
                });
            }
            catch (InvocationTargetException e1) {
                DBWorkbench.getPlatformUI().showError("QMDB backup", "Error making QMDB backup", (Throwable)e1);
            }
        }
    }

    private void repairDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Repair database", (String)"Database repair may corrupt it. You may loose all query history. Do it after database backup.\nAre you sure you want to proceed with database repair?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                monitor.beginTask("Repair QMDB database", 7);
                try {
                    monitor.subTask("Stop QMDB");
                    if (database.isRunning()) {
                        database.stop();
                    }
                    monitor.worked(1);
                    monitor.subTask("Dump SQL into " + database.getDatabasePath().toAbsolutePath().toString());
                    Path sqlDumpFile = database.dumpDatabaseToSQL();
                    monitor.worked(1);
                    monitor.subTask("Delete old QMDB files");
                    database.deleteDatabaseFiles();
                    monitor.worked(1);
                    monitor.subTask("Start QMDB");
                    database.start();
                    monitor.worked(1);
                    monitor.subTask("Restore from backup " + String.valueOf(sqlDumpFile.toAbsolutePath()));
                    database.restoreFromSQL(sqlDumpFile);
                    monitor.worked(1);
                    monitor.subTask("Delete backup file");
                    try {
                        Files.delete(sqlDumpFile);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error deleting dump file", (Throwable)e);
                    }
                    monitor.worked(1);
                    try {
                        monitor.subTask("Validate schema");
                        QMDBModel.getInstance().initializeSchema();
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Invalid schema", "Cannot initialize QMDB schema", (Throwable)e);
                    }
                    UIUtils.showMessageBox(null, (String)"Repair", (String)"Repair finished", (int)2);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB repair", "Error repairing QMDB database", (Throwable)e1);
        }
    }

    private void truncateDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Truncate database", (String)"Database truncate will erase all historic SQL queries.\nAre you sure you want to proceed with truncate?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                Path backupFile = database.getDatabasePath().getParent().resolve("qmdb-backup-auto.zip");
                if (Files.exists(backupFile, new LinkOption[0])) {
                    try {
                        Files.delete(backupFile);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error deleting backup file " + String.valueOf(backupFile)), (Throwable)e);
                    }
                }
                monitor.beginTask("Truncate QMDB database", 6);
                try {
                    monitor.subTask("Make backup to " + String.valueOf(backupFile.toAbsolutePath()));
                    database.backupDatabase(backupFile);
                    monitor.worked(1);
                    monitor.subTask("Stop QMDB");
                    database.stop();
                    monitor.worked(1);
                    monitor.subTask("Delete old QMDB files");
                    ContentUtils.deleteFileRecursive((File)database.getDatabasePath().toFile());
                    monitor.worked(1);
                    monitor.subTask("Restore from backup " + String.valueOf(backupFile.toAbsolutePath()));
                    database.restoreDatabase(backupFile);
                    monitor.worked(1);
                    monitor.subTask("Start QMDB");
                    database.start();
                    monitor.worked(1);
                    monitor.subTask("Delete backup file");
                    try {
                        Files.delete(backupFile);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error deleting backup file " + String.valueOf(backupFile)), (Throwable)e);
                    }
                    monitor.worked(1);
                    UIUtils.showMessageBox(null, (String)"Truncate", (String)"Truncate finished", (int)2);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB truncate", "Error truncating QMDB database", (Throwable)e1);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        return true;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

