/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.preferences;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.AIFormatterRegistry;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.format.DefaultRequestFormatter;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.format.DefaultFormattingConfigurator;
import org.jkiss.dbeaver.ui.editors.sql.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class AIPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private static final Log log = Log.getLog(AIPreferencePage.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.ai";
    private final AISettings settings;
    private DAICompletionEngine<?> completionEngine;
    private IAIFormatter formatter;
    private IObjectPropertyConfigurator<IAIFormatter, AISettings> formatterConfigurator;
    private Combo serviceCombo;
    private final Map<String, String> serviceNameMappings = new HashMap<String, String>();
    private final Map<String, EngineConfiguratorPage> engineConfiguratorMapping = new HashMap<String, EngineConfiguratorPage>();
    EngineConfiguratorPage activeEngineConfiguratorPage;
    private Button enableAICheck;

    public AIPreferencePage() {
        try {
            this.formatter = AIFormatterRegistry.getInstance().getFormatter("core");
        }
        catch (DBException e) {
            log.error((Object)"Formatter not found", (Throwable)e);
            this.formatter = new DefaultRequestFormatter();
        }
        UIPropertyConfiguratorDescriptor cfgDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.formatter.getClass().getName());
        if (cfgDescriptor != null) {
            try {
                this.formatterConfigurator = cfgDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.formatterConfigurator == null) {
            this.formatterConfigurator = new DefaultFormattingConfigurator();
        }
        this.settings = AISettingsRegistry.getInstance().getSettings();
        String activeEngine = this.settings.getActiveEngine();
        try {
            this.completionEngine = AIEngineRegistry.getInstance().getCompletionEngine(activeEngine);
        }
        catch (DBException dBException) {
            log.error((Object)"Error getting engine configuration");
        }
    }

    @Nullable
    private IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> createEngineConfigurator() {
        UIPropertyConfiguratorDescriptor engineDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.completionEngine.getClass().getName());
        if (engineDescriptor != null) {
            try {
                return engineDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    protected void performDefaults() {
        if (!this.hasAccessToPage()) {
            return;
        }
        this.enableAICheck.setSelection(!this.settings.isAiDisabled());
        this.formatterConfigurator.loadSettings((Object)this.settings);
    }

    public boolean performOk() {
        if (!this.hasAccessToPage()) {
            return false;
        }
        this.settings.setAiDisabled(!this.enableAICheck.getSelection());
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.settings.setActiveEngine(this.serviceNameMappings.get(this.serviceCombo.getText()));
        if (!this.serviceCombo.getText().isEmpty()) {
            for (Map.Entry<String, EngineConfiguratorPage> entry : this.engineConfiguratorMapping.entrySet()) {
                AIEngineSettings engineConfiguration = this.settings.getEngineConfiguration(entry.getKey());
                entry.getValue().saveSettings(engineConfiguration);
            }
        }
        this.formatterConfigurator.saveSettings((Object)this.settings);
        AISettingsRegistry.getInstance().saveSettings(this.settings);
        try {
            store.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        for (AIEngineRegistry.EngineDescriptor engine : AIEngineRegistry.getInstance().getCompletionEngines()) {
            try {
                engine.createInstance().getServiceMap().clear();
            }
            catch (DBException dBException) {
                log.error((Object)"Error clearing existing services");
            }
        }
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(final @NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        this.enableAICheck = UIUtils.createCheckbox((Composite)composite, (String)AIUIMessages.gpt_preference_page_checkbox_enable_ai_label, (String)AIUIMessages.gpt_preference_page_checkbox_enable_ai_tip, (boolean)false, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        this.formatterConfigurator.createControl(composite, (Object)this.formatter, () -> {});
        Composite serviceComposite = UIUtils.createComposite((Composite)composite, (int)2);
        serviceComposite.setLayoutData((Object)new GridData(32));
        this.serviceCombo = UIUtils.createLabelCombo((Composite)serviceComposite, (String)"Service", (int)12);
        List completionEngines = AIEngineRegistry.getInstance().getCompletionEngines();
        int defaultEngineSelection = -1;
        int i = 0;
        while (i < completionEngines.size()) {
            this.serviceCombo.add(((AIEngineRegistry.EngineDescriptor)completionEngines.get(i)).getLabel());
            this.serviceNameMappings.put(((AIEngineRegistry.EngineDescriptor)completionEngines.get(i)).getLabel(), ((AIEngineRegistry.EngineDescriptor)completionEngines.get(i)).getId());
            if (((AIEngineRegistry.EngineDescriptor)completionEngines.get(i)).isDefault()) {
                defaultEngineSelection = i;
            }
            if (((AIEngineRegistry.EngineDescriptor)completionEngines.get(i)).getId().equals(this.settings.getActiveEngine())) {
                this.serviceCombo.select(i);
            }
            ++i;
        }
        if (this.serviceCombo.getSelectionIndex() == -1 && defaultEngineSelection != -1) {
            this.serviceCombo.select(defaultEngineSelection);
        }
        final Group engineGroup = UIUtils.createControlGroup((Composite)composite, (String)"Engine Settings", (int)2, (int)2048, (int)5);
        engineGroup.setLayoutData((Object)new GridData(1808));
        if (this.completionEngine != null) {
            this.drawConfiguratorComposite(this.settings.getActiveEngine(), engineGroup);
        }
        this.serviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = AIPreferencePage.this.serviceNameMappings.get(AIPreferencePage.this.serviceCombo.getText());
                try {
                    AIPreferencePage.this.completionEngine = AIEngineRegistry.getInstance().getCompletionEngine(id);
                }
                catch (DBException dBException) {
                    log.error((Object)"Error getting engine configuration");
                    return;
                }
                if (AIPreferencePage.this.activeEngineConfiguratorPage != null) {
                    AIPreferencePage.this.activeEngineConfiguratorPage.disposeControl();
                }
                AIPreferencePage.this.drawConfiguratorComposite(id, engineGroup);
                engineGroup.layout(true, true);
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        this.performDefaults();
        return composite;
    }

    private void drawConfiguratorComposite(@NotNull String id, @NotNull Group engineGroup) {
        this.activeEngineConfiguratorPage = this.engineConfiguratorMapping.get(id);
        if (this.activeEngineConfiguratorPage == null) {
            IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> engineConfigurator = this.createEngineConfigurator();
            this.activeEngineConfiguratorPage = new EngineConfiguratorPage(engineConfigurator);
            this.activeEngineConfiguratorPage.createControl((Composite)engineGroup, this.completionEngine);
            this.activeEngineConfiguratorPage.loadSettings(this.settings.getEngineConfiguration(id));
            this.engineConfiguratorMapping.put(id, this.activeEngineConfiguratorPage);
        } else {
            this.activeEngineConfiguratorPage.createControl((Composite)engineGroup, this.completionEngine);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected boolean hasAccessToPage() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
    }

    private static class EngineConfiguratorPage {
        private final IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> configurator;
        private Composite composite;

        EngineConfiguratorPage(IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> configurator) {
            this.configurator = configurator;
        }

        private void createControl(Composite parent, DAICompletionEngine<?> engine) {
            this.composite = UIUtils.createComposite((Composite)parent, (int)1);
            this.composite.setLayoutData((Object)new GridData(768));
            this.configurator.createControl(this.composite, engine, () -> {});
        }

        private void disposeControl() {
            this.composite.dispose();
        }

        private void loadSettings(AIEngineSettings settings) {
            this.configurator.loadSettings((Object)settings);
        }

        private void saveSettings(AIEngineSettings settings) {
            this.configurator.saveSettings((Object)settings);
        }
    }
}

