/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.openai;

import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.openai.GPTModel;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.internal.AIUIMessages;
import org.jkiss.utils.CommonUtils;

public class OpenAiConfigurator
implements IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> {
    private static final String API_KEY_URL = "https://platform.openai.com/account/api-keys";
    private String token = "";
    private String temperature = "0.0";
    private String model = "";
    private boolean logQuery = false;
    private Text tokenText;
    private Text temperatureText;
    private Combo modelCombo;
    private Button logQueryCheck;

    public void createControl(@NotNull Composite parent, DAICompletionEngine<?> object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
        UIUtils.syncExec(this::applySettings);
    }

    private void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write GPT queries to debug log", (String)"Write GPT queries with metadata info in debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenAiConfigurator.this.logQuery = OpenAiConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    protected void createModelParameters(@NotNull Composite parent) {
        if (this.isUsesModel()) {
            this.modelCombo = UIUtils.createLabelCombo((Composite)parent, (String)AIUIMessages.gpt_preference_page_combo_engine, (int)8);
            GPTModel[] gPTModelArray = GPTModel.values();
            int n = gPTModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                GPTModel model = gPTModelArray[n2];
                if (model.getDeprecationReplacementModel() == null) {
                    this.modelCombo.add(model.getName());
                }
                ++n2;
            }
            this.modelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenAiConfigurator.this.model = OpenAiConfigurator.this.modelCombo.getText();
                }
            });
            UIUtils.createInfoLabel((Composite)parent, (String)AIUIMessages.gpt_preference_page_info_model, (int)768, (int)2);
        }
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        UIUtils.createInfoLabel((Composite)parent, (String)"Lower temperatures give more precise results", (int)768, (int)2);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
    }

    protected void createConnectionParameters(@NotNull Composite parent) {
        this.tokenText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        this.tokenText.setLayoutData((Object)new GridData(768));
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage("API access token");
        this.createURLInfoLink(parent);
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIMessages.gpt_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)OpenAiConfigurator.this.getApiKeyURL());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
    }

    protected String getApiKeyURL() {
        return API_KEY_URL;
    }

    public void loadSettings(@NotNull AIEngineSettings aiSettings) {
        this.token = CommonUtils.toString(aiSettings.getProperties().get("gpt.token"), (String)"");
        if (this.isUsesModel()) {
            this.model = CommonUtils.toString(aiSettings.getProperties().get("gpt.model"), (String)GPTModel.GPT_TURBO16.getName());
        }
        this.temperature = CommonUtils.toString(aiSettings.getProperties().get("gpt.model.temperature"), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean(aiSettings.getProperties().get("gpt.log.query"));
        this.applySettings();
    }

    protected void applySettings() {
        this.tokenText.setText(this.token);
        if (this.isUsesModel()) {
            this.modelCombo.setText(this.model);
        }
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    public void saveSettings(@NotNull AIEngineSettings aiSettings) {
        aiSettings.getProperties().put("gpt.token", this.token);
        if (this.isUsesModel()) {
            aiSettings.getProperties().put("gpt.model", this.model);
        }
        aiSettings.getProperties().put("gpt.model.temperature", this.temperature);
        aiSettings.getProperties().put("gpt.log.query", this.logQuery);
    }

    public void resetSettings(@NotNull AIEngineSettings aiSettings) {
    }

    protected boolean isUsesModel() {
        return true;
    }

    public boolean isComplete() {
        return !this.tokenText.getText().isEmpty();
    }
}

