/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.AIFormatterRegistry;
import org.jkiss.dbeaver.model.ai.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.MessageChunk;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionResponse;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSettings;
import org.jkiss.dbeaver.model.ai.translator.SimpleFilterManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryManager;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.ai.AIUIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.internal.AIFeatures;
import org.jkiss.dbeaver.ui.editors.sql.ai.popup.AISuggestionPopup;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class AITranslateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AISuggestionPopup aiCompletionPopup;
        DBCExecutionContext executionContext;
        DAICompletionEngine engine;
        AIFeatures.SQL_AI_POPUP.use();
        if (AISettingsRegistry.getInstance().getSettings().isAiDisabled()) {
            return null;
        }
        SQLEditor editor = (SQLEditor)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class);
        DBPDataSourceContainer dataSourceContainer = editor.getDataSourceContainer();
        if (dataSourceContainer == null) {
            DBWorkbench.getPlatformUI().showError("No datasource", "Connection must be associated with the SQL script");
            return null;
        }
        try {
            engine = AIEngineRegistry.getInstance().getCompletionEngine(AISettingsRegistry.getInstance().getSettings().getActiveEngine());
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("AI error", "Cannot determine AI engine", (Throwable)e);
            return null;
        }
        if (!engine.isValidConfiguration()) {
            UIUtils.showPreferencesFor((Shell)editor.getSite().getShell(), null, (String[])new String[]{"org.jkiss.dbeaver.preferences.ai"});
        }
        if ((executionContext = editor.getExecutionContext()) == null) {
            DBWorkbench.getPlatformUI().showError("No connection", "You must connect to the database before performing completion");
            return null;
        }
        DAICompletionSettings settings = new DAICompletionSettings(dataSourceContainer);
        if (!AIUIUtils.confirmMetaTransfer(settings, dataSourceContainer)) {
            return null;
        }
        QMTranslationHistoryManager historyManager = (QMTranslationHistoryManager)GeneralUtils.adapt(AISuggestionPopup.class, QMTranslationHistoryManager.class);
        if (historyManager == null) {
            historyManager = new SimpleFilterManager();
        }
        DBSLogicalDataSource lDataSource = new DBSLogicalDataSource(dataSourceContainer, "AI logical wrapper", null);
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        if (contextDefaults != null) {
            if (contextDefaults.getDefaultCatalog() != null) {
                lDataSource.setCurrentCatalog(contextDefaults.getDefaultCatalog().getName());
            }
            if (contextDefaults.getDefaultSchema() != null) {
                lDataSource.setCurrentSchema(contextDefaults.getDefaultSchema().getName());
            }
        }
        if ((aiCompletionPopup = new AISuggestionPopup(HandlerUtil.getActiveShell((ExecutionEvent)event), "AI smart completion", historyManager, lDataSource, executionContext, settings)).open() == 0) {
            try {
                engine = AIEngineRegistry.getInstance().getCompletionEngine(AISettingsRegistry.getInstance().getSettings().getActiveEngine());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("AI error", "Cannot determine AI engine", (Throwable)e);
                return null;
            }
            if (!engine.isValidConfiguration()) {
                DBWorkbench.getPlatformUI().showError("Bad AI engine configuration", "You must specify OpenAI API token in preferences");
                return null;
            }
            this.doAutoCompletion(executionContext, historyManager, lDataSource, editor, engine, aiCompletionPopup);
        }
        return null;
    }

    private void doAutoCompletion(final DBCExecutionContext executionContext, final QMTranslationHistoryManager historyManager, final DBSLogicalDataSource lDataSource, SQLEditor editor, @NotNull DAICompletionEngine<?> engine, @NotNull AISuggestionPopup popup) {
        final DAICompletionMessage message = new DAICompletionMessage(DAICompletionMessage.Role.USER, popup.getInputText());
        if (CommonUtils.isEmptyTrimmed((String)message.getContent())) {
            return;
        }
        ArrayList completionResult = new ArrayList();
        try {
            UIUtils.runInProgressDialog(monitor -> {
                DAICompletionContext context = new DAICompletionContext.Builder().setScope(popup.getScope()).setCustomEntities(popup.getCustomEntities(monitor)).setDataSource(lDataSource).setExecutionContext(executionContext).build();
                try {
                    completionResult.addAll(engine.performQueryCompletion(monitor, context, message, AIFormatterRegistry.getInstance().getFormatter("core")));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Auto completion error", null, e.getTargetException());
            return;
        }
        if (completionResult.isEmpty()) {
            DBWorkbench.getPlatformUI().showError("AI error", "No smart completions returned");
            return;
        }
        DAICompletionResponse response = (DAICompletionResponse)completionResult.get(0);
        MessageChunk[] messageChunks = AITextUtils.splitIntoChunks((String)CommonUtils.notEmpty((String)response.getResultCompletion()));
        if (messageChunks.length == 0) {
            return;
        }
        final String completion = AITextUtils.convertToSQL((DAICompletionMessage)message, (MessageChunk[])messageChunks, (DBPDataSource)executionContext.getDataSource());
        new AbstractJob("Save smart completion history"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    historyManager.saveTranslationHistory(monitor, lDataSource, executionContext, message.getContent(), completion);
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        ISelection selection = editor.getSelectionProvider().getSelection();
        IDocument document = editor.getDocument();
        if (document != null && selection instanceof TextSelection) {
            try {
                int offset = ((TextSelection)selection).getOffset();
                int length = ((TextSelection)selection).getLength();
                SQLScriptElement query = editor.extractQueryAtPos(offset);
                String text = completion;
                if (query != null) {
                    offset = query.getOffset();
                    length = query.getLength();
                    if (length > 0 && !query.getText().endsWith(";") && !text.isEmpty() && text.charAt(text.length() - 1) == ';') {
                        text = text.substring(0, text.length() - 1);
                    }
                }
                document.replace(offset, length, text);
                editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + text.length(), 0));
            }
            catch (BadLocationException e) {
                DBWorkbench.getPlatformUI().showError("Insert SQL", "Error inserting SQL completion in text editor", (Throwable)e);
            }
        }
        AIFeatures.SQL_AI_GENERATE_PROPOSALS.use(Map.of("driver", lDataSource.getDataSourceContainer().getDriver().getPreconfiguredId(), "engine", engine.getEngineName(), "scope", popup.getScope().name()));
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.executeImmediately")) {
            editor.processSQL(false, false);
        }
    }
}

