/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.format;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.internal.AIUIMessages;

public class DefaultFormattingConfigurator
implements IObjectPropertyConfigurator<IAIFormatter, AISettings> {
    private Button includeSourceTextInCommentCheck;
    private Button executeQueryImmediatelyCheck;
    private Button sendTypeInfoCheck;
    private Button sendDescriptionCheck;

    public void createControl(@NotNull Composite parent, IAIFormatter object, @NotNull Runnable propertyChangeListener) {
        Composite settingsPanel = UIUtils.createComposite((Composite)parent, (int)2);
        settingsPanel.setLayoutData((Object)new GridData(768));
        Composite completionComposite = UIUtils.createPlaceholder((Composite)settingsPanel, (int)1);
        Group appearanceSettings = UIUtils.createControlGroup((Composite)completionComposite, (String)AIUIMessages.gpt_preference_page_advanced_appearance_group, (int)2, (int)0, (int)5);
        appearanceSettings.setLayoutData((Object)new GridData(770));
        this.createAppearanceSettings((Composite)appearanceSettings, propertyChangeListener);
        Group completionGroup = UIUtils.createControlGroup((Composite)completionComposite, (String)AIUIMessages.gpt_preference_page_completion_group, (int)2, (int)0, (int)5);
        completionGroup.setLayoutData((Object)new GridData(768));
        this.createCompletionSettings((Composite)completionGroup, propertyChangeListener);
        Group schemaGroup = UIUtils.createControlGroup((Composite)settingsPanel, (String)AIUIMessages.gpt_preference_page_schema_group, (int)2, (int)0, (int)5);
        this.createSchemaSettings((Composite)schemaGroup);
    }

    protected void createCompletionSettings(Composite completionGroup, Runnable propertyChangeListener) {
        completionGroup.setLayoutData((Object)new GridData(1808));
        this.executeQueryImmediatelyCheck = UIUtils.createCheckbox((Composite)completionGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_label, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_tip, (boolean)false, (int)2);
    }

    protected void createSchemaSettings(Composite schemaGroup) {
        schemaGroup.setLayoutData((Object)new GridData(770));
        this.sendTypeInfoCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_send_type_label, (String)AIUIMessages.gpt_preference_page_completion_send_type_tip, (boolean)false, (int)2);
        this.sendDescriptionCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_description_label, (String)AIUIMessages.gpt_preference_page_completion_execute_description_tip, (boolean)false, (int)2);
    }

    protected void createAppearanceSettings(Composite appearanceGroup, Runnable propertyChangeListener) {
        this.includeSourceTextInCommentCheck = UIUtils.createCheckbox((Composite)appearanceGroup, (String)AIUIMessages.gpt_preference_page_completion_include_source_label, (String)AIUIMessages.gpt_preference_page_completion_include_source_tip, (boolean)false, (int)2);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.includeSourceTextInCommentCheck.setSelection(store.getBoolean("ai.completion.includeSourceTextInQuery"));
        this.executeQueryImmediatelyCheck.setSelection(store.getBoolean("ai.completion.executeImmediately"));
        this.sendTypeInfoCheck.setSelection(store.getBoolean("ai.completion.sendType"));
        this.sendDescriptionCheck.setSelection(store.getBoolean("ai.completion.description"));
    }

    public void saveSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.completion.includeSourceTextInQuery", this.includeSourceTextInCommentCheck.getSelection());
        store.setValue("ai.completion.executeImmediately", this.executeQueryImmediatelyCheck.getSelection());
        store.setValue("ai.completion.sendType", this.sendTypeInfoCheck.getSelection());
        store.setValue("ai.completion.description", this.sendDescriptionCheck.getSelection());
    }

    public void resetSettings(@NotNull AISettings aiSettings) {
    }

    public boolean isComplete() {
        return true;
    }
}

