/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSettings;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.controls.ScopeConfigDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ScopeSelectorControl
extends Composite {
    private static final Log log = Log.getLog(ScopeSelectorControl.class);
    private DBSLogicalDataSource dataSource;
    private DBCExecutionContext executionContext;
    private final Combo scopeCombo;
    private final Text scopeText;
    private final ToolItem scopeConfigItem;
    private final ToolBar toolBar;
    private final Set<String> checkedObjectIds;
    private DAICompletionScope currentScope;

    public ScopeSelectorControl(@NotNull Composite parent, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull DAICompletionSettings settings) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(5).create());
        this.dataSource = dataSource;
        this.executionContext = executionContext;
        this.currentScope = settings.getScope();
        this.checkedObjectIds = new HashSet<String>();
        if (!ArrayUtils.isEmpty((Object[])settings.getCustomObjectIds())) {
            this.checkedObjectIds.addAll(Arrays.asList(settings.getCustomObjectIds()));
        }
        this.scopeCombo = new Combo((Composite)this, 12);
        DAICompletionScope[] dAICompletionScopeArray = DAICompletionScope.values();
        int n = dAICompletionScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DAICompletionScope scope = dAICompletionScopeArray[n2];
            this.scopeCombo.add(scope.getTitle());
            if (this.currentScope == scope) {
                this.scopeCombo.select(this.scopeCombo.getItemCount() - 1);
            }
            ++n2;
        }
        this.scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeSelectorControl.this.changeScope((DAICompletionScope)CommonUtils.fromOrdinal(DAICompletionScope.class, (int)ScopeSelectorControl.this.scopeCombo.getSelectionIndex()));
            }
        });
        this.scopeText = new Text((Composite)this, 2056);
        this.scopeText.setEditable(false);
        this.scopeText.setLayoutData((Object)new GridData(768));
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolBar.setLayoutData((Object)new GridData(128));
        this.scopeConfigItem = UIUtils.createToolItem((ToolBar)this.toolBar, (String)"Customize", (DBPImage)UIIcon.RS_DETAILS, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.changeScope(DAICompletionScope.CUSTOM)));
        this.showScopeSettings(this.currentScope);
    }

    public void setInput(@NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext) {
        this.dataSource = dataSource;
        this.executionContext = executionContext;
        this.showScopeSettings(this.currentScope);
    }

    @NotNull
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @NotNull
    public Combo getScopeCombo() {
        return this.scopeCombo;
    }

    @NotNull
    public Text getScopeText() {
        return this.scopeText;
    }

    @NotNull
    public Set<String> getCheckedObjectIds() {
        return this.checkedObjectIds;
    }

    @NotNull
    public DAICompletionScope getScope() {
        return this.currentScope;
    }

    @NotNull
    public List<DBSEntity> getCustomEntities(@NotNull DBRProgressMonitor monitor) {
        return ScopeSelectorControl.loadCustomEntities(monitor, this.executionContext.getDataSource(), this.checkedObjectIds);
    }

    @NotNull
    public DBSLogicalDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    private void showScopeSettings(@NotNull DAICompletionScope scope) {
        Object text = switch (scope) {
            case DAICompletionScope.CURRENT_SCHEMA -> {
                if (CommonUtils.isNotEmpty((String)this.dataSource.getCurrentSchema())) {
                    yield this.dataSource.getCurrentSchema();
                }
                if (CommonUtils.isNotEmpty((String)this.dataSource.getCurrentCatalog())) {
                    yield this.dataSource.getCurrentCatalog();
                }
                yield this.dataSource.getDataSourceContainer().getName();
            }
            case DAICompletionScope.CURRENT_DATABASE -> {
                if (CommonUtils.isNotEmpty((String)this.dataSource.getCurrentCatalog())) {
                    yield this.dataSource.getCurrentCatalog();
                }
                yield this.dataSource.getDataSourceContainer().getName();
            }
            case DAICompletionScope.CURRENT_DATASOURCE -> this.dataSource.getDataSourceContainer().getName();
            default -> this.checkedObjectIds.size() + " object(s)";
        };
        this.scopeConfigItem.setEnabled(scope == DAICompletionScope.CUSTOM);
        this.scopeText.setText(CommonUtils.toString((Object)text, (String)"N/A"));
        this.requestLayout();
        this.layout(true, true);
    }

    @NotNull
    public static List<DBSEntity> loadCustomEntities(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull Set<String> ids) {
        monitor.beginTask("Load custom entities", ids.size());
        try {
            List<DBSEntity> list = ScopeSelectorControl.loadCheckedEntitiesById(monitor, dataSource.getContainer().getProject(), ids);
            return list;
        }
        catch (Exception e) {
            log.error((Object)e);
            List<DBSEntity> list = List.of();
            return list;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<DBSEntity> loadCheckedEntitiesById(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull Set<String> ids) throws DBException {
        ArrayList<DBSEntity> output = new ArrayList<DBSEntity>();
        for (String id : ids) {
            DBSObject dBSObject = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)id);
            if (dBSObject instanceof DBSEntity) {
                void entity;
                DBSEntity cfr_ignored_0 = (DBSEntity)dBSObject;
                DBSEntity cfr_ignored_1 = (DBSEntity)dBSObject;
                output.add((DBSEntity)entity);
            }
            monitor.worked(1);
        }
        return output;
    }

    public void changeScope(@NotNull DAICompletionScope scope) {
        if (scope == DAICompletionScope.CUSTOM) {
            ScopeConfigDialog dialog = new ScopeConfigDialog(this.getShell(), this.checkedObjectIds, this.executionContext.getDataSource());
            if (dialog.open() != 0) {
                return;
            }
            this.checkedObjectIds.clear();
            this.checkedObjectIds.addAll(dialog.getCheckedObjectIds());
        }
        this.currentScope = scope;
        this.showScopeSettings(scope);
    }
}

