/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.controls;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;

public class ScopeConfigDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ScopeConfigDialog.class);
    private Tree objectTree;
    private final Set<String> checkedObjectIds;
    private final DBPDataSource dataSource;

    public ScopeConfigDialog(@NotNull Shell shell, @NotNull Set<String> checkedIds, @NotNull DBPDataSource dataSource) {
        super(shell, "Customize scope", (DBPImage)DBIcon.AI);
        this.checkedObjectIds = new LinkedHashSet<String>(checkedIds);
        this.dataSource = dataSource;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.objectTree = new Tree(composite, 32);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.objectTree.setLayoutData((Object)gd);
        this.objectTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                TreeItem item = (TreeItem)e.item;
                if (item.getData() instanceof DBSStructContainer) {
                    this.checkTreeItems(item.getItems(), item.getChecked());
                }
            }

            private void checkTreeItems(TreeItem[] items, boolean check) {
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] children;
                    TreeItem child = treeItemArray[n2];
                    child.setChecked(check);
                    if (!(child.getData() instanceof DBSEntity) && !ArrayUtils.isEmpty((Object[])(children = child.getItems()))) {
                        this.checkTreeItems((TreeItem[])children, check);
                    }
                    ++n2;
                }
            }
        });
        this.loadObjects(this.objectTree, this.dataSource);
        return composite;
    }

    @NotNull
    public Set<String> getCheckedObjectIds() {
        return this.checkedObjectIds;
    }

    private void loadObjects(final Tree objectTree, final DBPDataSource ds) {
        new AbstractJob("Load database structure"){

            protected IStatus run(DBRProgressMonitor monitor) {
                if (ds instanceof DBSObjectContainer) {
                    try {
                        ScopeConfigDialog.this.loadContainer(monitor, objectTree, null, (DBSObjectContainer)ds, ScopeConfigDialog.this.checkedObjectIds);
                    }
                    catch (Exception e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    UIUtils.syncExec(() -> {
                        if (objectTree != null && !objectTree.isDisposed()) {
                            TreeItem[] treeItemArray = objectTree.getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem item = treeItemArray[n2];
                                item.setExpanded(true);
                                ++n2;
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void loadContainer(DBRProgressMonitor monitor, Tree objectTree, TreeItem parentItem, DBSObjectContainer objectContainer, Set<String> checkedObjectIds) throws DBException {
        Collection children;
        try {
            children = objectContainer.getChildren(monitor);
        }
        catch (Exception e) {
            log.debug((Object)("Error loading container '" + objectContainer.getName() + "' contents: " + e.getMessage()));
            return;
        }
        if (children == null) {
            return;
        }
        LinkedHashMap addedContainers = new LinkedHashMap();
        UIUtils.syncExec(() -> {
            for (DBSObject child : children) {
                DBNDatabaseNode node;
                if (monitor.isCanceled() || objectTree == null || objectTree.isDisposed()) {
                    return;
                }
                if (!(child instanceof DBSStructContainer) && !(child instanceof DBSEntity) || (node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)child, (boolean)false)) == null) continue;
                TreeItem item = parentItem == null ? new TreeItem(objectTree, 0) : new TreeItem(parentItem, 0);
                item.setData((Object)child);
                item.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
                item.setText(node.getNodeDisplayName());
                String objectId = DBUtils.getObjectFullId((DBSObject)child);
                if (checkedObjectIds.contains(objectId)) {
                    item.setChecked(true);
                    if (parentItem != null && !parentItem.getExpanded()) {
                        parentItem.setExpanded(true);
                    }
                }
                if (!(child instanceof DBSObjectContainer)) continue;
                addedContainers.put(item, (DBSObjectContainer)child);
            }
        });
        if (monitor.isCanceled()) {
            return;
        }
        for (Map.Entry contItem : addedContainers.entrySet()) {
            if (monitor.isCanceled()) break;
            DBSObjectContainer object = (DBSObjectContainer)contItem.getValue();
            this.loadContainer(monitor, objectTree, (TreeItem)contItem.getKey(), object, checkedObjectIds);
        }
    }

    protected void okPressed() {
        this.checkedObjectIds.clear();
        this.collectCheckedObjects(this.objectTree.getItems());
        super.okPressed();
    }

    private void collectCheckedObjects(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] children;
            TreeItem item = treeItemArray[n2];
            if (item.getChecked() && item.getData() instanceof DBSEntity) {
                this.checkedObjectIds.add(DBUtils.getObjectFullId((DBSObject)((DBSEntity)item.getData())));
            }
            if (!ArrayUtils.isEmpty((Object[])(children = item.getItems()))) {
                this.collectCheckedObjects((TreeItem[])children);
            }
            ++n2;
        }
    }
}

