/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.k8s;

import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class KubeCtrlExecutor {
    public static String executeCommand(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, boolean local, String ... args) throws DBException {
        monitor.beginTask("Run kubectl", 1);
        try {
            String ccPath = KubeCtrlExecutor.getKubeCtlPath();
            ArrayList<String> fullArgs = new ArrayList<String>();
            KubeCtrlExecutor.addKubeCtrlDefaultArgs(configuration, fullArgs, args, local);
            monitor.subTask("Execute kubectl command");
            String string = RuntimeUtils.executeProcessAndCheckResult((String)ccPath, (String[])fullArgs.toArray(new String[0]));
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public static Process executeCommandAndWait(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, String ... args) throws DBException {
        monitor.beginTask("Run kubectl", 1);
        try {
            ArrayList<String> fullArgs = new ArrayList<String>();
            fullArgs.add(KubeCtrlExecutor.getKubeCtlPath());
            KubeCtrlExecutor.addKubeCtrlDefaultArgs(configuration, fullArgs, args, false);
            monitor.subTask("Execute kubectl command");
            Process process = Runtime.getRuntime().exec(fullArgs.toArray(new String[0]));
            return process;
        }
        catch (IOException e) {
            throw new DBException("Error starting kubectl", (Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    private static String getKubeCtlPath() {
        DBPPreferenceStore store = DBeaverEnterprisePreferences.getPreferences();
        String kctlPath = store.getString("kubectlPath");
        String ccPath = !CommonUtils.isEmpty((String)kctlPath) ? kctlPath : "kubectl";
        return ccPath;
    }

    private static void addKubeCtrlDefaultArgs(@NotNull DBWHandlerConfiguration configuration, List<String> fullArgs, String[] args, boolean local) {
        String configPath;
        if (!ArrayUtils.isEmpty((Object[])args)) {
            Collections.addAll(fullArgs, args);
        }
        if (!CommonUtils.isEmpty((String)(configPath = configuration.getStringProperty("config")))) {
            fullArgs.add("--kubeconfig");
            fullArgs.add(configPath);
        }
        if (!local) {
            String namespaceName;
            String contextName = configuration.getStringProperty("context");
            if (!CommonUtils.isEmpty((String)contextName) && !contextName.equals("default")) {
                fullArgs.add("--context");
                fullArgs.add(contextName);
            }
            if (!CommonUtils.isEmpty((String)(namespaceName = configuration.getStringProperty("namespace"))) && !namespaceName.equals("default")) {
                fullArgs.add("--namespace");
                fullArgs.add(namespaceName);
            }
        }
    }
}

