/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.k8s;

import com.dbeaver.net.k8s.KubeCtrlExecutor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class K8SServiceInfo {
    private final DBWHandlerConfiguration configuration;
    private final Map<String, ServicePortInfo> serviceMap = new LinkedHashMap<String, ServicePortInfo>();

    public DBWHandlerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, ServicePortInfo> getServiceMap() {
        return this.serviceMap;
    }

    K8SServiceInfo(DBWHandlerConfiguration configuration, String svcOutput) {
        this.configuration = configuration;
        String[] lines = svcOutput.split("\\n");
        int i = 1;
        while (i < lines.length) {
            String svcLine = lines[i].trim();
            if (!CommonUtils.isEmpty((String)svcLine)) {
                String svcName = null;
                ServicePortInfo portInfo = null;
                int k = 1;
                while (k < svcLine.length()) {
                    if (Character.isWhitespace(svcLine.charAt(k))) {
                        svcName = svcLine.substring(0, k).trim();
                        portInfo = new ServicePortInfo();
                        portInfo.port = CommonUtils.toInt((Object)svcLine.substring(k).trim());
                        break;
                    }
                    ++k;
                }
                if (!CommonUtils.isEmpty(svcName) && portInfo != null) {
                    this.serviceMap.put(svcName, portInfo);
                }
            }
            ++i;
        }
    }

    public static K8SServiceInfo getServiceInfo(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        String svcOut = KubeCtrlExecutor.executeCommand(monitor, configuration, false, "get", "svc", "-o=custom-columns=POD_NAME:.metadata.name,PORTS:.spec.ports[0].port");
        return new K8SServiceInfo(configuration, svcOut);
    }

    public static class ServicePortInfo {
        String protocol;
        int port;
        int targetPort;

        public String getProtocol() {
            return this.protocol;
        }

        public int getPort() {
            return this.port;
        }

        public int getTargetPort() {
            return this.targetPort;
        }
    }
}

