/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.k8s;

import com.dbeaver.net.k8s.KubeCtrlExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class K8SContextInfo {
    private static final Pattern CTX_NAME_PATTER = Pattern.compile("\\S+\\s+([\\w\\-]+)");
    private final List<String> contexts = new ArrayList<String>();

    public List<String> getContexts() {
        return this.contexts;
    }

    K8SContextInfo(String svcOutput) {
        String[] lines = svcOutput.split("\\n");
        int i = 1;
        while (i < lines.length) {
            Matcher matcher;
            String svcLine = lines[i].trim();
            if (!CommonUtils.isEmpty((String)svcLine) && (matcher = CTX_NAME_PATTER.matcher(svcLine)).find()) {
                this.contexts.add(matcher.group(1));
            }
            ++i;
        }
    }

    public static K8SContextInfo getContextInfo(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        String ctxOut = KubeCtrlExecutor.executeCommand(monitor, configuration, true, "config", "get-contexts");
        return new K8SContextInfo(ctxOut);
    }
}

