/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.edb.model;

import com.dbeaver.db.edb.model.EDBPackage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class EDBSchema
extends PostgreSchema {
    private static final String SYSTEM_SCHEMA_NAME = "sys";
    private EDBPackageCache packageCache = new EDBPackageCache();

    public EDBSchema(PostgreDatabase database, String name, ResultSet dbResult) throws SQLException {
        super(database, name, dbResult);
    }

    public EDBSchema(PostgreDatabase database, String name, PostgreRole owner) {
        super(database, name, owner);
    }

    public boolean isSystem() {
        return super.isSystem() || SYSTEM_SCHEMA_NAME.equals(this.name);
    }

    public EDBPackageCache getPackageCache() {
        return this.packageCache;
    }

    @Association
    public Collection<EDBPackage> getPackages(DBRProgressMonitor monitor) throws DBException {
        return this.packageCache.getAllObjects(monitor, (DBSObject)this);
    }

    public EDBPackage getPackage(DBRProgressMonitor monitor, String packageName) throws DBException {
        return (EDBPackage)this.packageCache.getObject(monitor, (DBSObject)this, packageName);
    }

    static class EDBPackageCache
    extends JDBCObjectLookupCache<EDBSchema, EDBPackage> {
        EDBPackageCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(JDBCSession session, EDBSchema owner, EDBPackage edbPackage, String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("Select ep.oid, ep.pkgname, ep.pkgheadsrc, pd.description from pg_catalog.edb_package ep left join pg_catalog.pg_description pd\non pd.objoid = ep.\"oid\" where ep.pkgnamespace = ?" + (edbPackage == null && objectName == null ? "" : " \nAND pkgname = ?"));
            dbStat.setLong(1, owner.getObjectId());
            if (edbPackage != null || objectName != null) {
                dbStat.setString(2, edbPackage != null ? edbPackage.getName() : objectName);
            }
            return dbStat;
        }

        protected EDBPackage fetchObject(@NotNull JDBCSession session, @NotNull EDBSchema owner, @NotNull JDBCResultSet dbResult) {
            return new EDBPackage(owner, dbResult);
        }
    }
}

