/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.trace.CallableStatement;
import com.sap.dbtech.jdbc.trace.Connection;
import com.sap.dbtech.jdbc.trace.PreparedStatement;
import com.sap.dbtech.jdbc.trace.TraceControl;
import com.sap.dbtech.jdbc.trace.TraceEventListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class Tracer {
    private String filename = null;
    private File traceFile = null;
    private RandomAccessFile log = null;
    private boolean traceIsOn = false;
    public long maxTraceSize = Long.MAX_VALUE;
    public boolean isSizeLimited = false;
    public int wrapCount = 0;
    public int stopOnError = 0;
    private Thread lastThread = null;
    private TraceControl m_trcCtl;
    private byte[] destBuf = new byte[1536];
    private char[] srcBuf = new char[512];
    static final String curPos = "<CURRENT WRITE POSITION>\n";

    public Tracer(TraceControl ctl) {
        this.m_trcCtl = ctl;
    }

    public boolean setTraceFileName(String afilename) {
        boolean nameChanged;
        boolean bl = nameChanged = !afilename.equals(this.filename);
        if (nameChanged) {
            this.filename = afilename;
            this.traceFile = null;
            return true;
        }
        return false;
    }

    public File getTraceFile() {
        block11: {
            if (this.traceFile == null) {
                try {
                    if (this.filename == null || this.filename.equals("")) {
                        this.traceFile = File.createTempFile("MaxDBJDBC_", "prt");
                        this.traceFile.delete();
                        break block11;
                    }
                    String path = null;
                    String file = null;
                    int index = this.filename.lastIndexOf(File.separatorChar);
                    if (-1 == index) {
                        file = this.filename;
                    } else {
                        path = this.filename.substring(0, index);
                        file = this.filename.substring(index);
                    }
                    index = file.lastIndexOf(46);
                    if (-1 == index) {
                        index = file.length();
                    }
                    File fpath = null;
                    if (path != null) {
                        fpath = new File(path);
                        try {
                            if (!fpath.isDirectory()) {
                                fpath.mkdirs();
                            }
                        }
                        catch (Exception e) {
                            fpath = null;
                        }
                    }
                    this.traceFile = File.createTempFile(file.substring(0, index), file.substring(index), fpath);
                    this.traceFile.delete();
                }
                catch (IOException ex) {
                    this.traceFile = null;
                }
            }
        }
        return this.traceFile;
    }

    void checkThreadChange() {
        if (this.log == null) {
            return;
        }
        Thread t = Thread.currentThread();
        if (t != this.lastThread) {
            this.lastThread = t;
            this.printNoSyn("\n---- Thread " + Integer.toHexString(t.hashCode()) + " " + t.getName() + " Timestamp: " + new Timestamp(System.currentTimeMillis()) + "\n");
        }
    }

    public synchronized void close() {
        if (this.log != null) {
            try {
                this.log.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log = null;
            this.traceIsOn = false;
        }
    }

    public void open() {
        try {
            File trc = this.getTraceFile();
            if (trc == null) {
                return;
            }
            trc.delete();
            this.log = new RandomAccessFile(trc, "rw");
            this.traceIsOn = true;
            this.wrapCount = 0;
            this.printHeader();
        }
        catch (FileNotFoundException ex) {
            this.traceIsOn = false;
        }
    }

    public synchronized void println(String text) {
        this.checkThreadChange();
        this.printNoSyn(text + "\n");
    }

    void writeUTF(String str) throws IOException {
        int strlen = str.length();
        int len = 0;
        for (int k = 0; k < strlen; k += len) {
            int count = 0;
            len = strlen - k > 256 ? 256 : strlen - k;
            str.getChars(k, k + len, this.srcBuf, 0);
            for (int i = 0; i < len; ++i) {
                char c = this.srcBuf[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    this.destBuf[count++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    this.destBuf[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.destBuf[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.destBuf[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            this.log.write(this.destBuf, 0, count);
        }
    }

    private void printNoSyn(String text) {
        block7: {
            if (this.log == null) {
                return;
            }
            try {
                this.writeUTF(text);
                if (!this.isSizeLimited) break block7;
                long offset = this.log.getFilePointer();
                if (offset + (long)curPos.length() > this.maxTraceSize) {
                    try {
                        while (offset < this.maxTraceSize) {
                            this.log.write(32);
                            ++offset;
                        }
                        this.log.seek(0L);
                        ++this.wrapCount;
                        this.printHeader();
                        offset = this.log.getFilePointer();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.log.writeBytes(curPos);
                this.log.seek(offset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void print(String text) {
        this.checkThreadChange();
        this.printNoSyn(text);
    }

    private synchronized void printHeader() {
        this.printNoSyn("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><PRE><PLAINTEXT>\n");
        String java_version = "<unknown>";
        try {
            java_version = System.getProperty("java.version", "<unknown>");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.printNoSyn("ClassLoader: " + Tracer.class.getClassLoader() + "\n");
        this.printNoSyn(DriverSapDB.getVersionString() + " on Java " + java_version + "\n\n");
        if (this.wrapCount > 0) {
            this.printNoSyn("Warning: Trace wrapped around " + this.wrapCount + " times.\n\n");
        }
        this.dumpObjectTree();
    }

    public synchronized void print(String text, Properties info) {
        this.checkThreadChange();
        this.printNoSyn(text);
        if (info == null) {
            return;
        }
        Enumeration<Object> e = info.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = key.equals("password") ? "***" : info.getProperty(key);
            if (val != null && val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            this.printNoSyn("\n" + key + "=" + val);
        }
        this.printNoSyn("\n");
    }

    public synchronized void traceException(Throwable exc) {
        if (this.log != null) {
            this.checkThreadChange();
            this.printNoSyn("Timestamp: " + new Timestamp(System.currentTimeMillis()));
            StringWriter sw = new StringWriter();
            exc.printStackTrace(new PrintWriter(sw));
            this.printNoSyn(sw.toString());
            this.printNoSyn("\n");
        }
        if (this.stopOnError != 0 && exc instanceof SQLException && ((SQLException)exc).getErrorCode() == this.stopOnError) {
            this.close();
        }
    }

    public void whereAmI() {
        if (this.log != null) {
            this.checkThreadChange();
            this.printNoSyn("whereAmI");
            Throwable thr = new Throwable();
            StringWriter sw = new StringWriter();
            thr.printStackTrace(new PrintWriter(sw));
            this.printNoSyn(sw.toString() + "\n");
        }
    }

    public synchronized void dumpLocks(java.sql.Connection conn) throws SQLException {
        this.checkThreadChange();
        this.printNoSyn(Tracer.dumpLockAsString(conn));
    }

    public static synchronized String dumpLockAsString(java.sql.Connection conn) throws SQLException {
        StringBuffer sb = new StringBuffer(200);
        Statement lockstmt = conn.createStatement();
        ResultSet rs = lockstmt.executeQuery("SELECT SESSION, TABLENAME, ROWID, ROWIDHEX, REQMODE, REQSTATE, LOCKMODE, LOCKSTATE FROM lockstatistics");
        sb.append("DUMP LOCKSTATISTICS\n");
        if (rs.next()) {
            sb.append("SESSION;TABLENAME;ROWID;ROWIDHEX;REQMODE;REQSTATE;LOCKMODE;LOCKSTATE\n");
            do {
                sb.append(rs.getString("SESSION") + ";" + rs.getString("TABLENAME") + ";" + rs.getString("ROWID") + ";" + Tracer.Hex2String(rs.getBytes("ROWIDHEX")) + ";" + rs.getString("REQMODE") + ";" + rs.getString("REQSTATE") + ";" + rs.getString("LOCKMODE") + ";" + rs.getString("LOCKSTATE") + "\n");
            } while (rs.next());
        } else {
            sb.append("=>no locks found\n");
        }
        rs.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpObjectTree() {
        HashSet telList = this.m_trcCtl.getTraceEventListeners();
        boolean println = false;
        HashSet hashSet = telList;
        synchronized (hashSet) {
            Iterator it = telList.iterator();
            while (it.hasNext()) {
                TraceEventListener tel = (TraceEventListener)((WeakReference)it.next()).get();
                if (tel != null) {
                    Statement st;
                    if (tel instanceof Connection) {
                        java.sql.Connection cn = ((Connection)tel).getInnermost();
                        this.printNoSyn("=> object.dump " + cn + "\n");
                        println = true;
                        continue;
                    }
                    if (tel instanceof com.sap.dbtech.jdbc.trace.Statement) {
                        st = ((com.sap.dbtech.jdbc.trace.Statement)tel).getInnermost();
                        this.printNoSyn("=> object.dump " + st + "\n");
                        println = true;
                        continue;
                    }
                    if (tel instanceof PreparedStatement) {
                        st = (CallableStatementSapDB)((PreparedStatement)tel).getInnermost();
                        this.printNoSyn("=> object.dump " + st + " SQL " + ((CallableStatementSapDB)st).getParseinfo().getSqlCommand() + "\n");
                        println = true;
                        continue;
                    }
                    if (!(tel instanceof CallableStatement)) continue;
                    st = (CallableStatementSapDB)((CallableStatement)tel).getInnermost();
                    this.printNoSyn("=> object.dump " + st + " SQL " + ((CallableStatementSapDB)st).getParseinfo().getSqlCommand() + "\n");
                    println = true;
                    continue;
                }
                it.remove();
            }
        }
        if (println) {
            this.printNoSyn("\n");
        }
    }

    public static String Hex2String(byte[] bytearr) {
        if (bytearr == null) {
            return "null";
        }
        return Tracer.Hex2String(bytearr, 0, bytearr.length);
    }

    public static String Hex2String(byte[] bytearr, int offset, int len) {
        if (bytearr == null || len == 0 || offset + len > bytearr.length) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int k = offset; k < offset + len; ++k) {
            if ((bytearr[k] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static String Hex2StringForTrace(byte[] bytearr, int headTailLen) {
        if (bytearr == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("[");
        if (2 * headTailLen + 3 > bytearr.length) {
            for (int k = 0; k < bytearr.length; ++k) {
                if ((bytearr[k] & 0xFF) < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
            }
        } else {
            int k;
            for (k = 0; k < headTailLen; ++k) {
                if ((bytearr[k] & 0xFF) < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
            }
            sb.append("...");
            for (k = bytearr.length - headTailLen - 1; k < bytearr.length; ++k) {
                if ((bytearr[k] & 0xFF) < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static byte[] String2Hex(String bytearr) {
        if (bytearr == null || bytearr.length() % 2 != 0) {
            return new byte[0];
        }
        byte[] dest = new byte[bytearr.length() / 2];
        for (int i = 0; i < dest.length; ++i) {
            String val = bytearr.substring(2 * i, 2 * i + 2);
            dest[i] = (byte)Integer.parseInt(val, 16);
        }
        return dest;
    }

    public boolean setMaxTraceSize(String maxTraceSize) {
        long mSize = Tracer.filesizeStr2Size(maxTraceSize);
        return this.setMaxTraceSize(mSize);
    }

    public boolean setMaxTraceSize(long mSize) {
        boolean erg = false;
        if (mSize < 8192L) {
            mSize = 8192L;
        }
        if (this.maxTraceSize != mSize) {
            this.maxTraceSize = mSize;
            if (this.traceIsOn) {
                erg = true;
            }
            if (mSize != Long.MAX_VALUE) {
                this.isSizeLimited = true;
            }
        }
        return erg;
    }

    public void setStopOnError(int astopOnError) {
        this.stopOnError = astopOnError;
    }

    private static long filesizeStr2Size(String str) {
        if (str == null) {
            return Long.MAX_VALUE;
        }
        long factor = 1L;
        int pos = (str = str.toUpperCase()).indexOf("KB");
        if (pos != -1) {
            factor = 1024L;
        } else {
            pos = str.indexOf("MB");
            if (pos != -1) {
                factor = 0x100000L;
            } else {
                pos = str.indexOf("GB");
                if (pos != -1) {
                    factor = 0x40000000L;
                } else {
                    pos = str.indexOf("B");
                    if (pos != -1) {
                        factor = 1L;
                    } else {
                        pos = str.length();
                    }
                }
            }
        }
        long size = Long.MAX_VALUE;
        try {
            String val = str.substring(0, pos);
            size = Long.parseLong(val) * factor;
        }
        catch (NumberFormatException e) {
            size = Long.MAX_VALUE;
        }
        return size;
    }
}

