/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import java.sql.SQLException;

public abstract class GarbageCan {
    protected int canTresholdC = 20;
    protected boolean objPending = false;
    protected boolean currentEmptyRun = false;
    protected boolean currentEmptyRun2 = false;

    public GarbageCan() {
        this(20);
    }

    public GarbageCan(int aTreshhold) {
        this.canTresholdC = aTreshhold;
    }

    public boolean isPending() {
        this.objPending = this.getGarbageSize() >= this.canTresholdC;
        return this.objPending;
    }

    public final void forceGarbageCollection() {
        this.objPending = true;
    }

    public final void emptyCan(ConnectionSapDB conn) {
        if (this.currentEmptyRun) {
            return;
        }
        this.currentEmptyRun = true;
        this.objPending = false;
        while (this.getGarbageSize() > 0) {
            try {
                RequestPacket requestPacket = conn.getRequestPacket(false);
                requestPacket.initializePacket((short)Short.MAX_VALUE);
                try {
                    this.emptyCan(requestPacket);
                }
                catch (UnicodeConversionException e) {
                    conn.freeRequestPacket(requestPacket);
                    requestPacket = conn.getRequestPacket(true);
                    requestPacket.initializePacket((short)Short.MAX_VALUE);
                    try {
                        this.emptyCan(requestPacket);
                    }
                    catch (UnicodeConversionException e1) {
                        // empty catch block
                    }
                }
                conn.execute(requestPacket, false, false, this, 3);
            }
            catch (SQLException sQLException) {}
        }
        this.currentEmptyRun = false;
    }

    public abstract void emptyCan();

    public abstract void throwIntoGarbageCan(Object var1);

    protected abstract int getGarbageSize();

    public abstract boolean emptyCan(RequestPacket var1) throws UnicodeConversionException;
}

