/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

public class ByteUtil {
    public static int indexOf(byte[] data, byte[] pattern, int start) {
        int j = 0;
        if (data.length == 0 || start > data.length) {
            return -1;
        }
        int[] failure = ByteUtil.computeFailure(pattern);
        for (int i = start; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    public static int compare(byte[] a, byte[] a2) {
        int length = a2.length - a.length;
        if (length != 0) {
            return length;
        }
        for (int i = 0; i < a.length; ++i) {
            int b = a2[i] - a[i];
            if (b == 0) continue;
            return b;
        }
        return 0;
    }

    public static int bytes2Hash(byte[] byteArr) {
        if (byteArr == null) {
            return 0;
        }
        int erg = 1;
        for (int i = 0; i < byteArr.length; ++i) {
            erg = 31 * erg + byteArr[i];
        }
        return erg;
    }

    public static int bytes2Hash(byte[] byteArr, byte[] byteArr2) {
        int i;
        if (byteArr == null) {
            return 0;
        }
        int erg = 1;
        for (i = 0; i < byteArr.length; ++i) {
            erg = 31 * erg + byteArr[i];
        }
        for (i = 0; i < byteArr2.length; ++i) {
            erg = 31 * erg + byteArr2[i];
        }
        return erg;
    }
}

