/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.rte.comm.CommunicationException;
import com.sap.dbtech.rte.comm.ConnectPacket;
import com.sap.dbtech.rte.comm.CserverPacketLayout;
import com.sap.dbtech.rte.comm.DbPacketLayout;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.rte.comm.RteSocketPacket;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BasicSocketComm
extends JdbcCommunication {
    protected String dbname;
    protected int port;
    protected String host;
    protected int maxSendLen;
    protected int receiverRef;
    protected int senderRef;
    protected OutputStream outstream;
    protected InputStream instream;
    protected static int DEFAULT_TIMEOUT = 0;
    protected int socketTimeOut;
    protected boolean dbSession;
    protected PacketLayout packetLayout;
    protected int remoteSwapping;
    public static final int controlPacketSize_C = 16384;
    protected Socket socket;
    protected int m_serviceType;
    protected Tracer m_tracer;

    protected BasicSocketComm(String hostPort, Properties properties, int aServiceType, Tracer tracer) throws RTEException {
        int colon_idx;
        this.m_serviceType = aServiceType;
        this.m_tracer = tracer;
        if (hostPort == null || hostPort.length() == 0) {
            hostPort = "localhost";
        }
        if ((colon_idx = hostPort.indexOf(":")) == -1) {
            this.host = hostPort;
            this.port = this.getDefaultPort();
        } else {
            this.host = hostPort.substring(0, colon_idx);
            try {
                this.port = Integer.parseInt(hostPort.substring(colon_idx + 1));
            }
            catch (NumberFormatException nformatex) {
                throw new RTEException(MessageTranslator.translate("error.unknown.host", hostPort, nformatex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), tracer, 13);
            }
        }
        if (DriverSapDB.computername != null && (DriverSapDB.computername.equalsIgnoreCase(this.host) || DriverSapDB.fullcomputername.equalsIgnoreCase(this.host))) {
            this.host = "localhost";
        }
        String timeout = null;
        if (properties != null) {
            timeout = properties.getProperty("communicationtimeout");
            String servtype = properties.getProperty("connecttype", "");
            if (servtype.equalsIgnoreCase("OLTP")) {
                this.m_serviceType = 9;
            } else if (servtype.equalsIgnoreCase("LIVECACHE")) {
                this.m_serviceType = 8;
            }
        }
        if (timeout == null) {
            this.socketTimeOut = DEFAULT_TIMEOUT;
        } else {
            try {
                this.socketTimeOut = Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatEx) {
                this.socketTimeOut = DEFAULT_TIMEOUT;
            }
        }
    }

    protected abstract int getDefaultPort();

    protected abstract void openSocket() throws RTEException;

    protected abstract BasicSocketComm getNewCommunication() throws RTEException;

    protected abstract boolean supportsInfoRequest();

    protected DbPacketLayout doInfoRequestOldStyle(String dbname) throws RTEException {
        StructuredBytes reply;
        DbPacketLayout layout = new DbPacketLayout();
        StructuredBytes rawRequest = BasicSocketComm.createRawPacket(8236);
        this.buildRTEHeader(rawRequest, 49);
        ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), dbname, layout, this.port, this.m_serviceType);
        connectPacket.close();
        this.sendData(rawRequest, connectPacket.length());
        try {
            reply = this.receiveConnect();
            this.senderRef = reply.getInt4(8);
            int replyRC = reply.getInt2(16);
            if (replyRC != 0) {
                throw new RTEException(RteC.getCommunicationError(replyRC), RteC.getCommunicationErrorMapCode(replyRC), this.m_tracer, replyRC);
            }
        }
        catch (RTEException e) {
            this.release();
            this.openSocket();
            this.buildRTEHeader(rawRequest, 51);
            this.sendData(rawRequest, connectPacket.length());
            reply = this.receiveConnect();
            this.senderRef = reply.getInt4(8);
            int replyRC = reply.getInt2(16);
            if (replyRC != 0) {
                throw new RTEException(RteC.getCommunicationError(replyRC), RteC.getCommunicationErrorMapCode(replyRC), this.m_tracer, replyRC);
            }
            this.release();
            this.openSocket();
        }
        DbPacketLayout result = new DbPacketLayout(reply, false, true);
        if (result.getPortNumber() != this.port && result.getPortNumber() != 0) {
            this.port = result.getPortNumber();
            this.release();
            this.openSocket();
        }
        return result;
    }

    protected DbPacketLayout doInfoRequest(String dbname, String dbroot, String pgm) throws RTEException {
        boolean redoInfoRequest;
        DbPacketLayout result = null;
        StructuredBytes reply = null;
        int ulMessClass = this.getInitialRequestType();
        int ulCommState = 0;
        if (!this.supportsInfoRequest()) {
            return null;
        }
        do {
            block14: {
                if (!this.isConnected()) {
                    this.openSocket();
                }
                DbPacketLayout layout = new DbPacketLayout();
                StructuredBytes rawRequest = BasicSocketComm.createRawPacket(8236);
                this.buildRTEHeader(rawRequest, ulMessClass);
                ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), dbname, layout, this.port, this.m_serviceType);
                if (dbroot != null) {
                    connectPacket.addConnectString(dbroot, 100);
                }
                if (pgm != null) {
                    connectPacket.addConnectString(pgm, 112);
                }
                connectPacket.close();
                this.sendData(rawRequest, connectPacket.length());
                try {
                    reply = this.receiveConnect();
                    this.senderRef = reply.getInt4(8);
                    ulCommState = reply.getInt2(16);
                    result = new DbPacketLayout(reply, false, true);
                }
                catch (Exception e) {
                    if (ulMessClass != 47 && ulMessClass != 49) break block14;
                    ulCommState = 1;
                }
            }
            if (ulMessClass == 47) {
                if (ulCommState != 0) {
                    if (this.m_serviceType != 4) {
                        if (ulCommState == 14) {
                            ulMessClass = 49;
                            redoInfoRequest = true;
                            continue;
                        }
                        this.release();
                        ulMessClass = 51;
                        redoInfoRequest = true;
                        continue;
                    }
                    redoInfoRequest = false;
                    continue;
                }
                if (result.getReplyMessType() == 48) {
                    this.release();
                    this.port = result.getPortNumber();
                    ulMessClass = 49;
                    redoInfoRequest = true;
                    continue;
                }
                redoInfoRequest = false;
                continue;
            }
            redoInfoRequest = false;
        } while (redoInfoRequest);
        if (ulMessClass == 51 && this.closeSocketAfterInfoRequest()) {
            this.release();
            this.openSocket();
        }
        if (ulCommState != 0 && ulCommState != 14) {
            this.release();
            throw new RTEException(RteC.getCommunicationError(ulCommState), RteC.getCommunicationErrorMapCode(ulCommState), this.m_tracer, ulCommState);
        }
        return result;
    }

    protected static StructuredBytes createRawPacket(int dataSize) {
        return new StructuredBytes(dataSize + 24);
    }

    protected static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void connectDB(String dbname) throws RTEException {
        DbPacketLayout layout = null;
        layout = this.doInfoRequest(dbname, null, null);
        this.dbSession = true;
        this.dbname = dbname;
        this.packetLayout = this.dbConnectExchange(dbname, layout);
    }

    public void connectAdmin(String dbname, String dbroot, String pgm) throws RTEException {
        this.dbname = dbname;
        CserverPacketLayout layout = new CserverPacketLayout();
        this.sendAdminConnect(dbname, dbroot, pgm, layout);
        StructuredBytes reply = this.receiveConnect();
        this.senderRef = reply.getInt4(8);
        int replyRC = reply.getInt2(16);
        if (replyRC != 0) {
            throw new RTEException(RteC.getCommunicationError(replyRC), RteC.getCommunicationErrorMapCode(replyRC), this.m_tracer, replyRC);
        }
        this.packetLayout = new DbPacketLayout(reply, false, false);
    }

    public String toString() {
        String result = super.toString() + " on " + this.socket;
        return result;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    protected void finalize() throws Throwable {
        if (this.socket != null) {
            this.release();
        }
        super.finalize();
    }

    protected void buildRTEHeader(StructuredBytes packet, int messClass) {
        packet.putInt4(0, 0);
        packet.putInt1(3, 4);
        packet.putInt1(messClass, 5);
        packet.putInt1(0, 6);
        packet.putInt1(0, 7);
        packet.putInt4(this.senderRef, 8);
        packet.putInt4(this.receiverRef, 12);
        packet.putInt2(0, 16);
        packet.putInt2(0, 18);
        packet.putInt4(this.maxSendLen, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket = null;
        }
    }

    public void sqlarequest(StructuredMem userPacket, int len) throws RTEException {
        this.request(userPacket, len);
    }

    public void sqlarelease() throws RTEException {
        this.release();
    }

    public StructuredMem sqlareceive() throws RTEException {
        return this.receive();
    }

    public void cancel() throws SQLException {
        try {
            DbPacketLayout layout = new DbPacketLayout();
            BasicSocketComm cancelConnection = this.getNewCommunication();
            StructuredBytes rawRequest = BasicSocketComm.createRawPacket(8236);
            this.buildRTEHeader(rawRequest, 65);
            rawRequest.putInt4(this.senderRef, 12);
            ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), this.dbname, layout, this.port, this.m_serviceType);
            connectPacket.close();
            cancelConnection.sendData(rawRequest, connectPacket.length());
            cancelConnection.closeSocket();
        }
        catch (RTEException exc) {
            throw new SQLException(exc.getMessage());
        }
    }

    protected void sendData(StructuredBytes packet, int len) throws RTEException {
        OutputStream ostream;
        this.setActSendLen(packet, len);
        try {
            if (this.outstream == null) {
                this.outstream = this.socket.getOutputStream();
            }
            ostream = this.outstream;
        }
        catch (IOException ioExc1) {
            throw new RTEException("sendData: getOutputStream failed", RteC.CommunicationErrorCodeMap_C[7], this.m_tracer, 7);
        }
        try {
            ostream.write(packet.bytes(), 0, len + 24);
        }
        catch (IOException ioExc2) {
            throw new RTEException(MessageTranslator.translate("error.send.write", String.valueOf(this.senderRef), ioExc2.getMessage()), RteC.CommunicationErrorCodeMap_C[7], this.m_tracer, 7);
        }
    }

    private void sendDbConnect(String dbname, PacketLayout layout, int myport) throws RTEException {
        StructuredBytes rawRequest = BasicSocketComm.createRawPacket(layout.maxDataLength());
        this.buildRTEHeader(rawRequest, 61);
        ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), dbname, layout, myport, this.m_serviceType);
        connectPacket.close();
        this.sendData(rawRequest, connectPacket.length());
    }

    private void sendAdminConnect(String dbname, String dbroot, String pgm, PacketLayout layout) throws RTEException {
        StructuredBytes rawRequest = BasicSocketComm.createRawPacket(layout.maxDataLength());
        this.buildRTEHeader(rawRequest, 91);
        ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), dbname, layout, this.port, this.m_serviceType);
        connectPacket.addConnectString(dbroot, 100);
        connectPacket.addConnectString(pgm, 112);
        connectPacket.addBoolToVarpart(true, 89);
        connectPacket.close();
        this.sendData(rawRequest, connectPacket.length());
    }

    public void request(StructuredMem userPacket, int len) throws RTEException {
        StructuredBytes rawPacket = ((RteSocketPacket)userPacket).rteHeader;
        this.buildRTEHeader(rawPacket, 63);
        this.sendData(rawPacket, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            StructuredBytes rawPacket = BasicSocketComm.createRawPacket(0);
            this.buildRTEHeader(rawPacket, 66);
            this.sendData(rawPacket, 0);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.socket.close();
        }
        catch (IOException ioexc) {
        }
        catch (RTEException rteexc) {
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.socket = null;
        }
    }

    public void reconnect() throws RTEException {
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception ignore) {
            this.socket = null;
        }
        this.openSocket();
        if (!this.dbSession) {
            throw new RTEException(MessageTranslator.translate("error.admin.reconnect"), RteC.CommunicationErrorCodeMap_C[3], this.m_tracer, 3);
        }
        this.connectDB(this.dbname);
    }

    protected StructuredMem receiveData() throws RTEException {
        boolean firstPacket = true;
        byte[] header = new byte[24];
        int dataLength = 0;
        int bytesRead = 0;
        byte[] readBuf = null;
        StructuredBytes replyHeader = null;
        StructuredBytes result = null;
        try {
            InputStream instream = this.instream;
            while (firstPacket || bytesRead < dataLength) {
                int actSendLength;
                int headerLength = instream.read(header, 0, 24);
                if (headerLength != 24) {
                    RTEException rteExc = new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
                    throw rteExc;
                }
                if (firstPacket) {
                    replyHeader = this.replyMem(header);
                    firstPacket = false;
                    int rteRC = replyHeader.getInt2(16);
                    if (rteRC != 0) {
                        throw new CommunicationException(rteRC, this.m_tracer);
                    }
                    dataLength = replyHeader.getInt4(20) - headerLength;
                    readBuf = new byte[dataLength];
                    result = new StructuredBytes(readBuf);
                }
                if ((actSendLength = replyHeader.getInt4(0) - headerLength) < 0 || bytesRead + actSendLength > readBuf.length) {
                    // empty if block
                }
                while (actSendLength > 0) {
                    int chunkRead;
                    try {
                        chunkRead = instream.read(readBuf, bytesRead, actSendLength);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayExc) {
                        throw new ArrayIndexOutOfBoundsException(MessageTranslator.translate("error.chunkoverflow", Integer.toString(actSendLength), Integer.toString(bytesRead), Integer.toString(readBuf.length)));
                    }
                    if (chunkRead < 0) {
                        throw new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
                    }
                    bytesRead += chunkRead;
                    actSendLength -= chunkRead;
                }
            }
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.data.receivefailed.reason", ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
        }
        return result;
    }

    public StructuredMem receive() throws RTEException {
        return this.receiveData();
    }

    protected int lookupPort() {
        return this.port;
    }

    public boolean isAdvancedAuthenticationSupported() throws SQLException {
        return this.packetLayout.isChallengeResponseSupported();
    }

    public StructuredMem getRequestPacket() {
        RteSocketPacket result = new RteSocketPacket(this.packetLayout.maxCmdDataLength());
        return result;
    }

    protected StructuredBytes receiveConnect() throws RTEException {
        StructuredBytes reply;
        int expectedReplyLen = 8260;
        byte[] connectReply = new byte[expectedReplyLen];
        try {
            int nowreceived;
            int replyLen;
            if (replyLen < 25) {
                throw new RTEException(MessageTranslator.translate("error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
            }
            this.remoteSwapping = connectReply[25];
            reply = this.replyMem(connectReply);
            int fullReplyLen = reply.getInt4(0);
            if (fullReplyLen < 0 || fullReplyLen > 512000) {
                throw new RTEException(MessageTranslator.translate("error.connectreply.garbled"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
            }
            for (replyLen = this.instream.read(connectReply, 0, expectedReplyLen); replyLen < fullReplyLen; replyLen += nowreceived) {
                nowreceived = this.instream.read(connectReply, replyLen, fullReplyLen - replyLen);
                if (nowreceived == -1) {
                    throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", "End of file before packet was read."), RteC.CommunicationErrorCodeMap_C[1], this.m_tracer, 1);
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException irx) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[1], this.m_tracer, 1);
        }
        return reply;
    }

    private PacketLayout dbConnectExchange(String dbname, PacketLayout layout) throws RTEException {
        StructuredBytes connectReply;
        this.sendDbConnect(dbname, layout, this.port);
        StructuredBytes reply = connectReply = this.receiveConnect();
        this.senderRef = reply.getInt4(8);
        int replyRC = reply.getInt2(16);
        if (replyRC != 0) {
            throw new RTEException(RteC.getCommunicationError(replyRC), RteC.getCommunicationErrorMapCode(replyRC), this.m_tracer, replyRC);
        }
        layout = new DbPacketLayout(connectReply, true, true);
        return layout;
    }

    protected void setActSendLen(StructuredBytes rawPacket, int sendLen) {
        rawPacket.putInt4(sendLen += 24, 0);
        rawPacket.putInt4(sendLen, 20);
    }

    protected StructuredBytes replyMem(byte[] buf) throws RTEException {
        StructuredBytes result;
        switch (this.remoteSwapping) {
            case 1: {
                result = new StructuredBytes(buf);
                break;
            }
            case 2: {
                result = new FullswapMem(buf);
                break;
            }
            default: {
                throw new RTEException(MessageTranslator.translate("error.invalid.swapping"), -708, this.m_tracer, 1);
            }
        }
        return result;
    }

    public int getKernelTaskID() {
        return this.senderRef;
    }

    protected int getInitialRequestType() {
        return 47;
    }

    protected boolean closeSocketAfterInfoRequest() {
        return true;
    }
}

