/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.jdbc.translators.GetvalUnicode;
import com.sap.dbtech.jdbc.translators.GetvalUnicodeClob;
import com.sap.dbtech.jdbc.translators.ProcedureStreamTranslator;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.UnicodeProcedurePutval;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public class UnicodeProcedureStreamTranslator
extends ProcedureStreamTranslator {
    UnicodeProcedureStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
    }

    public int getColumnDisplaySize() {
        return 0x40000000;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        return new UnicodeProcedurePutval(this, val.toCharArray());
    }

    public Object transCharacterStreamForInput(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return null;
        }
        return new UnicodeProcedurePutval(this, reader, length);
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        Reader reader = this.getCharacterStream(controller, mem, longData);
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, false);
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        Reader result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            if (this.descriptorIsNull(descriptor)) {
                return null;
            }
            GetvalUnicode getval = DriverSapDB.isJDBC20 ? new GetvalUnicodeClob(controller.getConnectionSapDB(), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode()) : new GetvalUnicode(controller.getConnectionSapDB(), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
            result = ((AbstractGetval)getval).getCharacterStream();
        }
        return result;
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        GetvalUnicodeClob result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            if (this.descriptorIsNull(descriptor)) {
                return null;
            }
            result = new GetvalUnicodeClob(controller.getConnectionSapDB(), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
        }
        return result;
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        if (stream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream);
        return this.transCharacterStreamForInput(reader, length);
    }

    boolean isPackectEncodingUnicode() {
        return true;
    }
}

