/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateTranslator
extends CharDataTranslator {
    public static final String zeroPadC = "0000";
    private static final int DateSize_C = 10;

    public DateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected DateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.physicalLength - 1);
        }
        return result;
    }

    protected int parseYear(byte[] raw) {
        int year = (raw[0] - 48) * 1000;
        year += (raw[1] - 48) * 100;
        year += (raw[2] - 48) * 10;
        return year += raw[3] - 48;
    }

    protected int parseMonth(byte[] raw) {
        int month = (raw[5] - 48) * 10;
        return month += raw[6] - 48;
    }

    protected int parseDay(byte[] raw) {
        int day = (raw[8] - 48) * 10;
        return day += raw[9] - 48;
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Date result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int year = this.parseYear(raw);
            int month = this.parseMonth(raw);
            int day = this.parseDay(raw);
            if (cal == null) {
                result = new Date(year - 1900, month - 1, day);
            } else {
                cal.clear();
                cal.set(year, month - 1, day, 0, 0, 0);
                result = DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
        }
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getDate(controller, mem, null);
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Date dateValue = this.getDate(controller, mem, cal);
        if (dateValue == null) {
            return null;
        }
        return new Timestamp(dateValue.getTime());
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transDateForInput(Date arg, Calendar cal) throws SQLException {
        if (arg == null) {
            return null;
        }
        cal.setTime(arg);
        int year = cal.get(1);
        if (year < 0 || year > 9999) {
            throw this.newParseException(arg.toString(), "Date");
        }
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return this.formatDate(year, month, day);
    }

    protected byte[] formatDate(int year, int month, int day) {
        byte[] formattedDate = new byte[]{(byte)(48 + year / 1000), (byte)(48 + (year %= 1000) / 100), (byte)(48 + (year %= 100) / 10), (byte)(48 + (year %= 10)), 45, HighTime_C[month], LowTime_C[month], 45, HighTime_C[day], LowTime_C[day]};
        return formattedDate;
    }

    protected void putSpecific(DataPart dataPart, Object data) throws SQLException {
        byte[] bytes = (byte[])data;
        this.checkFieldLimits(bytes.length);
        dataPart.putDefineByte(32, this.bufpos_input - 1);
        dataPart.putStringBytes(bytes, this.bufpos_input, this.physicalLength - 1);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof Date) {
            result = this.transDateForInput((Date)obj, Calendar.getInstance());
        }
        return result;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            return this.transDateForInput(Date.valueOf(val), Calendar.getInstance());
        }
        catch (IllegalArgumentException exc) {
            try {
                Timestamp ts = Timestamp.valueOf(val);
                return this.transDateForInput(new Date(ts.getTime()), Calendar.getInstance());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.newParseException(val, "Date");
            }
        }
    }
}

