/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.StructuredMem;

public class DataPartBase
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    protected int argCount = 0;
    protected int extent = 0;
    protected int massExtent = 0;
    StructuredMem originalMem;
    RequestPacket requestPacket;

    DataPartBase(StructuredMem rawMem, RequestPacket requestPacket) {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public void addArg(int pos, int len) {
        ++this.argCount;
        this.extent = Math.max(this.extent, pos + len);
    }

    public void close() {
        int argCountOffs = -14;
        this.originalMem.putInt2(this.argCount, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int rows) {
        int argCountOffs = -14;
        this.originalMem.putInt2(rows, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent * rows, rows);
    }

    protected int getMaxDataSize() {
        return this.size() - this.extent - 8;
    }

    public boolean hasRoomFor(int recordSize, int reserve) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > recordSize + reserve;
    }

    public boolean hasRoomFor(int recordSize) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > recordSize;
    }

    public void putNull(int pos, int len) {
        this.putInt1(-1, pos - 1);
        this.putBytes(new byte[len], pos);
        this.addArg(pos, len);
    }

    public int getExtent() {
        return this.extent;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }
}

