/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.vertica.edit;

import com.dbeaver.db.vertica.model.VerticaFunction;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericProcedureManager;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class VerticaFunctionManager
extends GenericProcedureManager
implements DBEObjectRenamer<GenericProcedure> {
    public boolean canCreateObject(Object container) {
        return false;
    }

    public boolean canEditObject(GenericProcedure object) {
        return true;
    }

    protected VerticaFunction createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new VerticaFunction((VerticaSchema)container, "NEW_PROCEDURE");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBCException {
        this.createOrReplaceProcedureQuery(monitor, actions, (VerticaFunction)command.getObject());
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        VerticaFunction function = (VerticaFunction)command.getObject();
        this.createOrReplaceProcedureQuery(monitor, actionList, (VerticaFunction)command.getObject());
        if (function.getProcedureType() == DBSProcedureType.FUNCTION && command.getProperties().containsKey("description")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter function description", "COMMENT ON " + String.valueOf(function.getProcedureType()) + " " + DBUtils.getQuotedIdentifier((DBSObject)function.getSchema()) + "." + function.getOverloadedName() + " IS " + SQLUtils.quoteString((DBSObject)function, (String)CommonUtils.notEmpty((String)function.getDescription()))));
        }
        super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericProcedure object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        VerticaFunction function = (VerticaFunction)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename function", "ALTER " + String.valueOf(function.getProcedureType()) + " " + DBUtils.getQuotedIdentifier((DBSObject)function.getSchema()) + "." + command.getOldName() + function.getFunctionSignature() + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)function.getDataSource(), (String)command.getNewName())));
    }

    private void createOrReplaceProcedureQuery(DBRProgressMonitor monitor, List<DBEPersistAction> actions, VerticaFunction procedure) throws DBCException {
        Object sourceCode = procedure.getSourceCode(monitor).trim();
        if (procedure.isPersisted() && procedure.getProcedureType() == DBSProcedureType.PROCEDURE) {
            Pattern bodyPattern = Pattern.compile("([A-Z]+)\\s+" + String.valueOf(procedure.getProcedureType()) + "(.+)");
            Matcher matcher = bodyPattern.matcher((CharSequence)sourceCode);
            if (!matcher.find()) {
                throw new DBCException("Cannot parse procedure body");
            }
            int divPos = ((String)sourceCode).indexOf("AS '", matcher.end());
            if (divPos == -1) {
                throw new DBCException("Cannot extract procedure source code");
            }
            sourceCode = "ALTER " + String.valueOf(procedure.getProcedureType()) + matcher.group(2) + "\nSOURCE TO " + ((String)sourceCode).substring(divPos + 3);
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create or replace procedure", (String)sourceCode));
    }
}

