/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.jts;

import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.postgis.binary.ByteSetter;
import org.postgis.binary.ValueSetter;

public class JtsBinaryWriter {
    public static ValueSetter valueSetterForEndian(ByteSetter bytes, byte endian) {
        if (endian == 0) {
            return new ValueSetter.XDR(bytes);
        }
        if (endian == 1) {
            return new ValueSetter.NDR(bytes);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + endian);
    }

    public String writeHexed(Geometry geom, byte REP) {
        int length = this.estimateBytes(geom);
        ByteSetter.StringByteSetter bytes = new ByteSetter.StringByteSetter(length);
        this.writeGeometry(geom, JtsBinaryWriter.valueSetterForEndian((ByteSetter)bytes, REP));
        return bytes.result();
    }

    public String writeHexed(Geometry geom) {
        return this.writeHexed(geom, (byte)1);
    }

    public byte[] writeBinary(Geometry geom, byte REP) {
        int length = this.estimateBytes(geom);
        ByteSetter.BinaryByteSetter bytes = new ByteSetter.BinaryByteSetter(length);
        this.writeGeometry(geom, JtsBinaryWriter.valueSetterForEndian((ByteSetter)bytes, REP));
        return bytes.result();
    }

    public byte[] writeBinary(Geometry geom) {
        return this.writeBinary(geom, (byte)1);
    }

    protected void writeGeometry(Geometry geom, ValueSetter dest) {
        boolean haveSrid;
        int plaintype;
        int dimension;
        if (geom == null) {
            throw new NullPointerException();
        }
        if (geom.isEmpty()) {
            dimension = 0;
        } else {
            dimension = JtsBinaryWriter.getCoordDim(geom);
            if (dimension < 2 || dimension > 4) {
                throw new IllegalArgumentException("Unsupported geometry dimensionality: " + dimension);
            }
        }
        dest.setByte(dest.endian);
        int typeword = plaintype = JtsBinaryWriter.getWKBType(geom);
        if (dimension == 3 || dimension == 4) {
            typeword |= Integer.MIN_VALUE;
        }
        if (dimension == 4) {
            typeword |= 0x40000000;
        }
        if (haveSrid = this.checkSrid(geom)) {
            typeword |= 0x20000000;
        }
        dest.setInt(typeword);
        if (haveSrid) {
            dest.setInt(geom.getSRID());
        }
        switch (plaintype) {
            case 1: {
                this.writePoint((Point)geom, dest);
                break;
            }
            case 2: {
                this.writeLineString((LineString)geom, dest);
                break;
            }
            case 3: {
                this.writePolygon((Polygon)geom, dest);
                break;
            }
            case 4: {
                this.writeMultiPoint((MultiPoint)geom, dest);
                break;
            }
            case 5: {
                this.writeMultiLineString((MultiLineString)geom, dest);
                break;
            }
            case 6: {
                this.writeMultiPolygon((MultiPolygon)geom, dest);
                break;
            }
            case 7: {
                this.writeCollection((GeometryCollection)geom, dest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + plaintype);
            }
        }
    }

    public static int getWKBType(Geometry geom) {
        if (geom.isEmpty()) {
            return 7;
        }
        if (geom instanceof Point) {
            return 1;
        }
        if (geom instanceof LineString) {
            return 2;
        }
        if (geom instanceof Polygon) {
            return 3;
        }
        if (geom instanceof MultiPoint) {
            return 4;
        }
        if (geom instanceof MultiLineString) {
            return 5;
        }
        if (geom instanceof MultiPolygon) {
            return 6;
        }
        if (geom instanceof GeometryCollection) {
            return 7;
        }
        throw new IllegalArgumentException("Unknown Geometry Type: " + geom.getClass().getName());
    }

    private void writePoint(Point geom, ValueSetter dest) {
        this.writeCoordinates(geom.getCoordinateSequence(), JtsBinaryWriter.getCoordDim((Geometry)geom), dest);
    }

    private void writeCoordinates(CoordinateSequence seq, int dims, ValueSetter dest) {
        for (int i = 0; i < seq.size(); ++i) {
            for (int d = 0; d < dims; ++d) {
                dest.setDouble(seq.getOrdinate(i, d));
            }
        }
    }

    private void writeMultiPoint(MultiPoint geom, ValueSetter dest) {
        dest.setInt(geom.getNumPoints());
        for (int i = 0; i < geom.getNumPoints(); ++i) {
            this.writeGeometry(geom.getGeometryN(i), dest);
        }
    }

    private void writeLineString(LineString geom, ValueSetter dest) {
        dest.setInt(geom.getNumPoints());
        this.writeCoordinates(geom.getCoordinateSequence(), JtsBinaryWriter.getCoordDim((Geometry)geom), dest);
    }

    private void writePolygon(Polygon geom, ValueSetter dest) {
        dest.setInt(geom.getNumInteriorRing() + 1);
        this.writeLineString(geom.getExteriorRing(), dest);
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            this.writeLineString(geom.getInteriorRingN(i), dest);
        }
    }

    private void writeMultiLineString(MultiLineString geom, ValueSetter dest) {
        this.writeGeometryArray((Geometry)geom, dest);
    }

    private void writeMultiPolygon(MultiPolygon geom, ValueSetter dest) {
        this.writeGeometryArray((Geometry)geom, dest);
    }

    private void writeCollection(GeometryCollection geom, ValueSetter dest) {
        this.writeGeometryArray((Geometry)geom, dest);
    }

    private void writeGeometryArray(Geometry geom, ValueSetter dest) {
        dest.setInt(geom.getNumGeometries());
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            this.writeGeometry(geom.getGeometryN(i), dest);
        }
    }

    protected int estimateBytes(Geometry geom) {
        int result = 0;
        ++result;
        result += 4;
        if (this.checkSrid(geom)) {
            result += 4;
        }
        switch (JtsBinaryWriter.getWKBType(geom)) {
            case 1: {
                result += this.estimatePoint((Point)geom);
                break;
            }
            case 2: {
                result += this.estimateLineString((LineString)geom);
                break;
            }
            case 3: {
                result += this.estimatePolygon((Polygon)geom);
                break;
            }
            case 4: {
                result += this.estimateMultiPoint((MultiPoint)geom);
                break;
            }
            case 5: {
                result += this.estimateMultiLineString((MultiLineString)geom);
                break;
            }
            case 6: {
                result += this.estimateMultiPolygon((MultiPolygon)geom);
                break;
            }
            case 7: {
                result += this.estimateCollection((GeometryCollection)geom);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + JtsBinaryWriter.getWKBType(geom));
            }
        }
        return result;
    }

    private boolean checkSrid(Geometry geom) {
        int srid = geom.getSRID();
        return srid > 0;
    }

    private int estimatePoint(Point geom) {
        return 8 * JtsBinaryWriter.getCoordDim((Geometry)geom);
    }

    private int estimateGeometryArray(Geometry container) {
        int result = 0;
        for (int i = 0; i < container.getNumGeometries(); ++i) {
            result += this.estimateBytes(container.getGeometryN(i));
        }
        return result;
    }

    private int estimateMultiPoint(MultiPoint geom) {
        int result = 4;
        if (geom.getNumGeometries() > 0) {
            result += geom.getNumGeometries() * this.estimateBytes(geom.getGeometryN(0));
        }
        return result;
    }

    private int estimateLineString(LineString geom) {
        if (geom == null || geom.getNumGeometries() == 0) {
            return 0;
        }
        return 4 + 8 * JtsBinaryWriter.getCoordSequenceDim(geom.getCoordinateSequence()) * geom.getCoordinateSequence().size();
    }

    private int estimatePolygon(Polygon geom) {
        int result = 4;
        result += this.estimateLineString(geom.getExteriorRing());
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            result += this.estimateLineString(geom.getInteriorRingN(i));
        }
        return result;
    }

    private int estimateMultiLineString(MultiLineString geom) {
        return 4 + this.estimateGeometryArray((Geometry)geom);
    }

    private int estimateMultiPolygon(MultiPolygon geom) {
        return 4 + this.estimateGeometryArray((Geometry)geom);
    }

    private int estimateCollection(GeometryCollection geom) {
        return 4 + this.estimateGeometryArray((Geometry)geom);
    }

    public static final int getCoordDim(Geometry geom) {
        if (geom.isEmpty()) {
            return 0;
        }
        if (geom instanceof Point) {
            return JtsBinaryWriter.getCoordSequenceDim(((Point)geom).getCoordinateSequence());
        }
        if (geom instanceof LineString) {
            return JtsBinaryWriter.getCoordSequenceDim(((LineString)geom).getCoordinateSequence());
        }
        if (geom instanceof Polygon) {
            return JtsBinaryWriter.getCoordSequenceDim(((Polygon)geom).getExteriorRing().getCoordinateSequence());
        }
        return JtsBinaryWriter.getCoordDim(geom.getGeometryN(0));
    }

    public static final int getCoordSequenceDim(CoordinateSequence coords) {
        if (coords == null || coords.size() == 0) {
            return 0;
        }
        int dimensions = coords.getDimension();
        if (dimensions == 3) {
            return Double.isNaN(coords.getOrdinate(0, 2)) ? 2 : 3;
        }
        return dimensions;
    }
}

