/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public abstract class AbstractPrefPage
extends PreferencePage {
    protected Control createContents(Composite parent) {
        if (!this.hasAccessToPage()) {
            return UIUtils.createLabel(parent, UIMessages.preference_page_no_access);
        }
        Control content = this.createPreferenceContent(parent);
        Dialog.applyDialogFont((Control)content);
        return content;
    }

    void disableButtons() {
        this.noDefaultAndApplyButton();
    }

    @NotNull
    protected abstract Control createPreferenceContent(@NotNull Composite var1);

    protected boolean hasAccessToPage() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void restartWorkbenchOnPrefChange() {
        Runnable restarter = () -> {
            boolean bl = PlatformUI.getWorkbench().restart();
        };
        IPreferencePageContainer iPreferencePageContainer = this.getContainer();
        if (iPreferencePageContainer instanceof Window) {
            void window;
            Window window2 = (Window)iPreferencePageContainer;
            Window cfr_ignored_0 = (Window)iPreferencePageContainer;
            window.getShell().addDisposeListener(e -> UIUtils.asyncExec(restarter));
            window.close();
        } else {
            restarter.run();
        }
    }
}

