/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;

public class HolidayDecorations {
    public static final String PREF_UI_SHOW_HOLIDAY_DECORATIONS = "ui.show.holiday.decorations";
    private static final boolean ENABLED = HolidayDecorations.isEnabled0();
    private static final double PARTICLES_PER_PIXEL = 1.0E-4;
    private static final Point2D.Double SIZE = new Point2D.Double(3.0, 15.0);
    private static final Point2D.Double SWING = new Point2D.Double(0.1, 1.0);
    private static final Point2D.Double SPEED = new Point2D.Double(40.0, 100.0);
    private static final Point2D.Double AMPLITUDE = new Point2D.Double(25.0, 50.0);
    private static final Point2D.Double SKEW = new Point2D.Double(Math.PI, Math.PI * 2);
    private static final Point PHASES = new Point(4, 8);
    private final Random random;
    private final List<Particle> particles = new ArrayList<Particle>();
    private double frameTime;

    private HolidayDecorations(@NotNull Control control) {
        this.random = new Random();
        Listener listener = event -> {
            switch (event.type) {
                case 11: {
                    this.reset(((Control)event.widget).getSize());
                    break;
                }
                case 9: {
                    this.draw(event.gc);
                }
            }
        };
        control.addListener(11, listener);
        control.addListener(9, listener);
    }

    public static void install(final @NotNull Control control) {
        if (!HolidayDecorations.isEnabled()) {
            return;
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = environment.getDefaultScreenDevice();
        final int refreshRate = 1000 / Math.max(device.getDisplayMode().getRefreshRate(), 60);
        final HolidayDecorations decorations = new HolidayDecorations(control);
        final Display display = Display.getCurrent();
        Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                decorations.update(control.getSize());
                if (control.isVisible()) {
                    display.asyncExec(() -> {
                        if (!control.isDisposed()) {
                            control.redraw();
                        }
                    });
                    display.timerExec(refreshRate, (Runnable)this);
                } else {
                    display.timerExec(refreshRate * 10, (Runnable)this);
                }
            }
        };
        display.timerExec(refreshRate, timer);
        UIUtils.enableDoubleBuffering(control);
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    private void reset(@NotNull Point size) {
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        this.frameTime = (double)System.currentTimeMillis() / 1000.0;
        if (this.particles.isEmpty()) {
            int count = (int)((double)(size.x * size.y) * 1.0E-4);
            int i = 0;
            while (i < count) {
                this.particles.add(new Particle(new Point2D.Double(this.random.nextDouble(size.x), -this.random.nextDouble(size.y)), new Point2D.Double(this.random.nextDouble(HolidayDecorations.SWING.x, HolidayDecorations.SWING.y), this.random.nextDouble(HolidayDecorations.SPEED.x, HolidayDecorations.SPEED.y)), this.random.nextDouble(HolidayDecorations.SIZE.x, HolidayDecorations.SIZE.y), this.random.nextDouble(HolidayDecorations.AMPLITUDE.x, HolidayDecorations.AMPLITUDE.y), this.random.nextDouble(HolidayDecorations.SKEW.x, HolidayDecorations.SKEW.y), this.random.nextInt(HolidayDecorations.PHASES.x, HolidayDecorations.PHASES.y), this.random.nextDouble(100.0)));
                ++i;
            }
        }
    }

    private void update(@NotNull Point size) {
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        double currentTime = (double)System.currentTimeMillis() / 1000.0;
        double deltaTime = currentTime - this.frameTime;
        for (Particle particle : this.particles) {
            particle.update(deltaTime);
            if (!(particle.position.getY() - particle.size > (double)size.y)) continue;
            double origin = this.random.nextDouble(size.x);
            particle.origin.setLocation(origin, particle.origin.getY());
            particle.position.setLocation(origin, -particle.size);
            particle.swing = this.random.nextDouble(100.0);
        }
        this.frameTime = currentTime;
    }

    private void draw(@NotNull GC gc) {
        gc.setForeground(Display.getCurrent().getSystemColor(1));
        for (Particle particle : this.particles) {
            HolidayDecorations.drawSnowflake(gc, particle);
        }
    }

    private static void drawSnowflake(@NotNull GC gc, @NotNull Particle particle) {
        double x = particle.position.getX();
        double y = particle.position.getY();
        double size1 = particle.size;
        double size2 = particle.size * 0.75;
        int steps = particle.phase;
        double step1 = Math.PI * 2 / (double)steps;
        int i = 0;
        while (i < steps) {
            double angle = Math.PI + step1 * (double)i + particle.rotation;
            gc.drawLine((int)x, (int)y, (int)(x + size1 * Math.sin(angle)), (int)(y + size1 * Math.cos(angle)));
            gc.drawLine((int)(x + 5.0 * Math.sin(angle)), (int)(y + 5.0 * Math.cos(angle)), (int)(x + size2 * Math.sin(angle + 0.5235987755982988)), (int)(y + size2 * Math.cos(angle + 0.5235987755982988)));
            gc.drawLine((int)(x + 5.0 * Math.sin(angle)), (int)(y + 5.0 * Math.cos(angle)), (int)(x + size2 * Math.sin(angle - 0.5235987755982988)), (int)(y + size2 * Math.cos(angle - 0.5235987755982988)));
            ++i;
        }
    }

    private static boolean isEnabled0() {
        boolean enabled = DBWorkbench.getPlatform().getPreferenceStore().getBoolean(PREF_UI_SHOW_HOLIDAY_DECORATIONS);
        if (enabled) {
            LocalDate current = LocalDate.now();
            return switch (current.getMonth()) {
                case Month.DECEMBER -> {
                    if (current.getDayOfMonth() >= 20) {
                        yield true;
                    }
                    yield false;
                }
                case Month.JANUARY -> {
                    if (current.getDayOfMonth() == 1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    private static class Particle {
        private final Point2D origin;
        private final Point2D position;
        private final Point2D velocity;
        private final double size;
        private final double amplitude;
        private final double skew;
        private final int phase;
        private double rotation;
        private double swing;

        public Particle(@NotNull Point2D origin, @NotNull Point2D velocity, double size, double amplitude, double skew, int phase, double swing) {
            this.origin = origin;
            this.position = (Point2D)origin.clone();
            this.velocity = velocity;
            this.size = size;
            this.amplitude = amplitude;
            this.skew = skew;
            this.phase = phase;
            this.swing = swing;
        }

        public void update(double deltaTime) {
            this.swing += this.velocity.getX() * deltaTime;
            this.rotation = this.skew * Math.sin(this.swing) / this.amplitude;
            this.position.setLocation(this.origin.getX() + this.amplitude * Math.sin(this.swing), this.position.getY() + this.velocity.getY() * deltaTime);
        }
    }
}

