/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.aws.ssm;

import com.dbeaver.ui.auth.aws.AuthModelAWSConfigurator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SSMTunnelConfigurator
implements IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> {
    private static final Log log = Log.getLog(SSMTunnelConfigurator.class);
    private AuthModelAWSConfigurator credsConfig;
    private DBWHandlerConfiguration savedConfiguration;
    private Text ec2InstanceIdText;
    private Combo ec2InstanceRegionText;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Group instanceGroup = UIUtils.createControlGroup((Composite)composite, (String)"EC2 instance", (int)2, (int)768, (int)-1);
        this.ec2InstanceIdText = UIUtils.createLabelText((Composite)instanceGroup, (String)"Instance ID", null);
        this.ec2InstanceRegionText = UIUtils.createLabelCombo((Composite)instanceGroup, (String)"Region", (String)"EC2 instance region", (int)4);
        this.credsConfig = new AuthModelAWSConfigurator();
        this.credsConfig.setDatabaseConfiguration(false);
        this.credsConfig.createControl(composite, null, propertyChangeListener);
        this.credsConfig.initAuthTypes();
        if (RuntimeUtils.isWindows()) {
            UIUtils.createHorizontalLine((Composite)composite);
            UIUtils.createLink((Composite)composite, (String)"Note: You have to have <a>AWS CLI</a> and <a>Session Manager Plugin</a> installed", (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> UIUtils.openWebBrowser((String)("AWS CLI".equals(e.text) ? "https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html" : "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html"))));
        }
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        this.savedConfiguration = new DBWHandlerConfiguration(configuration);
        this.ec2InstanceIdText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssm.instance.id")));
        this.ec2InstanceRegionText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssm.instance.region")));
        this.credsConfig.loadIAMAuthSettings(configuration.getSecureProperties());
        this.credsConfig.updateControls();
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        configuration.setProperty("ssm.instance.id", (Object)this.ec2InstanceIdText.getText());
        configuration.setProperty("ssm.instance.region", (Object)this.ec2InstanceRegionText.getText());
        this.credsConfig.saveIAMAuthSettings(configuration.getSecureProperties());
    }

    public void resetSettings(@NotNull DBWHandlerConfiguration configuration) {
        DBPDataSourceContainer dataSource = configuration.getDataSource();
        if (dataSource != null) {
            this.credsConfig.resetSettings(dataSource);
        }
    }

    public boolean isComplete() {
        return this.credsConfig.isComplete();
    }
}

