/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.aws.prefs;

import com.dbeaver.net.auth.aws.AuthModelAWSPreferences;
import com.dbeaver.ui.auth.aws.AuthModelAWSMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageAwsConfiguration
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.dbeaver.preferences.aws";
    private TextWithOpen awsCliExecutablePath;
    private TextWithOpen awsSsmPluginExecutablePath;

    public PrefPageAwsConfiguration() {
        this.setTitle("AWS preferences");
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Group cliGroup = UIUtils.createControlGroup((Composite)parent, (String)AuthModelAWSMessages.pref_aws_config_cli_group, (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)cliGroup, (String)AuthModelAWSMessages.pref_aws_config_cli_executable_label);
        this.awsCliExecutablePath = new TextWithOpenFile((Composite)cliGroup, AuthModelAWSMessages.pref_aws_config_cli_executable_title, new String[]{"*.exe", "*.*"});
        this.awsCliExecutablePath.setLayoutData((Object)new GridData(4, 1, true, false));
        this.awsCliExecutablePath.setText(AuthModelAWSPreferences.getPreferences().getString("aws.cli.executable"));
        UIUtils.createInfoLabel((Composite)cliGroup, (String)AuthModelAWSMessages.pref_aws_config_cli_tip, (int)768, (int)2);
        UIUtils.createControlLabel((Composite)cliGroup, (String)AuthModelAWSMessages.pref_aws_config_ssm_plugin_path_label);
        this.awsSsmPluginExecutablePath = new TextWithOpenFolder((Composite)cliGroup, AuthModelAWSMessages.pref_aws_config_ssm_plugin_path_title);
        this.awsSsmPluginExecutablePath.setLayoutData((Object)new GridData(4, 1, true, false));
        this.awsSsmPluginExecutablePath.setText(AuthModelAWSPreferences.getPreferences().getString("aws.ssm.plugin.folder"));
        UIUtils.createInfoLabel((Composite)cliGroup, (String)AuthModelAWSMessages.pref_aws_config_ssm_tip, (int)768, (int)2);
        Link ssoDocsLink = new Link((Composite)cliGroup, 0);
        ssoDocsLink.setText(NLS.bind((String)AuthModelAWSMessages.pref_aws_config_cli_link, (Object)"<a>", (Object)"</a>"));
        ssoDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"AWS-SSO"));
            }
        });
        return cliGroup;
    }

    protected void performDefaults() {
        this.awsCliExecutablePath.setText("");
        this.awsSsmPluginExecutablePath.setText("");
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = AuthModelAWSPreferences.getPreferences();
        store.setValue("aws.cli.executable", this.awsCliExecutablePath.getText());
        store.setValue("aws.ssm.plugin.folder", this.awsSsmPluginExecutablePath.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }
}

