/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class XYLayout
extends AbstractLayout {
    protected Map<IFigure, Rectangle> constraints = new HashMap<IFigure, Rectangle>();

    @Override
    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Rectangle rect = new Rectangle();
        for (IFigure iFigure : f.getChildren()) {
            Rectangle r = this.constraints.get(iFigure);
            if (r == null) continue;
            if (r.width == -1 || r.height == -1) {
                Dimension preferredSize = iFigure.getPreferredSize(r.width, r.height);
                r = r.getCopy();
                if (r.width == -1) {
                    r.width = preferredSize.width;
                }
                if (r.height == -1) {
                    r.height = preferredSize.height;
                }
            }
            rect.union(r);
        }
        Dimension dimension = rect.getSize();
        Insets insets = f.getInsets();
        return new Dimension(dimension.width + insets.getWidth(), dimension.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    @Override
    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    @Override
    public void layout(IFigure parent) {
        Point offset = this.getOrigin(parent);
        for (IFigure iFigure : parent.getChildren()) {
            Rectangle bounds = (Rectangle)this.getConstraint(iFigure);
            if (bounds == null) continue;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = iFigure.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            iFigure.setBounds(bounds);
        }
    }

    @Override
    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            void rect;
            Object object = newConstraint;
            if (!(object instanceof Rectangle)) {
                throw new IllegalArgumentException("XYLayout was given " + newConstraint.getClass().getName() + " as constraint for Figure. Rectangle expected!");
            }
            Rectangle rectangle = (Rectangle)object;
            Rectangle cfr_ignored_0 = (Rectangle)object;
            this.constraints.put(figure, (Rectangle)rect);
        }
    }
}

