/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeSettings;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public class ERDContentProviderDefault
implements ERDContentProvider {
    private static final Log log = Log.getLog(ERDContentProviderDefault.class);
    private static final boolean READ_LAZY_DESCRIPTIONS = false;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public boolean allowEntityDuplicates() {
        return false;
    }

    @Override
    public void fillEntityFromObject(@NotNull DBRProgressMonitor monitor, @NotNull ERDDiagram diagram, @NotNull List<ERDEntity> otherEntities, @NotNull ERDEntity erdEntity) throws DBCException {
        this.fillEntityFromObject(monitor, diagram, otherEntities, erdEntity, new ERDAttributeSettings(ERDAttributeVisibility.ALL, false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillEntityFromObject(@NotNull DBRProgressMonitor monitor, @NotNull ERDDiagram diagram, @NotNull List<ERDEntity> otherEntities, @NotNull ERDEntity erdEntity, @NotNull ERDAttributeSettings settings) {
        DBSEntity entity = (DBSEntity)erdEntity.getObject();
        if (settings.getVisibility() == ERDAttributeVisibility.NONE) return;
        HashSet<? extends DBSEntityAttribute> keyColumns = new HashSet<DBSEntityAttribute>();
        try {
            for (DBSEntityAssociation assoc : DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)entity)) {
                if (!(assoc instanceof DBSEntityReferrer)) continue;
                keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)assoc)));
            }
            for (DBSEntityConstraint constraint : DBVUtils.getAllConstraints((DBRProgressMonitor)monitor, (DBSEntity)entity)) {
                if (!(constraint instanceof DBSEntityReferrer)) continue;
                keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)constraint)));
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        Collection<? extends DBSEntityAttribute> idColumns = null;
        try {
            idColumns = ERDUtils.getBestTableIdentifier(monitor, entity);
            keyColumns.addAll(idColumns);
        }
        catch (DBException e) {
            log.error((Object)"Error reading table identifier", (Throwable)e);
        }
        try {
            boolean attrNodesCached = false;
            List attributes = entity.getAttributes(monitor);
            if (CommonUtils.isEmpty((Collection)attributes)) {
                return;
            }
            DBSEntityAttribute firstAttr = (DBSEntityAttribute)attributes.iterator().next();
            DBSObjectFilter columnFilter = entity.getDataSource().getContainer().getObjectFilter(firstAttr.getClass(), (DBSObject)entity, false);
            int i = 0;
            while (i < attributes.size()) {
                block15: {
                    boolean isInIdentifier;
                    DBSEntityAttribute attribute = (DBSEntityAttribute)attributes.get(i);
                    boolean bl = isInIdentifier = idColumns != null && idColumns.contains(attribute);
                    if (!this.isAttributeVisible(erdEntity, attribute) || columnFilter != null && !columnFilter.matches(attribute.getName())) break block15;
                    if (!attrNodesCached) {
                        DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)attribute, (boolean)false);
                        attrNodesCached = true;
                    }
                    switch (settings.getVisibility()) {
                        case PRIMARY: {
                            if (isInIdentifier) break;
                            break block15;
                        }
                        case KEYS: {
                            if (!keyColumns.contains(attribute)) break block15;
                        }
                    }
                    boolean inPrimaryKey = idColumns != null && idColumns.contains(attribute);
                    ERDEntityAttribute c1 = new ERDEntityAttribute(attribute, inPrimaryKey);
                    erdEntity.addAttribute(c1, false);
                }
                ++i;
            }
            if (!settings.isAlphabeticalOrder()) return;
            erdEntity.sortAttributes(DBUtils.nameComparatorIgnoreCase(), false);
            return;
        }
        catch (DBException e) {
            log.debug((Object)("Can't load table '" + entity.getName() + "'attributes"), (Throwable)e);
        }
    }

    protected boolean isAttributeVisible(ERDEntity erdEntity, DBSEntityAttribute attribute) {
        if (attribute instanceof DBSEntityAssociation) {
            return false;
        }
        return !DBUtils.isHiddenObject((Object)attribute) && !DBUtils.isInheritedObject((Object)attribute);
    }

    @Override
    public ERDAssociation createAutoAssociation(ERDContainer diagram, @NotNull DBSEntityAssociation association, @NotNull ERDEntity sourceEntity, @NotNull ERDEntity targetEntity, boolean reflect) {
        ERDAssociation erdAssociation = new ERDAssociation(association, sourceEntity, targetEntity, reflect);
        erdAssociation.resolveAttributes();
        return erdAssociation;
    }

    @Override
    public ERDAssociation createAssociation(ERDContainer diagram, DBSEntityAssociation association, ERDEntity sourceEntity, ERDEntityAttribute sourceAttribute, ERDEntity targetEntity, ERDEntityAttribute targetAttribute, boolean reflect) {
        ERDAssociation erdAssociation = new ERDAssociation(association, sourceEntity, targetEntity, reflect);
        erdAssociation.addCondition(sourceAttribute, targetAttribute);
        return erdAssociation;
    }

    @Override
    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

