/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import java.sql.SQLException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class NetezzaTableCache
extends TableCache {
    private static final Log log = Log.getLog(NetezzaTableCache.class);
    private String curSessionCatalog;

    NetezzaTableCache(GenericDataSource dataSource) {
        super(dataSource);
    }

    public void beforeCacheLoading(JDBCSession session, GenericStructContainer owner) throws DBException {
        try {
            this.curSessionCatalog = session.getCatalog();
            GenericCatalog catalog = owner.getCatalog();
            if (!CommonUtils.equalObjects((Object)this.curSessionCatalog, (Object)catalog.getName())) {
                session.setCatalog(catalog.getName());
            } else {
                this.curSessionCatalog = null;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't set session catalog.", (Throwable)e);
        }
    }

    public void afterCacheLoading(JDBCSession session, GenericStructContainer owner) {
        if (this.curSessionCatalog != null) {
            try {
                session.setCatalog(this.curSessionCatalog);
            }
            catch (Exception e) {
                log.debug((Object)"Can't return session catalog.", (Throwable)e);
            }
        }
    }
}

