/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.util;

import java.net.InetAddress;
import java.util.StringTokenizer;

public class MachineInfo {
    private static final String loopBackAddress = "127.0.0.1";
    private static String exeName = "java.exe";
    private static String ipAddress;
    private static String[] ipAddressArray;
    private static String hostName;
    private static String myUserName;
    private static byte[] osInfo;

    private static void setIPAddress() {
        InetAddress[] iptest = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostName = ia.getHostName();
            ipAddress = ia.getHostAddress();
            iptest = InetAddress.getAllByName(hostName);
            ipAddressArray = new String[iptest.length];
            for (int counter = 0; counter < iptest.length; ++counter) {
                MachineInfo.ipAddressArray[counter] = iptest[counter].getHostAddress();
            }
        }
        catch (Exception e) {
            hostName = "localhost";
            ipAddress = loopBackAddress;
            ipAddressArray = new String[1];
            MachineInfo.ipAddressArray[0] = loopBackAddress;
        }
    }

    public static String getIPAddress(String connectIP) {
        if (connectIP.regionMatches(0, loopBackAddress, 0, 4)) {
            return loopBackAddress;
        }
        for (int counter = 0; counter < ipAddressArray.length; ++counter) {
            if (!ipAddressArray[counter].regionMatches(0, connectIP, 0, ipAddressArray[counter].length())) continue;
            return loopBackAddress;
        }
        return ipAddress;
    }

    public static String getUserName() {
        return myUserName;
    }

    private static void setUserName() {
        myUserName = System.getProperty("user.name");
    }

    public static String getMachineName() {
        return hostName;
    }

    public static String getExeName() {
        return exeName;
    }

    private static void setExeName() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        exeName = stack[stack.length - 1].getClassName();
    }

    public static byte[] getOSInfo() {
        return osInfo;
    }

    private static void setOSInfo() {
        short MajorVersion = 0;
        short MinorVersion = 0;
        String osVersion = System.getProperty("os.version");
        StringTokenizer osTokens = new StringTokenizer(osVersion, ".");
        while (osTokens.hasMoreTokens()) {
            try {
                MajorVersion = Short.parseShort(osTokens.nextToken());
                break;
            }
            catch (Exception e) {
            }
        }
        while (osTokens.hasMoreTokens()) {
            try {
                MinorVersion = Short.parseShort(osTokens.nextToken());
                break;
            }
            catch (Exception e) {
            }
        }
        MachineInfo.osInfo[0] = (byte)(MajorVersion & 0xFF);
        MachineInfo.osInfo[1] = (byte)(MajorVersion >> 8);
        MachineInfo.osInfo[2] = (byte)(MinorVersion & 0xFF);
        MachineInfo.osInfo[3] = (byte)(MinorVersion >> 8);
        String osName = System.getProperty("os.name");
        int PlatformID = osName.equalsIgnoreCase("Windows 95") ? 1 : (osName.equalsIgnoreCase("Windows 98") ? 1 : (osName.equalsIgnoreCase("Windows ME") ? 1 : (osName.equalsIgnoreCase("Windows NT") ? 2 : (osName.equalsIgnoreCase("Windows 2000") ? 2 : (osName.equalsIgnoreCase("Windows XP") ? 2 : (osName.regionMatches(true, 0, "Windows", 0, 7) ? 2 : (osName.equalsIgnoreCase("AIX") ? 64 : (osName.equalsIgnoreCase("Digital Unix") ? 65 : (osName.equalsIgnoreCase("FreeBSD") ? 66 : (osName.equalsIgnoreCase("HP-UX") ? 67 : (osName.equalsIgnoreCase("Linux") ? 68 : (osName.equalsIgnoreCase("Solaris") ? 69 : (osName.equalsIgnoreCase("Irix") ? 70 : (osName.equalsIgnoreCase("Mac OS") ? 71 : (osName.equalsIgnoreCase("OS/2") ? 78 : 255)))))))))))))));
        MachineInfo.osInfo[8] = (byte)(PlatformID & 0xFF);
        MachineInfo.osInfo[9] = (byte)(PlatformID >> 8);
        String osArch = System.getProperty("os.arch");
        int ProcessorArchitecture = osArch.equalsIgnoreCase("x86") ? 0 : (osArch.equalsIgnoreCase("Pentium") ? 0 : (osArch.equalsIgnoreCase("Alpha") ? 1 : (osArch.equalsIgnoreCase("MIPS") ? 2 : (osArch.regionMatches(true, 0, "Power", 0, 5) ? 3 : (osArch.equalsIgnoreCase("sparc") ? 16 : (osArch.equalsIgnoreCase("PA-RISC") ? 17 : 255))))));
        MachineInfo.osInfo[10] = (byte)(ProcessorArchitecture & 0xFF);
        MachineInfo.osInfo[11] = (byte)(ProcessorArchitecture >> 8);
    }

    public static void main(String[] args) {
        System.out.print("\nMachineInfo class\n");
        String test = MachineInfo.getIPAddress("192.168.1.101");
        System.out.print("\n" + test + "\n");
        System.out.print("\nUser Name: " + MachineInfo.getUserName() + "\n");
        System.out.print("\nHost Name: " + MachineInfo.getMachineName() + "\n");
        System.out.print("\nInitial Class Application Name: " + MachineInfo.getExeName() + "\n");
    }

    static {
        ipAddressArray = null;
        osInfo = new byte[12];
        MachineInfo.setExeName();
        MachineInfo.setOSInfo();
        MachineInfo.setIPAddress();
        MachineInfo.setUserName();
    }
}

